/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.layout;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Measurement;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.content.DateTimeValue;
import com.adobe.xfa.content.DateValue;
import com.adobe.xfa.content.DecimalValue;
import com.adobe.xfa.content.ExDataValue;
import com.adobe.xfa.content.FloatValue;
import com.adobe.xfa.content.IntegerValue;
import com.adobe.xfa.content.TextValue;
import com.adobe.xfa.content.TimeValue;
import com.adobe.xfa.font.GfxTextAttrs;
import com.adobe.xfa.gfx.GFXColour;
import com.adobe.xfa.layout.BoxModelLayout;
import com.adobe.xfa.layout.BoxModelRenderProxy;
import com.adobe.xfa.layout.LayoutEnv;
import com.adobe.xfa.layout.LayoutHandler;
import com.adobe.xfa.template.TemplateResolver;
import com.adobe.xfa.template.containers.Draw;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextBaselineShift;
import com.adobe.xfa.text.TextDisplay;
import com.adobe.xfa.text.TextMeasurement;
import com.adobe.xfa.text.TextPosn;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextRange;
import com.adobe.xfa.text.TextRegion;
import com.adobe.xfa.text.markup.MarkupRtfOut;
import com.adobe.xfa.text.markup.MarkupXHTMLAttr;
import com.adobe.xfa.text.markup.MarkupXHTMLIn;
import com.adobe.xfa.text.markup.MarkupXHTMLOut;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.ut.UnitSpan;
import java.util.ArrayList;
import java.util.List;

abstract class BoxModelCaptionable
extends BoxModelRenderProxy {
    protected boolean m_bReserveCaptionSpace = false;
    protected UnitSpan m_oReserveCaptionSpace = UnitSpan.ZERO;
    protected int m_eCaptionPlacement = 0x400003;
    protected int m_eCaptionPresence = 1076494336;
    protected UnitSpan m_oLineHeight = UnitSpan.ZERO;
    protected Rect m_oCaptionDisplayExtent = Rect.ZERO;
    protected boolean m_bSplitCaption = false;
    protected TextPosn m_oStartCaptionPosn = new TextPosn();
    protected TextPosn m_oEndCaptionPosn = new TextPosn();
    protected boolean m_bKeepCaptionTextStream = false;
    protected boolean m_bAllowRenderProxy;

    public BoxModelCaptionable(LayoutEnv oEnv, boolean bAllowRenderProxy) {
        super(oEnv);
        this.m_bAllowRenderProxy = bAllowRenderProxy;
    }

    @Override
    public void clear() {
        this.m_bKeepCaptionTextStream = false;
        this.m_bReserveCaptionSpace = false;
        this.m_eCaptionPlacement = 0x400003;
        this.m_eCaptionPresence = 1076494336;
        this.m_bSplitCaption = false;
        this.m_bKeepCaptionTextStream = false;
        this.m_oReserveCaptionSpace = UnitSpan.ZERO;
        super.clear();
    }

    @Override
    public void reinitialize(Element oNode) {
        if (!this.m_bKeepCaptionTextStream) {
            super.reinitialize(oNode);
            return;
        }
        assert (oNode != null);
        this.initialize(oNode);
    }

    @Override
    public boolean allowRenderProxy() {
        return this.m_bAllowRenderProxy;
    }

    @Override
    public Rect getContentExtent() {
        if (this.hasCaption()) {
            return this.m_oContentExtent;
        }
        return super.getContentExtent();
    }

    @Override
    public Rect getContentBorderExtent() {
        Rect oCE = this.getContentExtent();
        return new Rect(oCE.left().add(this.m_oContentBorderMargins.marginLeft()).subtract(this.m_oContMargins.marginLeft()), oCE.top().add(this.m_oContentBorderMargins.marginTop()).subtract(this.m_oContMargins.marginTop()), oCE.right().subtract(this.m_oContentBorderMargins.marginRight()).add(this.m_oContMargins.marginRight()), oCE.bottom().subtract(this.m_oContentBorderMargins.marginBottom()).add(this.m_oContMargins.marginBottom()));
    }

    @Override
    public Rect getCaptionExtent() {
        if (this.hasCaption()) {
            return this.m_oCaptionExtent;
        }
        return super.getCaptionExtent();
    }

    @Override
    public abstract boolean hasContent();

    @Override
    public abstract String getContentByType(String var1, List<TemplateResolver.RGB> var2, List<String> var3);

    @Override
    public abstract boolean enumerateContent(LayoutHandler var1, CoordPair var2, boolean var3, boolean var4, Rect var5);

    @Override
    public boolean enumerateCaption(LayoutHandler pHandler, CoordPair oLocalOrigin, boolean bTruncate, Rect oInvalidatedRect) {
        boolean bTextFits = true;
        if (this.hasCaption() && this.hasVisibleCaption()) {
            CoordPair oNewOrigin = oLocalOrigin;
            Rect oInvalid = oInvalidatedRect;
            if (oInvalid.width().equals(UnitSpan.ZERO) && oInvalid.height().equals(UnitSpan.ZERO)) {
                oInvalid = Rect.ZERO;
            }
            if (this.m_bSplitCaption) {
                oInvalid = this.m_oCaptionDisplayExtent;
                oNewOrigin = new CoordPair(oNewOrigin.x(), oNewOrigin.y().subtract(this.m_oCaptionDisplayExtent.top()));
            }
            boolean bSplitCaptionFits = true;
            if (this.m_oCaptionDisplayExtent.width().gt(this.getCaptionExtent().width())) {
                oInvalid = oInvalid.width(this.getCaptionExtent().width(), false);
                bSplitCaptionFits = false;
            }
            if (this.m_oCaptionDisplayExtent.height().gt(this.getCaptionExtent().height())) {
                oInvalid = oInvalid.height(this.getCaptionExtent().height(), false);
                bSplitCaptionFits = false;
            }
            bTextFits = this.m_oGfxLayoutEnv.renderText(pHandler, this.getCaptionDisplay(), oNewOrigin, false, bTruncate, this.m_oRotationAngle, oInvalid);
            if (this.m_bSplitCaption) {
                return bSplitCaptionFits;
            }
        }
        return bTextFits;
    }

    @Override
    public String getCaptionByType(String sType, List<TemplateResolver.RGB> colorTable, List<String> fontTable) {
        if (this.hasCaption() && null != this.getCaption()) {
            return this.getStringByType(this.getCaption(), null, sType, this.m_oStartCaptionPosn, this.m_oEndCaptionPosn, colorTable, fontTable);
        }
        return "";
    }

    @Override
    public abstract void resizeToNominal(UnitSpan var1, UnitSpan var2, Element var3);

    @Override
    public abstract void resizeToNominalWidth(UnitSpan var1, Element var2);

    @Override
    public abstract void resizeToContent(UnitSpan var1, UnitSpan var2, Element var3);

    @Override
    public abstract boolean splitImpl(UnitSpan var1, BoxModelLayout var2, Element var3);

    @Override
    public boolean isFontSubstituted() {
        boolean bIsFontSubstituted = false;
        TextDisplay pDisp = this.getCaptionDisplay();
        if (pDisp != null) {
            bIsFontSubstituted = pDisp.hasFontSubstitution();
        }
        return bIsFontSubstituted;
    }

    public boolean getKeepCaptionTextStreamFlag() {
        return this.m_bKeepCaptionTextStream;
    }

    public void setKeepCaptionTextStreamFlag(boolean bKeepTextStream) {
        this.m_bKeepCaptionTextStream = bKeepTextStream;
    }

    public abstract void update(Element var1);

    public TextDisplay getCaptionDisplay() {
        return null;
    }

    public TextRegion getCaption() {
        return null;
    }

    public TextRange getCaptionRangeAttrs() {
        return null;
    }

    protected void setVertAlign(int eVAlign, TextAttr attr) {
        if (eVAlign == 0x3E0000) {
            attr.justifyV(1);
        } else if (eVAlign == 4063233) {
            attr.justifyV(2);
        } else if (eVAlign == 4063234) {
            attr.justifyV(3);
        } else {
            attr.justifyV(0);
        }
    }

    protected void setHorizAlign(int eHAlign, TextAttr attr) {
        if (eHAlign == 0x160000) {
            attr.justifyH(5);
        } else if (eHAlign == 0x160001) {
            attr.justifyH(6);
        } else if (eHAlign == 1441794) {
            attr.justifyH(7);
        } else if (eHAlign == 1441795) {
            attr.justifyH(8);
        } else if (eHAlign == 1441796) {
            attr.justifyH(9);
        } else if (eHAlign == 1441797) {
            attr.justifyH(10);
        } else {
            attr.justifyH(4);
        }
    }

    protected void setFont(Element oFontNode, Element oParaNode, boolean bContentFont, TextAttr attr, String sLang) {
        assert (oFontNode != null);
        GfxTextAttrs oGfxExtras = new GfxTextAttrs();
        attr.fontService(this.m_oGfxLayoutEnv.fontService());
        attr.colour(oGfxExtras.m_oColour);
        attr.underline(oGfxExtras.m_eUndercode);
        attr.overline(oGfxExtras.m_eOvercode);
        attr.strikeout(oGfxExtras.m_eStrikeOut);
        attr.baselineShift(new TextBaselineShift(oGfxExtras.m_oBaseLineShift));
        boolean bLineSpace = false;
        attr.spaceBefore(TextMeasurement.ZERO);
        attr.spaceAfter(TextMeasurement.ZERO);
        attr.special(TextMeasurement.ZERO);
        attr.marginL(TextMeasurement.ZERO);
        attr.marginR(TextMeasurement.ZERO);
        if (oParaNode != null) {
            if (oParaNode.isPropertySpecified(XFA.LINEHEIGHTTAG, true, 0)) {
                Measurement oLineHeight = new Measurement(oParaNode.getAttribute(XFA.LINEHEIGHTTAG));
                if (!bContentFont) {
                    this.m_oLineHeight = oLineHeight.getUnitSpan();
                }
                attr.spacing(new TextMeasurement(oLineHeight.getUnitSpan()));
                bLineSpace = true;
            }
            if (oParaNode.isPropertySpecified(XFA.SPACEABOVETAG, true, 0)) {
                Measurement oSpaceBefore = new Measurement(oParaNode.getAttribute(XFA.SPACEABOVETAG));
                attr.spaceBefore(new TextMeasurement(oSpaceBefore.getUnitSpan()));
            }
            if (oParaNode.isPropertySpecified(XFA.SPACEBELOWTAG, true, 0)) {
                Measurement oSpaceAfter = new Measurement(oParaNode.getAttribute(XFA.SPACEBELOWTAG));
                attr.spaceAfter(new TextMeasurement(oSpaceAfter.getUnitSpan()));
            }
            if (oParaNode.isPropertySpecified(XFA.TEXTINDENTTAG, true, 0)) {
                Measurement oSpecial = new Measurement(oParaNode.getAttribute(XFA.TEXTINDENTTAG));
                attr.special(new TextMeasurement(oSpecial.getUnitSpan()));
            }
            if (oParaNode.isPropertySpecified(XFA.MARGINLEFTTAG, true, 0)) {
                Measurement oLeftIndent = new Measurement(oParaNode.getAttribute(XFA.MARGINLEFTTAG));
                attr.marginL(new TextMeasurement(oLeftIndent.getUnitSpan()));
            }
            if (oParaNode.isPropertySpecified(XFA.MARGINRIGHTTAG, true, 0)) {
                Measurement oRightIndent = new Measurement(oParaNode.getAttribute(XFA.MARGINRIGHTTAG));
                attr.marginR(new TextMeasurement(oRightIndent.getUnitSpan()));
            }
        }
        if (!bLineSpace) {
            UnitSpan oSpan = new UnitSpan(0.0, 17);
            attr.spacing(new TextMeasurement(oSpan));
        }
    }

    protected void setTabs(Attribute oTabsDefault, Attribute oTabStops, TextAttr attr) {
        boolean bTabStops;
        String sTabsDefault = oTabsDefault.toString();
        boolean bTabsDefault = !StringUtils.isEmpty(sTabsDefault);
        String sTabStops = oTabStops.toString();
        boolean bl = bTabStops = !StringUtils.isEmpty(sTabStops);
        if (bTabsDefault || bTabStops) {
            if (bTabsDefault) {
                MarkupXHTMLIn.tabDefault(sTabsDefault, attr, MarkupXHTMLAttr.getDefault());
            }
            if (bTabStops) {
                MarkupXHTMLIn.tabSet(sTabStops, attr, MarkupXHTMLAttr.getDefault());
            }
        }
    }

    protected void initCaption(Element oNode) {
        String sCaption = null;
        this.hasCaption(false);
        this.m_bReserveCaptionSpace = false;
        if (oNode instanceof Draw || oNode instanceof Field || oNode instanceof ExclGroup) {
            if (oNode.isPropertySpecified(XFA.CAPTIONTAG, true, 0)) {
                boolean bRichCaption = false;
                Element oCaption = oNode.peekElement(XFA.CAPTIONTAG, true, 0);
                this.m_eCaptionPresence = oCaption.getEnum(XFA.PRESENCETAG);
                Element oCapValue = oCaption.peekElement(XFA.VALUETAG, true, 0);
                Content oCapContent = (Content)oCapValue.getOneOfChild(true, true);
                this.m_eCaptionPlacement = oCaption.getEnum(XFA.PLACEMENTTAG);
                if (1076494338 == this.m_eCaptionPresence || 1076494339 == this.m_eCaptionPresence) {
                    return;
                }
                this.hasCaption(true);
                boolean bExData = oCapContent instanceof ExDataValue;
                if (bExData) {
                    String sContentType = oCapContent.getAttribute(XFA.CONTENTTYPETAG).toString();
                    bRichCaption = "text/html".equals(sContentType);
                }
                if (oCapContent instanceof TextValue) {
                    sCaption = ((TextValue)oCapContent).getValue();
                } else if (oCapContent instanceof DecimalValue) {
                    double dTemp = ((DecimalValue)oCapContent).getValue();
                    sCaption = Double.toString(dTemp);
                } else if (oCapContent instanceof IntegerValue) {
                    int nTemp = ((IntegerValue)oCapContent).getValue();
                    sCaption = Integer.toString(nTemp);
                } else if (oCapContent instanceof FloatValue) {
                    double dTemp = ((FloatValue)oCapContent).getValue();
                    sCaption = Double.toString(dTemp);
                } else if (oCapContent instanceof DateValue) {
                    sCaption = ((DateValue)oCapContent).getValue();
                } else if (oCapContent instanceof DateTimeValue) {
                    sCaption = ((DateTimeValue)oCapContent).getValue();
                } else if (oCapContent instanceof TimeValue) {
                    sCaption = ((TimeValue)oCapContent).getValue();
                } else if (oCapContent instanceof ExDataValue) {
                    AppModel appModel = oCapContent.getAppModel();
                    boolean bLegacy = appModel.getLegacySetting(AppModel.XFA_LEGACY_V27_XHTMLVERSIONPROCESSING);
                    if (bExData && !bRichCaption) {
                        sCaption = ((ExDataValue)oCapContent).getValue(false, false, bLegacy);
                    }
                }
                if (!this.m_bKeepCaptionTextStream) {
                    AppModel appModel;
                    boolean bLegacy;
                    TextAttr oCaptionAttr = new TextAttr();
                    oCaptionAttr.transparent(true);
                    oCaptionAttr.fontService(this.m_oGfxLayoutEnv.fontService());
                    String sLang = oNode.getInstalledLocale();
                    if (!StringUtils.isEmpty(sLang)) {
                        oCaptionAttr.locale(sLang);
                    }
                    if (!this.hasInlineCaption()) {
                        Element oPara = oCaption.peekElement(XFA.PARATAG, true, 0);
                        int eCaptionVAlign = oPara.getEnum(XFA.VALIGNTAG);
                        int eCaptionHAlign = oPara.getEnum(XFA.HALIGNTAG);
                        if (1441796 == eCaptionHAlign && this.hasGrowableW()) {
                            eCaptionHAlign = 1441795;
                        }
                        this.setVertAlign(eCaptionVAlign, oCaptionAttr);
                        this.setHorizAlign(eCaptionHAlign, oCaptionAttr);
                        if (1441797 == eCaptionHAlign) {
                            UnitSpan oRO = new Measurement(oPara.getAttribute(XFA.RADIXOFFSETTAG)).getUnitSpan();
                            oCaptionAttr.radixOffset(new TextMeasurement(oRO));
                        }
                        this.setFont(oCaption.peekElement(XFA.FONTTAG, true, 0), oPara, false, oCaptionAttr, oCaption.getInstalledLocale());
                        this.m_bReserveCaptionSpace = oCaption.isPropertySpecified(XFA.RESERVETAG, true, 0);
                    } else {
                        this.m_bReserveCaptionSpace = false;
                    }
                    if (!bRichCaption || !StringUtils.isEmpty(sCaption = ((ExDataValue)oCapContent).getValue(true, false, bLegacy = (appModel = oCapContent.getAppModel()).getLegacySetting(AppModel.XFA_LEGACY_V27_XHTMLVERSIONPROCESSING)))) {
                        // empty if block
                    }
                    if (this.hasInlineCaption()) {
                        this.hasCaption(false);
                    }
                } else {
                    this.m_bReserveCaptionSpace = !this.hasInlineCaption() ? oCaption.isPropertySpecified(XFA.RESERVETAG, true, 0) : false;
                }
                if (this.m_bReserveCaptionSpace) {
                    assert (oCaption.isPropertySpecified(XFA.RESERVETAG, true, 0));
                    Measurement oMeas = new Measurement(oCaption.getAttribute(XFA.RESERVETAG));
                    this.m_oReserveCaptionSpace = oMeas.getUnitSpan();
                    if (UnitSpan.ZERO.gte(this.m_oReserveCaptionSpace)) {
                        this.m_bReserveCaptionSpace = false;
                    }
                }
                if (!this.m_bReserveCaptionSpace && this.hasCaption() && sCaption.length() != 0) {
                    throw new ExFull(ResId.UNSUPPORTED_OPERATION, "BoxModelCaptionable#initCaption");
                }
            } else {
                this.m_bKeepCaptionTextStream = false;
                this.m_bHasCaption = false;
                this.m_bReserveCaptionSpace = false;
                this.m_eCaptionPlacement = 0x400003;
                this.m_eCaptionPresence = 1076494336;
                this.m_bSplitCaption = false;
                this.m_bKeepCaptionTextStream = false;
                this.m_oCaptionExtent = Rect.ZERO;
                this.m_oContentExtent = Rect.ZERO;
                this.m_oReserveCaptionSpace = UnitSpan.ZERO;
            }
        }
        if (this.hasCaption()) {
            TextPosnBase oPosn = new TextPosnBase(this.getCaption());
            this.m_oStartCaptionPosn = new TextPosn(oPosn.stream());
            this.m_oEndCaptionPosn = new TextPosn(oPosn.stream());
            this.m_oStartCaptionPosn.first();
            this.m_oEndCaptionPosn.last();
        }
    }

    protected String getStringByType(TextRegion pTB, TextAttr poAmbientAttr, String sType, TextPosn oStart, TextPosn oEnd, List<TemplateResolver.RGB> colorTable, List<String> fontTable) {
        assert (null != pTB);
        assert (!StringUtils.isEmpty(sType));
        String sText = null;
        if (null != pTB) {
            if (sType.equals("rtf")) {
                ArrayList<GFXColour> oColours = new ArrayList<GFXColour>();
                if (null != colorTable) {
                    for (int i = 0; i < colorTable.size(); ++i) {
                        TemplateResolver.RGB rgb = colorTable.get(i);
                        oColours.add(new GFXColour(rgb.mnRed, rgb.mnGreen, rgb.mnBlue, 255));
                    }
                }
                TextRange oRange = new TextRange(pTB);
                oRange.start(oStart);
                oRange.end(oEnd);
                MarkupRtfOut oMarkupOut = new MarkupRtfOut(null, oColours, fontTable);
                oRange.markup(oMarkupOut, null, true, false);
                sText = oMarkupOut.translation();
            } else if (sType.equals("html")) {
                TextRange oRange = new TextRange(pTB);
                oRange.start(oStart);
                oRange.end(oEnd);
                MarkupXHTMLOut oMarkupOut = new MarkupXHTMLOut(null, 3, poAmbientAttr, true);
                oRange.markup(oMarkupOut, null, true, false);
                sText = oMarkupOut.translation();
            } else if (sType.equals("plain")) {
                TextRange oRange = new TextRange(pTB);
                oRange.start(oStart);
                oRange.end(oEnd);
                oRange.text(true);
            }
        }
        return sText;
    }

    protected boolean hasInlineCaption() {
        return 0x400004 == this.m_eCaptionPlacement;
    }

    protected boolean hasVisibleCaption() {
        return this.hasCaption() && 1076494336 == this.m_eCaptionPresence;
    }

    @Override
    public boolean hasOverflowingCaptionText() {
        return false;
    }
}

