/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;
import com.adobe.xfa.XFAList;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.form.FormDataListener;
import com.adobe.xfa.form.FormInstanceManager;
import com.adobe.xfa.form.FormListener;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.template.containers.Subform;
import java.util.ArrayList;
import java.util.List;

public class FormSubform
extends Subform {
    private FormInstanceManager mInstanceManager;
    private boolean mbIsLayoutNode;
    private FormDataListener mFormDataListener;
    private List<FormListener> mListenerTable;
    private boolean mbValidateRegistered;
    private boolean mbCalculateRegistered;

    public FormSubform(Element parent, Node prevSibling) {
        super(parent, prevSibling);
    }

    @Override
    public FormInstanceManager getInstanceManager() {
        return this.mInstanceManager;
    }

    @Override
    public DataNode getDataNode() {
        if (null != this.mFormDataListener) {
            return this.mFormDataListener.getDataNode();
        }
        return null;
    }

    @Override
    public void getDeltas(Element delta, XFAList list) {
        if (!this.isSameClass(delta)) {
            return;
        }
        FormModel model = (FormModel)this.getModel();
        if (model != null && model.isLoading()) {
            model.restoreValidateDisableAll(this, delta);
        }
        super.getDeltas(delta, list);
    }

    @Override
    public Node setElement(Node child, int eTag, int nOccurrence) {
        FormInstanceManager manager;
        if (eTag == XFA.OCCURTAG && (manager = this.getInstanceManager()) != null) {
            manager.setElement(child, eTag, nOccurrence);
        }
        return super.setElement(child, eTag, nOccurrence);
    }

    void setDataNode(DataNode dataNode, boolean bPeerNode) {
        if (dataNode == null || dataNode.getClassTag() != XFA.DATAGROUPTAG) {
            return;
        }
        if (bPeerNode) {
            if (this.mFormDataListener != null) {
                this.mFormDataListener.dispose();
                this.mFormDataListener = null;
            }
            this.mFormDataListener = new FormDataListener(this, dataNode);
        }
    }

    void setInstanceManager(FormInstanceManager instanceManager) {
        this.mInstanceManager = instanceManager;
    }

    @Override
    protected int getInstanceIndex(DependencyTracker dependencyTrack) {
        if (this.mInstanceManager != null) {
            if (dependencyTrack != null) {
                dependencyTrack.addDependency(this.mInstanceManager);
            }
            return this.mInstanceManager.findIndex(this);
        }
        return 0;
    }

    @Override
    public void setInstanceIndex(int nMoveTo) {
        if (this.mInstanceManager != null) {
            int nIndex = this.mInstanceManager.findIndex(this);
            this.mInstanceManager.moveInstance(nIndex, nMoveTo, true);
        }
    }

    List<FormListener> getFormListeners(boolean bCreate) {
        if (bCreate && this.mListenerTable == null) {
            this.mListenerTable = new ArrayList<FormListener>();
        }
        return this.mListenerTable;
    }

    void cleanupListeners() {
        if (this.mFormDataListener != null) {
            this.mFormDataListener.dispose();
            this.mFormDataListener = null;
        }
        if (this.mListenerTable != null) {
            this.mListenerTable.clear();
            this.mListenerTable = null;
        }
    }

    boolean isLayoutNode() {
        return this.mbIsLayoutNode;
    }

    void setLayoutNode() {
        this.mbIsLayoutNode = true;
    }

    @Override
    public void execEvent(String sActivity) {
        FormModel formModel = (FormModel)this.getModel();
        formModel.eventOccurred(sActivity, this);
    }

    @Override
    public boolean execValidate() {
        FormModel formModel = (FormModel)this.getModel();
        FormModel.Validate validate = formModel.getDefaultValidate();
        formModel.validate(validate, this, true, false);
        return validate == null || validate.getFailCount() <= 0;
    }

    public boolean getRegistered(int eActivity) {
        if (eActivity == XFA.VALIDATETAG) {
            return this.mbValidateRegistered;
        }
        if (eActivity == XFA.CALCULATETAG) {
            return this.mbCalculateRegistered;
        }
        return false;
    }

    void setRegistered(int eActivity) {
        if (eActivity == XFA.VALIDATETAG) {
            this.mbValidateRegistered = true;
        } else if (eActivity == XFA.CALCULATETAG) {
            this.mbCalculateRegistered = true;
        }
    }

    @Override
    public void notifyPeers(int eventType, String arg1, Object pArg2) {
        if (this.getModel() != null && this.getModel().isLoading()) {
            return;
        }
        if (!this.mbValidateRegistered && pArg2 instanceof FormModel.Validate && (eventType == 6 || eventType == 8)) {
            FormModel poFormModel = (FormModel)this.getModel();
            poFormModel.registerEvents(this, 4);
        }
        super.notifyPeers(eventType, arg1, pArg2);
    }
}

