/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.XFA;
import com.adobe.xfa.XFAList;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.form.FormDataListener;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.form.FormListener;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.containers.Field;
import java.util.ArrayList;
import java.util.List;

public class FormExclGroup
extends ExclGroup {
    private FormDataListener mDataListener;
    private Object mCPDField;
    private List<FormListener> mListenerTable;
    private boolean mbValidateRegistered;
    private boolean mbCalculateRegistered;

    @Override
    public void getDeltas(Element delta, XFAList list) {
        if (!this.isSameClass(delta)) {
            return;
        }
        FormModel model = (FormModel)this.getModel();
        if (model != null && model.isLoading()) {
            model.restoreValidateDisableAll(this, delta);
        }
        super.getDeltas(delta, list);
    }

    @Override
    public DataNode getDataNode() {
        if (null != this.getFormDataListener()) {
            return this.getFormDataListener().getDataNode();
        }
        return null;
    }

    FormExclGroup(Element parent, Node prevSibling) {
        super(parent, prevSibling);
    }

    private FormDataListener getFormDataListener() {
        return this.mDataListener;
    }

    void setDataNode(DataNode dataNode, boolean bUpdateData, boolean bPeerNode) {
        if (this.mDataListener != null && bPeerNode) {
            this.mDataListener.dispose();
            this.mDataListener = null;
        }
        if (dataNode == null) {
            return;
        }
        if (bPeerNode) {
            this.mDataListener = new FormDataListener(this, dataNode);
        }
        if (bPeerNode && null != this.getFormDataListener()) {
            this.getFormDataListener().deafen();
        }
        if (bUpdateData) {
            this.setData(dataNode);
        } else {
            this.setFromData(dataNode);
        }
        if (bPeerNode && null != this.getFormDataListener()) {
            this.getFormDataListener().unDeafen();
        }
    }

    void setFromData(DataNode dataNode) {
        if (dataNode == null && (dataNode = this.getDataNode()) == null) {
            return;
        }
        if (dataNode.getClassTag() == XFA.DATAVALUETAG) {
            DataNode dataValue = dataNode;
            this.setRawValue(dataValue.getValue());
        }
    }

    void setData(DataNode dataNode) {
        if (dataNode == null && (dataNode = this.getDataNode()) == null) {
            return;
        }
        if (dataNode.getClassTag() != XFA.DATAVALUETAG) {
            return;
        }
        if (this.getIsNull(false)) {
            dataNode.setIsNull(true, true);
            return;
        }
        DataNode dataValue = dataNode;
        dataValue.setValue(this.getRawValue(), true);
    }

    List<FormListener> getFormListeners(boolean bCreate) {
        if (bCreate && this.mListenerTable == null) {
            this.mListenerTable = new ArrayList<FormListener>();
        }
        return this.mListenerTable;
    }

    void cleanupListeners() {
        if (this.mDataListener != null) {
            this.mDataListener.dispose();
            this.mDataListener = null;
        }
        if (this.mListenerTable != null) {
            this.mListenerTable.clear();
            this.mListenerTable = null;
        }
    }

    @Override
    public boolean getIsNull() {
        return this.getIsNull(true);
    }

    private boolean getIsNull(boolean bCheckData) {
        NodeList children = this.getMembers();
        if (children == null) {
            return true;
        }
        DataNode dataNode = this.getDataNode();
        if (bCheckData && dataNode != null && dataNode.getClassTag() == XFA.DATAVALUETAG) {
            return dataNode.getIsNull();
        }
        for (int i = 0; i < children.length(); ++i) {
            if (((Field)children.item(i)).getIsNull()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void execEvent(String sActivity) {
        FormModel formModel = (FormModel)this.getModel();
        formModel.eventOccurred(sActivity, this);
    }

    @Override
    public boolean execValidate() {
        FormModel formModel = (FormModel)this.getModel();
        FormModel.Validate validate = formModel.getDefaultValidate();
        formModel.validate(validate, this, true, false);
        return validate == null || validate.getFailCount() <= 0;
    }

    public Object getCPDField() {
        return this.mCPDField;
    }

    public void setCPDField(Object oCPDField) {
        this.mCPDField = oCPDField;
    }

    public boolean getRegistered(int eActivity) {
        if (eActivity == XFA.VALIDATETAG) {
            return this.mbValidateRegistered;
        }
        if (eActivity == XFA.CALCULATETAG) {
            return this.mbCalculateRegistered;
        }
        return false;
    }

    void setRegistered(int eActivity) {
        if (eActivity == XFA.VALIDATETAG) {
            this.mbValidateRegistered = true;
        } else if (eActivity == XFA.CALCULATETAG) {
            this.mbCalculateRegistered = true;
        }
    }

    @Override
    public void notifyPeers(int eventType, String arg1, Object arg2) {
        if (this.getModel() != null && this.getModel().isLoading()) {
            return;
        }
        if (!this.mbValidateRegistered && arg2 instanceof FormModel.Validate) {
            FormModel formModel = (FormModel)this.getModel();
            formModel.registerEvents(this, 4);
        } else if (eventType == 7 && arg2 instanceof Content) {
            Element node = ((Content)arg2).getXFAParent();
            while (!(node instanceof Container)) {
                node = node.getXFAParent();
            }
            if (node instanceof FormField) {
                FormField field = (FormField)node;
                String sValue = field.getRawValue();
                String sOnValue = field.getOnValue();
                if (sOnValue != null && sOnValue.equals(sValue)) {
                    NodeList members = this.getMembers();
                    int nChildren = members.length();
                    for (int i = 0; i < nChildren; ++i) {
                        Field field2 = (Field)members.item(i);
                        sOnValue = field2.getOnValue();
                        if (sOnValue == null || sOnValue.equals(sValue)) continue;
                        field2.setOn(false);
                    }
                }
            }
        }
        super.notifyPeers(eventType, arg1, arg2);
    }
}

