/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.dom;

import com.adobe.xfa.Chars;
import com.adobe.xfa.dom.CharacterDataImpl;
import com.adobe.xfa.dom.CommentImpl;
import com.adobe.xfa.dom.NodeImpl;
import com.adobe.xfa.dom.ParentNode;
import com.adobe.xfa.dom.ProcessingInstructionImpl;
import com.adobe.xfa.dom.XFANodeHolder;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class TextImpl
extends CharacterDataImpl
implements Text {
    TextImpl(ParentNode parent, Chars newTextNode) {
        super(parent, newTextNode, newTextNode.getData());
    }

    @Override
    public String getWholeText() {
        XFANodeHolder prevNode;
        XFANodeHolder currentNode = this;
        while ((prevNode = currentNode.forcePrev()) != null && TextImpl.isBenignNode(prevNode)) {
            currentNode = prevNode;
        }
        StringBuilder textBuilder = new StringBuilder();
        while (currentNode != null && TextImpl.isBenignNode(currentNode)) {
            if (currentNode instanceof TextImpl) {
                XFANodeHolder textNode = currentNode;
                textBuilder.append(((CharacterDataImpl)textNode).getCharacterData());
            }
            currentNode = currentNode.forceNext();
        }
        return textBuilder.toString();
    }

    @Override
    public boolean isElementContentWhitespace() {
        return false;
    }

    @Override
    public boolean isEqualNode(Node other) {
        if (this == other) {
            return true;
        }
        if (!super.isEqualNode(other)) {
            return false;
        }
        return other instanceof TextImpl;
    }

    @Override
    public Text replaceWholeText(String content) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public Text splitText(int offset) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public String getNodeName() {
        return "#text";
    }

    @Override
    public short getNodeType() {
        return 3;
    }

    private static boolean isBenignNode(NodeImpl node) {
        return node instanceof TextImpl || node instanceof CommentImpl || node instanceof ProcessingInstructionImpl;
    }
}

