/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.dom;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.dom.NodeImpl;
import com.adobe.xfa.dom.NodeListImpl;
import com.adobe.xfa.dom.XFANodeHolder;
import org.w3c.dom.DOMException;
import org.w3c.dom.NodeList;

abstract class ParentNode
extends XFANodeHolder {
    private XFANodeHolder mFirstChild;
    private XFANodeHolder mLastChild;
    private final Element mXFAElement;

    ParentNode(ParentNode parent, Element newElement) {
        super(parent, newElement);
        this.mXFAElement = newElement;
    }

    @Override
    public NodeList getChildNodes() {
        this.fillAllChildren();
        NodeListImpl nodeList = new NodeListImpl(this.getXFAElement().getNumAttrs());
        nodeList.addNodes(this.getFirstChildImpl());
        return nodeList;
    }

    @Override
    public org.w3c.dom.Node getFirstChild() {
        this.fillChildrenFromStart();
        return this.mFirstChild;
    }

    @Override
    public org.w3c.dom.Node getLastChild() {
        this.fillChildrenToEnd();
        return this.mLastChild;
    }

    @Override
    public boolean hasChildNodes() {
        return this.mXFAElement.getFirstXMLChild() != null;
    }

    @Override
    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node newChild, org.w3c.dom.Node refChild) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public boolean isEqualNode(org.w3c.dom.Node other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ParentNode)) {
            return false;
        }
        ParentNode otherParent = (ParentNode)other;
        this.fillAllChildren();
        otherParent.fillAllChildren();
        NodeImpl thisChild = this.getFirstChildImpl();
        NodeImpl otherChild = otherParent.getFirstChildImpl();
        while (true) {
            if (thisChild == null) {
                return otherChild == null;
            }
            if (otherChild == null) {
                return false;
            }
            if (!thisChild.isEqualNode(otherChild)) {
                return false;
            }
            thisChild = thisChild.getNext();
            otherChild = otherChild.getNext();
        }
    }

    @Override
    public org.w3c.dom.Node removeChild(org.w3c.dom.Node oldCcild) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node oldChild, org.w3c.dom.Node newChild) throws DOMException {
        throw new DOMException(7, "");
    }

    final XFANodeHolder createNode(Node source) {
        return ParentNode.createNode(this, source);
    }

    abstract boolean testDefaultNamespace(String var1);

    final void fillAllChildren() {
        this.fillChildrenFromStart();
        this.fillChildrenToEnd();
    }

    XFANodeHolder forcePrev(NodeImpl child) {
        assert (child == this.mFirstChild);
        this.fillChildrenFromStart();
        NodeImpl prevNode = child.getPrev();
        assert (prevNode == null || prevNode instanceof XFANodeHolder);
        return (XFANodeHolder)prevNode;
    }

    XFANodeHolder forceNext(NodeImpl child) {
        assert (child == this.mLastChild);
        Node xfaChild = this.mLastChild.getXFANode();
        Node xfaNext = xfaChild.getNextXMLSibling();
        if (xfaNext == null) {
            return null;
        }
        XFANodeHolder newChild = this.createNode(xfaNext);
        newChild.setPrev(this.mLastChild);
        this.mLastChild.setNext(newChild);
        this.mLastChild = newChild;
        return this.mLastChild;
    }

    final XFANodeHolder getFirstChildImpl() {
        return this.mFirstChild;
    }

    final XFANodeHolder getLastChildImpl() {
        return this.mLastChild;
    }

    final Element getXFAElement() {
        return this.mXFAElement;
    }

    XFANodeHolder lookupXFAChild(Node xfaChild) {
        this.fillAllChildren();
        for (NodeImpl child = this.mFirstChild; child != null; child = child.getNext()) {
            assert (child instanceof XFANodeHolder);
            XFANodeHolder xfaNodeHolder = child;
            if (xfaNodeHolder.getXFANode() != xfaChild) continue;
            return xfaNodeHolder;
        }
        return null;
    }

    void setOnlyChild(XFANodeHolder child) {
        assert (this.mFirstChild == null);
        assert (this.mLastChild == null);
        this.mFirstChild = child;
        this.mLastChild = child;
    }

    private void fillChildrenFromStart() {
        Node firstXFAChild = this.mXFAElement.getFirstXMLChild();
        Node currentFirstXFAChild = null;
        if (this.mFirstChild != null) {
            currentFirstXFAChild = this.mFirstChild.getXFANode();
        }
        if (currentFirstXFAChild == firstXFAChild) {
            return;
        }
        assert (firstXFAChild != null);
        NodeImpl lastAdded = null;
        XFANodeHolder firstAdded = null;
        for (Node xfaNodeToAdd = firstXFAChild; xfaNodeToAdd != currentFirstXFAChild; xfaNodeToAdd = xfaNodeToAdd.getNextXMLSibling()) {
            XFANodeHolder newNode = this.createNode(xfaNodeToAdd);
            if (firstAdded == null) {
                firstAdded = newNode;
            } else {
                assert (lastAdded != null);
                lastAdded.setNext(newNode);
            }
            newNode.setPrev(lastAdded);
            lastAdded = newNode;
            if (this.mFirstChild == null) break;
            assert (xfaNodeToAdd != null);
        }
        if (this.mFirstChild == null) {
            this.mLastChild = lastAdded;
        } else {
            lastAdded.setNext(this.mFirstChild);
            this.mFirstChild.setPrev(lastAdded);
        }
        this.mFirstChild = firstAdded;
    }

    private void fillChildrenToEnd() {
        if (this.mLastChild == null) {
            this.fillChildrenFromStart();
            if (this.mLastChild == null) {
                return;
            }
        }
        while (this.forceNextChild() != null) {
        }
    }

    private NodeImpl forceNextChild() {
        Node xfaChild = this.mLastChild.getXFANode();
        Node xfaNext = xfaChild.getNextXMLSibling();
        if (xfaNext == null) {
            return null;
        }
        XFANodeHolder newChild = this.createNode(xfaNext);
        newChild.setPrev(this.mLastChild);
        this.mLastChild.setNext(newChild);
        this.mLastChild = newChild;
        return this.mLastChild;
    }
}

