/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.data;

import com.adobe.xfa.Arg;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.data.DataWindowFilter;
import com.adobe.xfa.data.DataWindowScript;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.IntegerHolder;
import com.adobe.xfa.ut.ResId;
import java.util.ArrayList;
import java.util.List;

public final class DataWindow
extends Obj {
    private static final int DEFAULT_GRANULARITY = 16;
    private String maRecordName;
    private boolean mbDefined;
    private boolean mbLazyLoading;
    private boolean mbUpToDate;
    private DataModel mDataModel;
    private final List<DataWindowFilter> mFilters = new ArrayList<DataWindowFilter>();
    private int mnAbsRecordIndex;
    private int mnCurrentRecordIndex;
    private int mnDesiredRecordsAfter;
    private int mnDesiredRecordsBefore;
    private int mnRecordLevel;
    private int mnRecordsAfter;
    private int mnRecordsBefore;
    private int mnSpecifiedRecordLevel;
    private final List<Integer> mRecordIndexes = new ArrayList<Integer>();
    private final ArrayList<DataNode> mRecords = new ArrayList(16);
    private Element mStartNode;

    void addFilter(DataWindowFilter oFilter) {
        this.mFilters.add(oFilter);
    }

    public void addRecordGroup(DataNode dataGroup) {
        if (this.mRecords.size() == 16) {
            this.mRecords.ensureCapacity(1024);
        }
        for (int i = 0; i < this.mFilters.size(); ++i) {
            DataWindowFilter f = this.mFilters.get(i);
            if (f.filterRecord(dataGroup, this.mnAbsRecordIndex)) continue;
            ++this.mnAbsRecordIndex;
            return;
        }
        this.mRecords.add(dataGroup);
        this.mRecordIndexes.add(this.mnAbsRecordIndex);
        ++this.mnAbsRecordIndex;
    }

    private void adjustRecordLevel(boolean bUseRecordName) {
        IntegerHolder recordLevel;
        assert (this.mnRecordLevel == 0);
        Element oNewRoot = this.findStartNode(this.mStartNode, true);
        if (oNewRoot == null) {
            return;
        }
        Document doc = oNewRoot.getOwnerDocument();
        for (Element parent = oNewRoot.getXFAParent(); parent != doc && parent != null; parent = parent.getXFAParent()) {
            ++this.mnRecordLevel;
        }
        this.mnRecordLevel += this.mnSpecifiedRecordLevel;
        if (bUseRecordName && this.maRecordName != null && this.findRecordByName(oNewRoot, recordLevel = new IntegerHolder(this.mnRecordLevel), this.maRecordName)) {
            this.mnRecordLevel = recordLevel.value;
        }
    }

    public int currentRecordNumber() {
        this.validate(false);
        return this.mnCurrentRecordIndex;
    }

    void dataGroupAddedOrRemoved(DataNode dataGroup, boolean bAdded) {
        DataNode oDomPeer;
        Element oParent;
        if (this.mDataModel == null) {
            return;
        }
        if (!this.mbUpToDate) {
            return;
        }
        if (this.mbLazyLoading) {
            return;
        }
        if (this.maRecordName != null && this.maRecordName != dataGroup.getName()) {
            return;
        }
        Element oAliasNode = this.mDataModel.getAliasNode();
        if (oAliasNode == dataGroup) {
            this.invalidate();
            return;
        }
        for (oParent = dataGroup; oParent != null && oParent != oAliasNode; oParent = oParent.getXFAParent()) {
        }
        if (oParent == null) {
            return;
        }
        if (this.mnRecordLevel == 0) {
            this.adjustRecordLevel(true);
            if (this.mnRecordLevel == 0) {
                return;
            }
        }
        if ((oDomPeer = dataGroup) == null) {
            return;
        }
        int nLevel = 1;
        for (Element parentCheck = oDomPeer.getXFAParent(); parentCheck != null; parentCheck = parentCheck.getXFAParent()) {
            if (++nLevel <= this.mnRecordLevel) continue;
            return;
        }
        if (nLevel == this.mnRecordLevel) {
            this.invalidate();
        }
    }

    private boolean findRecordByName(Element root, IntegerHolder recordLevel, String aRecordName) {
        String aName = root.getLocalName();
        String aNewName = this.mDataModel.getMapping(aName);
        if (aNewName != "") {
            aName = aNewName;
        }
        if (aRecordName == aName && !this.isExcluded(root)) {
            return recordLevel.value > 0;
        }
        for (Node node = root.getFirstXMLChild(); node != null; node = node.getNextXMLSibling()) {
            ++recordLevel.value;
            if (node instanceof Element && this.findRecordByName((Element)node, recordLevel, aRecordName)) {
                return recordLevel.value > 0;
            }
            --recordLevel.value;
        }
        return false;
    }

    private Element findStartNode(Element node, boolean bCheckParent) {
        String aNS;
        boolean bHasModelParent = false;
        if (bCheckParent && this.mDataModel.isCompatibleNS(aNS = node.getNS()) && node.getLocalName() == "datasets") {
            bHasModelParent = true;
        }
        if (!bHasModelParent && !this.isExcluded(node)) {
            return node;
        }
        for (Node childNode = node.getFirstXMLChild(); childNode != null; childNode = childNode.getNextXMLSibling()) {
            if (!(childNode instanceof Element)) continue;
            Element childElement = (Element)childNode;
            Element search = null;
            if (bHasModelParent) {
                String aNS2 = childElement.getNS();
                String aLocalName = childElement.getLocalName();
                if (this.mDataModel.isCompatibleNS(aNS2) && (aLocalName == "data" || aLocalName == "Data")) {
                    search = this.findStartNode(childElement, false);
                }
            } else {
                search = this.findStartNode(childElement, false);
            }
            if (search == null) continue;
            return search;
        }
        return null;
    }

    @Override
    public String getClassAtom() {
        return "dataWindow";
    }

    @Override
    public String getClassName() {
        return "dataWindow";
    }

    public Arg getScriptProperty(String sPropertyName) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "DataWindow#getScriptProperty");
    }

    @Override
    public ScriptTable getScriptTable() {
        return DataWindowScript.getScriptTable();
    }

    public void gotoRecord(int newRecord) {
        this.validate(false);
        if (this.mbDefined && newRecord == this.currentRecordNumber()) {
            return;
        }
        if (this.mbLazyLoading) {
            int newLastRecord = newRecord + this.mnDesiredRecordsAfter;
            if (newLastRecord < newRecord) {
                newLastRecord = Integer.MAX_VALUE;
            }
            if (this.mnCurrentRecordIndex + this.mnRecordsAfter < newLastRecord) {
                this.loadToRecord(newLastRecord);
            } else if (this.mRecords.get(newRecord) == null) {
                this.mbDefined = false;
                throw new ExFull(ResId.InvalidRecordException);
            }
        }
        if (newRecord < 0 || newRecord >= this.mRecords.size()) {
            this.mbDefined = false;
            return;
        }
        this.mnCurrentRecordIndex = newRecord;
        this.mbDefined = true;
        this.mnRecordsAfter = this.mRecords.size() - this.mnCurrentRecordIndex - 1;
        if (this.mnRecordsAfter > this.mnDesiredRecordsAfter) {
            this.mnRecordsAfter = this.mnDesiredRecordsAfter;
        }
        this.mnRecordsBefore = this.mnCurrentRecordIndex;
        if (this.mnRecordsBefore > this.mnDesiredRecordsBefore) {
            this.mnRecordsBefore = this.mnDesiredRecordsBefore;
        }
        this.notifyPeers(0, "record", null);
    }

    void initialize(DataModel root, Element startNode, int recordLevel, String aRecordName, int nDesiredRecordsBefore, int nDesiredRecordsAfter) {
        this.mbUpToDate = false;
        this.mStartNode = startNode;
        this.mnSpecifiedRecordLevel = recordLevel;
        this.maRecordName = aRecordName;
        Document doc = startNode.getOwnerDocument();
        this.mbLazyLoading = doc.isIncrementalLoad();
        this.mnDesiredRecordsBefore = nDesiredRecordsBefore;
        this.mnDesiredRecordsAfter = nDesiredRecordsAfter;
        this.mDataModel = root;
        if (this.mnRecordLevel == 0) {
            this.adjustRecordLevel(false);
        }
        if (this.maRecordName != null) {
            Element startNodeCopy = this.findStartNode(startNode, true);
            if (startNodeCopy == null) {
                this.mDataModel.addErrorList(new ExFull(ResId.CantFindRecordException), 3, null);
                return;
            }
            IntegerHolder recordLevelHolder = new IntegerHolder(this.mnRecordLevel);
            if (!this.findRecordByName(startNodeCopy, recordLevelHolder, this.maRecordName)) {
                if (!this.mbLazyLoading) {
                    this.mDataModel.addErrorList(new ExFull(ResId.CantFindRecordException), 3, null);
                    return;
                }
                Element e = doc.loadToNextElement(null);
                while (e != null) {
                    String aName = e.getLocalName();
                    if (aName == this.maRecordName && !this.isExcluded(e)) {
                        if (this.findRecordByName(startNodeCopy, recordLevelHolder, this.maRecordName)) break;
                        this.mDataModel.addErrorList(new ExFull(ResId.CantFindRecordException), 3, null);
                        return;
                    }
                    e = doc.loadToNextElement(null);
                }
                if (e == null) {
                    this.mDataModel.addErrorList(new ExFull(ResId.CantFindRecordException), 3, null);
                    return;
                }
            }
            this.mnRecordLevel = recordLevelHolder.value;
        }
    }

    private void invalidate() {
        this.mbUpToDate = false;
        this.mRecords.clear();
        this.mRecordIndexes.clear();
        this.notifyPeers(0, "", null);
    }

    public boolean isDefined() {
        this.validate(false);
        return this.mbDefined;
    }

    private boolean isExcluded(Element node) {
        String aNS = node.getNS();
        return this.mDataModel.isCompatibleNS(aNS) || this.mDataModel.excludeNS(aNS);
    }

    boolean isRecordDepth(Node node) {
        int nLevel = 1;
        Document oDoc = node.getOwnerDocument();
        for (Element parentCheck = node.getXMLParent(); parentCheck != null && parentCheck != oDoc; parentCheck = parentCheck.getXMLParent()) {
            if (++nLevel <= this.mnRecordLevel) continue;
            return false;
        }
        return nLevel == this.mnRecordLevel;
    }

    public boolean isRecordGroup(DataNode dataGroup) {
        if (this.maRecordName != null && this.maRecordName != dataGroup.getName()) {
            return false;
        }
        if (dataGroup.getXFAParent() == this.mDataModel) {
            return false;
        }
        Node peer = dataGroup.getXmlPeer();
        return this.isRecordDepth(peer);
    }

    public boolean isUpToDate() {
        return this.mbUpToDate;
    }

    private void loadToRecord(int newRecord) {
        assert (this.mbLazyLoading);
        if (newRecord < this.mnCurrentRecordIndex) {
            this.mbDefined = false;
            throw new ExFull(ResId.InvalidRecordException);
        }
        while (this.mDataModel.loadToNextRecord() != null) {
            int nWindowSize;
            int nRecordsSize = this.mRecords.size();
            if (nRecordsSize > (nWindowSize = this.mnDesiredRecordsAfter + this.mnDesiredRecordsBefore + 1)) {
                DataNode dataGroup;
                int nLast;
                int i = nLast = nRecordsSize - nWindowSize - 1;
                while ((dataGroup = this.mRecords.get(i)) != null) {
                    dataGroup.remove();
                    this.mRecords.set(i, null);
                    if (i == 0) break;
                    --i;
                }
            }
            if (nRecordsSize < newRecord) continue;
            return;
        }
    }

    public void moveCurrentRecord(int recordOffset) {
        this.validate(false);
        this.gotoRecord(this.currentRecordNumber() + recordOffset);
    }

    private void populate(DataNode root) {
        NodeList children = root.getNodes();
        int numChildren = children.length();
        for (int i = 0; i < numChildren; ++i) {
            DataNode node = (DataNode)children.item(i);
            if (!node.isSameClass("dataGroup")) continue;
            if (this.isRecordGroup(node)) {
                this.addRecordGroup(node);
                continue;
            }
            this.populate(node);
        }
    }

    void postLoad() {
        if (this.mbDefined) {
            // empty if block
        }
    }

    public DataNode record(int recordOffset) {
        this.validate(true);
        if (recordOffset < 0 && -recordOffset > this.recordsBefore()) {
            throw new ExFull(ResId.OutsideDataWindowException);
        }
        if (recordOffset > 0 && recordOffset > this.recordsAfter()) {
            throw new ExFull(ResId.OutsideDataWindowException);
        }
        return this.mRecords.get(recordOffset + this.mnCurrentRecordIndex);
    }

    public int recordAbsIndex(int recordOffset) {
        this.validate(true);
        if (recordOffset < 0 && -recordOffset > this.recordsBefore()) {
            throw new ExFull(ResId.OutsideDataWindowException);
        }
        if (recordOffset > 0 && recordOffset > this.recordsAfter()) {
            throw new ExFull(ResId.OutsideDataWindowException);
        }
        return this.mRecordIndexes.get(recordOffset + this.mnCurrentRecordIndex);
    }

    public int recordsAfter() {
        this.validate(true);
        return this.mnRecordsAfter;
    }

    public int recordsBefore() {
        this.validate(true);
        return this.mnRecordsBefore;
    }

    public boolean removeRecordGroup(DataNode dataGroup) {
        for (int i = 0; i < this.mRecords.size(); ++i) {
            if (this.mRecords.get(i) != dataGroup) continue;
            this.mRecords.remove(i);
            this.mRecordIndexes.remove(i);
            --this.mnAbsRecordIndex;
            return true;
        }
        return false;
    }

    private void reset() {
        this.mnCurrentRecordIndex = 0;
        this.mnRecordsBefore = 0;
        this.mnRecordsAfter = 0;
        this.mbDefined = false;
        if (this.mRecords.size() > 0) {
            this.mnRecordsAfter = this.mRecords.size() - 1;
            if (this.mnRecordsAfter > this.mnDesiredRecordsAfter) {
                this.mnRecordsAfter = this.mnDesiredRecordsAfter;
            }
            this.mbDefined = true;
        }
    }

    public void resetRecordDepth() {
        this.mnRecordLevel = 0;
        this.adjustRecordLevel(true);
        this.mbUpToDate = false;
        this.validate(false);
    }

    public void setScriptProperty(String sPropertyName, Arg propertyValue) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "DataWindow#setScriptProperty");
    }

    void uninitialize() {
        this.mnRecordLevel = 0;
        this.mDataModel = null;
        this.mStartNode = null;
    }

    public void updateAfterLoad() {
        if (this.mbLazyLoading) {
            int nLastRecord = this.mnDesiredRecordsAfter == Integer.MAX_VALUE ? Integer.MAX_VALUE : 1 + this.mnDesiredRecordsAfter;
            this.loadToRecord(nLastRecord);
        }
        this.mbUpToDate = true;
        this.reset();
    }

    private void validate(boolean bMustBeDefined) {
        if (!this.mbUpToDate && this.mDataModel != null) {
            this.invalidate();
            this.populate((DataNode)this.mDataModel.getAliasNode());
            this.reset();
            this.mbUpToDate = true;
        }
        if (bMustBeDefined && !this.mbDefined) {
            throw new ExFull(ResId.UndefinedDataWindowException);
        }
    }
}

