/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.data;

import com.adobe.xfa.Arg;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Chars;
import com.adobe.xfa.Comment;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumType;
import com.adobe.xfa.Generator;
import com.adobe.xfa.Model;
import com.adobe.xfa.ModelPeer;
import com.adobe.xfa.Node;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ProcessingInstruction;
import com.adobe.xfa.ScriptDynamicPropObj;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.data.DataNodeScript;
import com.adobe.xfa.data.DataWindow;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.PictureFmt;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringHolder;
import com.adobe.xfa.ut.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.xml.sax.Attributes;

public final class DataNode
extends Element
implements Element.DualDomNode {
    private String maName;
    private boolean mbContainsData;
    private boolean mbIsDDPlaceholder;
    private boolean mbIsNull;
    private boolean mbIsNullDetermined;
    private boolean mbIsTextNode;
    private DataNode mDataDescription;
    private int mnWeight;
    private TextNode mSingleTextChild;
    private PictureFormatInfo mPictureFormatInfo;
    private Node mXmlPeer;
    private static final ScriptDynamicPropObj resolveAssociationPropObj = new ScriptDynamicPropObj(31, 63){

        @Override
        public boolean invokeGetProp(Obj scriptThis, Arg retValue, String sPropertyName) {
            return DataNodeScript.scriptPropResolveAssociation(scriptThis, retValue, sPropertyName);
        }
    };

    public DataNode(Element parent, Node prevSibling, String uri, String localName, String qName, Attributes attributes) {
        super(parent, prevSibling, null, null, null, null, XFA.DATAGROUPTAG, "dataGroup");
        if (localName != null) {
            Element peerParent = parent instanceof Element.DualDomNode ? (Element)((Element.DualDomNode)((Object)parent)).getXmlPeer() : null;
            Node peerPrevSibling = null;
            Element xmlPeer = new Element(peerParent, peerPrevSibling, uri, localName, qName, attributes, XFA.INVALID_ELEMENT, null);
            this.setXmlPeer(xmlPeer);
            xmlPeer.setXfaPeer(this);
        }
    }

    public DataNode(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, null, null, null, XFA.DATAGROUPTAG, "dataGroup");
        Element peerParent = parent instanceof Element.DualDomNode ? (Element)((Element.DualDomNode)((Object)parent)).getXmlPeer() : null;
        Node peerPrevSibling = null;
        Element xmlPeer = new Element(peerParent, peerPrevSibling, "", "data", "xfa:data", null, XFA.INVALID_ELEMENT, null);
        this.setXmlPeer(xmlPeer);
        xmlPeer.setXfaPeer(this);
    }

    public DataNode(Element parent, Node prevSibling, String value) {
        super(parent, prevSibling, "", "", "", null, XFA.DATAVALUETAG, "dataValue");
        Element peerParent = parent instanceof Element.DualDomNode ? (Element)((Element.DualDomNode)((Object)parent)).getXmlPeer() : null;
        Node peerPrevSibling = null;
        TextNode xmlPeer = new TextNode(peerParent, peerPrevSibling, value);
        this.setXmlPeer(xmlPeer);
        xmlPeer.setXfaPeer(this);
    }

    @Override
    public void appendChild(Node oChild, boolean bValidate) {
        if (oChild.getClassTag() == XFA.DATAGROUPTAG) {
            if (this.getXmlPeer() != null && this.getXmlPeer().getXMLParent() == null && this.getLocalName().equals("data") && this.getModel().isCompatibleNS(((Element)this.getXmlPeer()).getNS())) {
                this.connectPeerToDocument();
            }
            super.appendChild(oChild, bValidate);
            DataModel model = (DataModel)this.getModel();
            DataWindow oDataWindow = model.getDataWindow();
            if (oDataWindow != null) {
                oDataWindow.dataGroupAddedOrRemoved((DataNode)oChild, true);
            }
        } else if (oChild.getClassTag() == XFA.DATAVALUETAG) {
            super.appendChild(oChild, bValidate);
            this.resetAfterUpdate((DataNode)oChild);
        }
    }

    @Override
    protected boolean canCreateChild(boolean bIsLeaf, String aName) {
        return ((DataModel)this.getModel()).canCreateChild(this, bIsLeaf, aName);
    }

    public void clearNull() {
        int eNullType;
        this.mbIsNullDetermined = false;
        this.mbIsNull = false;
        Node domPeer = this.getXmlPeer();
        if (domPeer instanceof Element && !(domPeer instanceof DataModel.AttributeWrapper)) {
            ((Element)domPeer).removeXsiNilAttribute();
        }
        if ((eNullType = this.getNullType()) == 5046273) {
            this.isTransient(false, false);
        }
    }

    @Override
    public Element clone(Element parent, boolean deep) {
        Node child;
        Node clonedDomNode;
        if (this.getClassTag() == XFA.DATAGROUPTAG) {
            DataNode clone = (DataNode)super.clone(parent, deep);
            clone.maName = this.maName;
            clone.mbIsDDPlaceholder = this.mbIsDDPlaceholder;
            clone.mDataDescription = this.mDataDescription;
            clone.mnWeight = this.mnWeight;
            return clone;
        }
        if (parent != null) {
            Element parentPeer = (Element)((Element.DualDomNode)((Object)parent)).getXmlPeer();
            if (this.getXmlPeer() instanceof DataModel.AttributeWrapper) {
                Attribute attr = ((DataModel.AttributeWrapper)this.getXmlPeer()).mAttribute;
                attr = parentPeer.setAttribute(attr.getNS(), attr.getQName(), attr.getLocalName(), attr.getAttrValue(), false);
                clonedDomNode = new DataModel.AttributeWrapper(attr, parentPeer);
            } else {
                clonedDomNode = parentPeer.getOwnerDocument() != this.getXmlPeer().getOwnerDocument() ? parentPeer.getOwnerDocument().importNode(this.getXmlPeer(), deep) : this.getXmlPeer().getOwnerDocument().importNode(this.getXmlPeer(), deep);
                parentPeer.appendChild(clonedDomNode);
            }
        } else if (this.getXmlPeer() instanceof DataModel.AttributeWrapper) {
            Attribute attr = ((DataModel.AttributeWrapper)this.getXmlPeer()).mAttribute;
            clonedDomNode = new DataModel.AttributeWrapper(attr, null);
        } else {
            clonedDomNode = this.getXmlPeer().getOwnerDocument().importNode(this.getXmlPeer(), deep);
        }
        DataModel dataModel = (DataModel)this.getModel();
        DataNode newNode = new DataNode(parent, null, null, null, null, null);
        newNode.setClass("dataValue", XFA.DATAVALUETAG);
        newNode.setModel(dataModel);
        newNode.setDocument(this.getOwnerDocument());
        newNode.setXmlPeer(clonedDomNode);
        clonedDomNode.setXfaPeer(newNode);
        if (deep && clonedDomNode instanceof Element) {
            Element clonedDomElement = (Element)clonedDomNode;
            if (dataModel.attributesAreValues()) {
                int numAttrs = clonedDomElement.getNumAttrs();
                for (int i = 0; i < numAttrs; ++i) {
                    Attribute attr = clonedDomElement.getAttr(i);
                    String aLocalName = attr.getLocalName();
                    boolean bSkipAttr = dataModel.loadSpecialAttribute(attr, aLocalName, newNode, true);
                    if (attr.isNameSpaceAttr()) {
                        bSkipAttr = true;
                    }
                    String aNamespaceURI = attr.getNS();
                    if (!bSkipAttr && dataModel.isCompatibleNS(aNamespaceURI)) {
                        bSkipAttr = true;
                    }
                    if (!bSkipAttr && DataModel.isDataDescriptionNS(aNamespaceURI)) {
                        bSkipAttr = true;
                    }
                    if (bSkipAttr) continue;
                    dataModel.loadNode(newNode, new DataModel.AttributeWrapper(attr, clonedDomElement), new Generator("", ""));
                }
            }
        }
        if ((child = clonedDomNode.getFirstXMLChild()) instanceof TextNode && child.getNextXMLSibling() == null) {
            newNode.singleTextChild((TextNode)child);
        } else {
            Node lastChild = clonedDomNode.getLastXMLChild();
            while (child != null) {
                Node next = child.getNextXMLSibling();
                if (child != null && (child instanceof Element || child instanceof TextNode)) {
                    dataModel.loadNode(newNode, child, new Generator("", ""));
                }
                if (child == lastChild) break;
                child = next;
            }
        }
        if (this.getLocked()) {
            newNode.setLocked(true);
        }
        return newNode;
    }

    @Override
    public Node createChild(boolean bIsLeaf, String aName) {
        boolean bCreateDataValue = this.getClassTag() == XFA.DATAGROUPTAG ? bIsLeaf : true;
        return this.getModel().createNode(bCreateDataValue ? XFA.DATAVALUETAG : XFA.DATAGROUPTAG, this, aName, "", true);
    }

    String formatDataValue(String sVal) {
        String sStr = sVal;
        if (this.mPictureFormatInfo != null) {
            String sLocale = this.mPictureFormatInfo.msLocale;
            if (StringUtils.isEmpty(sLocale)) {
                sLocale = this.getInstalledLocale();
            }
            boolean bSuccess = false;
            StringBuilder sFormatted = new StringBuilder();
            if (this.mbIsTextNode && PictureFmt.isTextPicture(this.mPictureFormatInfo.msPictureFormat)) {
                bSuccess = PictureFmt.formatText(sVal, this.mPictureFormatInfo.msPictureFormat, sLocale, sFormatted);
            }
            if (!bSuccess) {
                PictureFmt oPict = new PictureFmt(sLocale);
                bSuccess = oPict.format(sVal, this.mPictureFormatInfo.msPictureFormat, sFormatted);
            }
            if (bSuccess) {
                sStr = sFormatted.toString();
            }
        }
        return sStr;
    }

    public String getContains() {
        return this.mbContainsData ? "data" : "metaData";
    }

    public String getContentType() {
        if (this.getXmlPeer() instanceof DataModel.AttributeWrapper || this.getXmlPeer() instanceof TextNode) {
            return "";
        }
        Attribute attr = ((DataModel)this.getModel()).findAttrInNS(this, "contentType");
        if (attr != null) {
            return attr.getAttrValue();
        }
        for (Node child = this.getXmlPeer().getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (!(child instanceof Element)) continue;
            if (((Element)child).getNS() != "http://www.w3.org/1999/xhtml") break;
            return "text/html";
        }
        return "";
    }

    public DataNode getDataDescription() {
        return this.mDataDescription;
    }

    public boolean getIsDDPlaceholder() {
        return this.mbIsDDPlaceholder;
    }

    @Override
    public boolean getIsNull() {
        Element elementPeer;
        Attribute attr;
        if (this.getClassTag() == XFA.DATAGROUPTAG) {
            return false;
        }
        if (this.mbIsNullDetermined) {
            return this.mbIsNull;
        }
        this.mbIsNullDetermined = true;
        this.mbIsNull = false;
        Node domPeer = this.getXmlPeer();
        if (domPeer instanceof Element && !(domPeer instanceof DataModel.AttributeWrapper) && (attr = (elementPeer = (Element)domPeer).getXsiNilAttribute()) != null) {
            boolean bIsNull = attr.getAttrValue().equals("true");
            this.updateIsNull(bIsNull);
            return bIsNull;
        }
        int eNullType = this.getNullType();
        if (eNullType == 5046274 && StringUtils.isEmpty(this.getValue(false))) {
            this.mbIsNull = true;
        } else if (eNullType == 5046273 && this.isTransient()) {
            this.mbIsNull = true;
        }
        return this.mbIsNull;
    }

    @Override
    public String getName() {
        if (this.maName != null) {
            return this.maName;
        }
        return this.getLocalName();
    }

    @Override
    public String getLocalName() {
        if (this.getXmlPeer() instanceof Element) {
            return ((Element)this.getXmlPeer()).getLocalName();
        }
        if (this.getXmlPeer() instanceof TextNode) {
            return "";
        }
        assert (false);
        return "";
    }

    @Override
    public void setLocalName(String name) {
        if (this.getXmlPeer() instanceof Element) {
            ((Element)this.getXmlPeer()).setLocalName(name);
        } else if (!(this.getXmlPeer() instanceof TextNode)) assert (false);
    }

    @Override
    public String getXMLName() {
        if (this.getXmlPeer() instanceof Element) {
            return ((Element)this.getXmlPeer()).getXMLName();
        }
        if (this.getXmlPeer() instanceof TextNode) {
            return "";
        }
        assert (false);
        return "";
    }

    @Override
    public void setXMLName(String name) {
        if (this.getXmlPeer() instanceof Element) {
            ((Element)this.getXmlPeer()).setXMLName(name);
        } else assert (false);
    }

    @Override
    public String getNS() {
        if (this.mXmlPeer instanceof Element) {
            return ((Element)this.getXmlPeer()).getNS();
        }
        if (this.mXmlPeer instanceof TextNode) {
            return "";
        }
        assert (false);
        return "";
    }

    private int getNullType() {
        int eNullType = 5046274;
        if (this.mDataDescription != null) {
            Element dataDesc = this.mDataDescription;
            while (dataDesc instanceof DataNode) {
                int attr;
                DataNode dataNode = dataDesc;
                Node domPeer = dataNode.getXmlPeer();
                if ((domPeer instanceof Element && !(domPeer instanceof DataModel.AttributeWrapper) || domPeer instanceof TextNode) && (attr = dataNode.findAttr("http://ns.adobe.com/data-description/", "nullType")) != -1) {
                    EnumAttr oEnum = EnumAttr.getEnum(EnumType.getEnum(0x4D0000), dataNode.getAttrVal(attr));
                    eNullType = oEnum.getInt();
                    break;
                }
                dataDesc = dataDesc.getXFAParent();
            }
        }
        return eNullType;
    }

    @Override
    public String getData() {
        Node peer = this.getXmlPeer();
        if (peer instanceof DataModel.AttributeWrapper) {
            return ((DataModel.AttributeWrapper)peer).getValue();
        }
        if (peer instanceof TextNode) {
            return ((TextNode)peer).getValue();
        }
        return "";
    }

    @Override
    public Node getFirstXFAChild() {
        Node child;
        for (child = this.mFirstXMLChild; child != null && !DataNode.isScriptable(child); child = child.getNextXFASibling()) {
        }
        return child;
    }

    @Override
    public Node getNextXFASibling() {
        Node sibling;
        for (sibling = this.mNextXMLSibling; sibling != null && !DataNode.isScriptable(sibling); sibling = sibling.getNextXMLSibling()) {
        }
        return sibling;
    }

    @Override
    public ScriptTable getScriptTable() {
        return DataNodeScript.getScriptTable();
    }

    public String getValue() {
        return this.getValue(true);
    }

    public String getValue(boolean bUseNull) {
        if (bUseNull && this.getIsNull()) {
            return this.unformatDataValue(null);
        }
        StringBuilder textValue = new StringBuilder();
        if (this.getContentType().equals("text/html")) {
            this.getValuesFromDom(textValue, this.getXmlPeer());
            return this.unformatDataValue(textValue.toString());
        }
        if (this.singleTextChild() != null) {
            return this.unformatDataValue(this.singleTextChild().getValue());
        }
        textValue.append(this.getData());
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            String sValue;
            DataNode dChild;
            if (!child.isSameClass(XFA.DATAVALUETAG) || (dChild = (DataNode)child).isAttribute() || (sValue = dChild.getValue(true)) == null) continue;
            textValue.append(sValue);
        }
        return this.unformatDataValue(textValue.toString());
    }

    public boolean isAttribute() {
        return !this.mbContainsData;
    }

    private void getValuesFromDom(StringBuilder textValue, Node node) {
        if (node instanceof TextNode) {
            TextNode t = (TextNode)node;
            textValue.append(t.getValue());
        }
        for (Node child = node.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            this.getValuesFromDom(textValue, child);
        }
    }

    public int getWeight() {
        return this.mnWeight;
    }

    @Override
    public void insertChild(Node oChild, Node refChild, boolean bValidate) {
        if (oChild.getClassTag() == XFA.DATAGROUPTAG) {
            if (this.getXmlPeer() != null && this.getXmlPeer().getXMLParent() == null && this.getLocalName().equals("data") && this.getModel().isCompatibleNS(((Element)this.getXmlPeer()).getNS())) {
                this.connectPeerToDocument();
            }
            super.insertChild(oChild, refChild, bValidate);
            DataModel model = (DataModel)this.getModel();
            DataWindow oDataWindow = model.getDataWindow();
            if (oDataWindow != null) {
                oDataWindow.dataGroupAddedOrRemoved((DataNode)oChild, true);
            }
        } else if (oChild.getClassTag() == XFA.DATAVALUETAG) {
            super.insertChild(oChild, refChild, bValidate);
            this.resetAfterUpdate((DataNode)oChild);
        }
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    static boolean isScriptable(Node node) {
        assert (node != null);
        if (node.getClassTag() == XFA.INVALID_ELEMENT) {
            return false;
        }
        if (node.getClassTag() == XFA.TEXTNODETAG) {
            return false;
        }
        if (node instanceof Element && ((Element)node).getNS() == "http://www.w3.org/1999/xhtml") {
            return false;
        }
        Element parent = node.getXFAParent();
        assert (parent != null);
        int contentTypeAttr = parent.findAttr("http://www.xfa.org/schema/xfa-data/1.0/", "contentType");
        return contentTypeAttr == -1 || !parent.getAttrVal(contentTypeAttr).equals("text/html");
    }

    @Override
    public boolean isValidAttr(int eTag, boolean bReport, String value) {
        return true;
    }

    @Override
    public boolean isValidChild(int eTag, int nResId, boolean bBeforeInsert, boolean bOccurrenceErrorOnly) {
        if (!this.isValidElement(eTag, false)) {
            if (nResId != 0) {
                MsgFormatPos oMessage = new MsgFormatPos(nResId);
                oMessage.format(this.getClassAtom());
                oMessage.format(XFA.getAtom(eTag));
                throw new ExFull(oMessage);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidElement(int eTag, boolean bReport) {
        int eClassTag = this.getClassTag();
        if (eClassTag == XFA.DATAGROUPTAG) {
            if (eTag == XFA.DATAVALUETAG || eTag == XFA.DATAGROUPTAG || eTag == XFA.DSIGDATATAG) {
                return true;
            }
        } else if (eClassTag == XFA.DATAVALUETAG) {
            if (!this.mbContainsData) {
                return false;
            }
            if (eTag == XFA.DATAVALUETAG || eTag == XFA.DSIGDATATAG || eTag == XFA.TEXTNODETAG) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void makeNonDefault(boolean bRecursive) {
        if (this.getXMLName() != "xfa:data" && this.getXMLName() != "xfa:datasets") {
            super.makeNonDefault(bRecursive);
        }
    }

    @Override
    protected boolean notifyParent() {
        Element parent;
        if (this.getClassTag() == XFA.DATAVALUETAG && (parent = this.getXFAParent()) != null && parent.getClassTag() == XFA.DATAVALUETAG) {
            return true;
        }
        return super.notifyParent();
    }

    @Override
    public boolean processTextChildrenDuringParse() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preSave(boolean bSaveXMLScript) {
        block38: {
            Node domPeer;
            block37: {
                if (this.getClassTag() != XFA.DATAGROUPTAG) break block37;
                if (this.getDataDescription() == null) {
                    boolean previousWillDirty;
                    boolean bAmbiguous;
                    Node node = this.getXmlPeer().getFirstXMLChild();
                    Element parent = this.getXmlPeer().getXMLParent();
                    boolean bl = bAmbiguous = this.getFirstXFAChild() == null;
                    if (node == null && parent != null && !(parent instanceof ModelPeer)) {
                        bAmbiguous = true;
                    }
                    while (node != null && !bAmbiguous) {
                        if (node instanceof TextNode) {
                            bAmbiguous = true;
                            break;
                        }
                        node = node.getNextXMLSibling();
                    }
                    DataModel model = (DataModel)this.getModel();
                    Element domElement = (Element)this.getXmlPeer();
                    Attribute domAttr = model.findAttrInNS(domElement, "dataNode");
                    boolean bHasDDAttr = false;
                    if (domAttr != null) {
                        if (domAttr.getNS() == "http://ns.adobe.com/data-description/") {
                            bHasDDAttr = true;
                        } else {
                            previousWillDirty = this.getWillDirty();
                            this.setWillDirty(false);
                            try {
                                domElement.removeAttr(domAttr.getNS(), domAttr.getLocalName());
                            }
                            finally {
                                this.setWillDirty(previousWillDirty);
                            }
                        }
                    }
                    if (bAmbiguous && !bHasDDAttr) {
                        previousWillDirty = this.getWillDirty();
                        this.setWillDirty(false);
                        try {
                            domElement.setAttribute("http://www.xfa.org/schema/xfa-data/1.0/", "xfa:dataNode", "dataNode", "dataGroup", false);
                        }
                        finally {
                            this.setWillDirty(previousWillDirty);
                        }
                    }
                }
                boolean bIsNull = true;
                for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    child.preSave(false);
                    bIsNull &= child.isTransient();
                }
                if (!bIsNull) break block38;
                int eNullType = 5046274;
                if (this.mDataDescription != null) {
                    for (Element dataDesc = this.mDataDescription; dataDesc != null && !(dataDesc instanceof DataModel); dataDesc = dataDesc.getXFAParent()) {
                        Element element;
                        int index;
                        Node domPeer2 = dataDesc.getXmlPeer();
                        if (!(domPeer2 instanceof Element) || (index = (element = (Element)domPeer2).findAttr("http://ns.adobe.com/data-description/", "nullType")) == -1) continue;
                        EnumAttr enumAttr = EnumAttr.getEnum(EnumType.NULLTYPE_TYPE, element.getAttrVal(index));
                        eNullType = enumAttr.getInt();
                        break;
                    }
                }
                if (eNullType != 5046273) break block38;
                this.isTransient(true, false);
                break block38;
            }
            if (this.getDataDescription() == null && (domPeer = this.getXmlPeer()) instanceof Element && !((Element)domPeer).isTransient()) {
                boolean previousWillDirty;
                boolean bAmbiguous;
                Node child = this.getXmlPeer().getFirstXMLChild();
                boolean bl = bAmbiguous = child != null;
                if (bAmbiguous && child instanceof Element && ((Element)child).getNS() == "http://www.w3.org/1999/xhtml") {
                    bAmbiguous = false;
                }
                if (bAmbiguous) {
                    while (child != null) {
                        if (child instanceof TextNode) {
                            bAmbiguous = false;
                            break;
                        }
                        child = child.getNextXMLSibling();
                    }
                }
                DataModel model = (DataModel)this.getModel();
                Element element = (Element)domPeer;
                Attribute domAttr = model.findAttrInNS(element, "dataNode");
                boolean bHasDDAttr = false;
                if (domAttr != null) {
                    if (domAttr.getNS() == "http://ns.adobe.com/data-description/") {
                        bHasDDAttr = true;
                    } else {
                        previousWillDirty = this.getWillDirty();
                        this.setWillDirty(false);
                        try {
                            element.removeAttr(domAttr.getNS(), domAttr.getLocalName());
                        }
                        finally {
                            this.setWillDirty(previousWillDirty);
                        }
                    }
                }
                if (bAmbiguous && !bHasDDAttr) {
                    previousWillDirty = this.getWillDirty();
                    this.setWillDirty(false);
                    try {
                        element.setAttribute("http://www.xfa.org/schema/xfa-data/1.0/", "xfa:dataNode", "dataNode", "dataValue", false);
                    }
                    finally {
                        this.setWillDirty(previousWillDirty);
                    }
                }
            }
            for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                child.preSave(false);
            }
        }
    }

    @Override
    public void remove() {
        DataModel model;
        DataWindow oDataWindow;
        if (this.getClassTag() == XFA.DATAGROUPTAG && (oDataWindow = (model = (DataModel)this.getModel()).getDataWindow()) != null) {
            oDataWindow.dataGroupAddedOrRemoved(this, false);
        }
        super.remove();
    }

    protected void removeTextNodes() {
        Node child = this.getFirstXMLChild();
        while (child != null) {
            Node nextSibling = child.getNextXMLSibling();
            if (child instanceof TextNode) {
                this.removeChild(child);
            }
            child = nextSibling;
        }
    }

    private void resetAfterUpdate(DataNode oAffectedChild) {
        Node oAffectedChildDomPeer = oAffectedChild.getXmlPeer();
        if (oAffectedChildDomPeer == null || oAffectedChildDomPeer instanceof DataModel.AttributeWrapper) {
            return;
        }
        if (oAffectedChildDomPeer instanceof Element && ((Element)oAffectedChildDomPeer).getNS() == "http://www.w3.org/2000/09/xmldsig#") {
            return;
        }
        this.mbIsNullDetermined = false;
        TextNode oldSingleChild = this.singleTextChild();
        TextNode newSingleChild = null;
        for (Node child = this.getXmlPeer().getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            DataModel oDataModel;
            if (child instanceof TextNode) {
                if (newSingleChild == null) {
                    newSingleChild = (TextNode)child;
                    continue;
                }
                newSingleChild = null;
                break;
            }
            if (child instanceof Comment || child instanceof ProcessingInstruction || (oDataModel = (DataModel)this.getModel()).loadSpecialNode(this, (Element)child, true)) continue;
            newSingleChild = null;
            break;
        }
        this.singleTextChild(newSingleChild);
        if (oldSingleChild != null && newSingleChild == null) {
            DataNode oNew = new DataNode(null, null, "");
            oNew.setXmlPeer(oldSingleChild);
            oldSingleChild.setXfaPeer(oNew);
            if (oldSingleChild == this.getXmlPeer().getFirstXMLChild()) {
                super.insertChild(oNew, this.getFirstXFAChild(), false);
            } else {
                super.appendChild(oNew, false);
            }
        }
        this.notifyPeers(2, "", null);
    }

    @Override
    public void resetPostLoadXML() {
        if (this.getClassTag() != XFA.DATAGROUPTAG) {
            return;
        }
        DataModel dataModel = (DataModel)this.getModel();
        if (dataModel != null) {
            DataNode desc = this.getDataDescription();
            if (desc != null) {
                dataModel.connectDataNodesToDataDescription(desc, this);
            } else {
                dataModel.processDataDescription(this);
            }
            DataWindow dw = dataModel.getDataWindow();
            if (dw != null) {
                dw.updateAfterLoad();
            }
        }
    }

    @Override
    public void saveXML(OutputStream sOutFile, DOMSaveOptions options) {
        if (!this.mbContainsData) {
            return;
        }
        super.saveXML(sOutFile, options);
    }

    @Override
    public void serialize(OutputStream outStream, DOMSaveOptions options, int level, Node prevSibling) throws IOException {
        this.getXmlPeer().serialize(outStream, options, level, prevSibling);
    }

    void setContains(String containsType) {
        if ("data".equals(containsType)) {
            if (this.mbContainsData) {
                return;
            }
            this.mbContainsData = false;
            String attrValue = ((DataModel.AttributeWrapper)this.getXmlPeer()).getValue();
            String name = this.getName();
            boolean isNull = this.getIsNull();
            this.getXmlPeer().remove();
            Element oParent = this.getXmlPeer().getXMLParent();
            Element text = new Element(oParent, null, "", name, name, null, XFA.INVALID_ELEMENT, "");
            this.setXmlPeer(text);
            text.setXfaPeer(this);
            if (isNull) {
                this.setIsNull(true, false);
            } else {
                this.setValue(attrValue, true);
            }
        } else if ("metaData".equals(containsType)) {
            if (!this.mbContainsData) {
                return;
            }
            String name = this.getName();
            String value = this.getValue(true);
            Node original = this.getXmlPeer();
            Element parent = original.getXMLParent();
            if (this.getFirstXFAChild() != null) {
                MsgFormatPos oMessage = new MsgFormatPos(ResId.UnsupportedOperationException);
                oMessage.format("setContains").format(this.getClassAtom()).format(ResId.NodeHasChildren);
                throw new ExFull(oMessage);
            }
            if (this.getName().length() == 0) {
                MsgFormatPos oMessage = new MsgFormatPos(ResId.UnsupportedOperationException);
                oMessage.format("setContains").format(this.getClassAtom()).format(ResId.InvalidName);
                throw new ExFull(oMessage);
            }
            parent.removeChild(original);
            Attribute attr = parent.setAttribute("", "", name, value, false);
            DataModel.AttributeWrapper xmlPeer = new DataModel.AttributeWrapper(attr, parent);
            xmlPeer.setXfaPeer(this);
            this.setXmlPeer(xmlPeer);
            this.mbContainsData = false;
        } else {
            MsgFormatPos oMessage = new MsgFormatPos(ResId.InvalidPropertyValueException);
            oMessage.format(containsType).format("setContains");
            throw new ExFull(oMessage);
        }
    }

    public void setContentType(String contentType) {
        if (this.isAttribute()) {
            throw new ExFull(ResId.CantSetContentType);
        }
        if (this.getContentType().equals("text/html")) {
            Node child = this.getFirstXMLChild();
            while (child != null) {
                child.remove();
                child = this.getFirstXMLChild();
            }
        }
        this.setAttribute("http://www.xfa.org/schema/xfa-data/1.0/", "xfa:contentType", "contentType", contentType, false);
    }

    public void setDataDescription(DataNode dataDescription) {
        this.mDataDescription = dataDescription;
    }

    public void setIsDDPlaceholder(boolean bIsDDPlaceholder) {
        this.mbIsDDPlaceholder = bIsDDPlaceholder;
    }

    public void setIsNull(boolean bNull, boolean bNotify) {
        if (this.getClassTag() != XFA.DATAVALUETAG) {
            return;
        }
        if (bNotify) {
            this.deafen();
        }
        this.clearNull();
        this.updateIsNull(bNull);
        if (bNotify) {
            this.notifyPeers(2, "", null);
            this.unDeafen();
        }
    }

    @Override
    public void setName(String sName) {
        this.maName = null;
        this.setLocalName(sName);
    }

    public void setPictureFormat(String sFormat, String sLocale, boolean bIsTextNode) {
        if (null != this.mPictureFormatInfo && !this.mPictureFormatInfo.msPictureFormat.equals(sFormat)) {
            MsgFormatPos oMessage = new MsgFormatPos(ResId.ConflictingDataPictureException);
            oMessage.format(this.getName());
            oMessage.format(sFormat);
            oMessage.format(this.mPictureFormatInfo.msPictureFormat);
            throw new ExFull(oMessage);
        }
        if (null == this.mPictureFormatInfo) {
            this.mPictureFormatInfo = new PictureFormatInfo(sFormat, sLocale);
            if (!StringUtils.isEmpty(sFormat)) {
                this.mbIsTextNode = bIsTextNode;
            }
        }
    }

    @Override
    public void setPrivateName(String sName) {
        this.maName = sName.intern();
    }

    public void setValue(String sValue, boolean bNotify) {
        if (bNotify) {
            this.deafen();
        }
        this.clearNull();
        String sFormattedVal = this.formatDataValue(sValue);
        if (this.singleTextChild() == null) {
            if (this.getXmlPeer() instanceof DataModel.AttributeWrapper) {
                DataModel.AttributeWrapper wrapper = (DataModel.AttributeWrapper)this.getXmlPeer();
                Element parent = wrapper.getXMLParent();
                parent.setAttribute(wrapper.getNS(), wrapper.getXMLName(), wrapper.getLocalName(), sValue);
                int index = parent.findAttr(wrapper.getNS(), wrapper.getLocalName());
                assert (index != -1);
                Attribute a = parent.getAttr(index);
                DataModel.AttributeWrapper xmlPeer = new DataModel.AttributeWrapper(a, parent);
                xmlPeer.setXfaPeer(this);
                this.setXmlPeer(xmlPeer);
            } else if (this.getXmlPeer() instanceof TextNode) {
                TextNode textNode = (TextNode)this.getXmlPeer();
                textNode.setValue(sValue, false, false);
            } else if (this.getContentType().equals("text/html")) {
                int attr;
                Element peer = (Element)this.getXmlPeer();
                while (peer.getFirstXMLChild() != null) {
                    peer.getFirstXMLChild().remove();
                }
                if (sFormattedVal.length() > 0) {
                    TextNode t = new TextNode(peer, null, sFormattedVal);
                    this.singleTextChild(t);
                }
                if ((attr = peer.findAttr("", "contentType")) != -1 && peer.getAttrVal(attr).equals("text/html")) {
                    peer.removeAttr(attr);
                }
            } else {
                Node child = this.getFirstXFAChild();
                while (child != null) {
                    DataNode dChild;
                    Node nextChild = child.getNextXFASibling();
                    if (child.isSameClass(XFA.DATAVALUETAG) && !(dChild = (DataNode)child).isAttribute()) {
                        dChild.remove();
                    }
                    child = nextChild;
                }
                TextNode t = new TextNode((Element)this.getXmlPeer(), null, sFormattedVal);
                this.singleTextChild(t);
            }
        } else {
            TextNode textNode = this.singleTextChild();
            textNode.setText(sFormattedVal);
            if (this.getNullType() == 5046273 && StringUtils.isEmpty(sFormattedVal)) {
                this.isTransient(true, false);
            }
        }
        if (bNotify) {
            this.notifyPeers(2, "", null);
            this.unDeafen();
        }
    }

    public int setWeight(int nWeight) {
        this.mnWeight = nWeight++;
        for (Node pChild = this.getFirstXFAChild(); pChild != null; pChild = pChild.getNextXFASibling()) {
            if (!(pChild instanceof DataNode)) continue;
            nWeight = ((DataNode)pChild).setWeight(nWeight);
        }
        return nWeight;
    }

    TextNode singleTextChild() {
        return this.mSingleTextChild;
    }

    protected void singleTextChild(TextNode child) {
        this.mSingleTextChild = child;
    }

    String unformatDataValue(String sVal) {
        String sStr = sVal;
        if (this.mPictureFormatInfo != null) {
            StringHolder unformatted;
            String sLocale = this.mPictureFormatInfo.msLocale;
            if (StringUtils.isEmpty(sLocale)) {
                sLocale = this.getInstalledLocale();
            }
            boolean bSuccess = false;
            String sUnFormatted = null;
            if (this.mbIsTextNode && PictureFmt.isTextPicture(this.mPictureFormatInfo.msPictureFormat) && (bSuccess = PictureFmt.parseText(sVal, this.mPictureFormatInfo.msPictureFormat, sLocale, unformatted = new StringHolder()))) {
                sUnFormatted = unformatted.value;
            }
            if (!bSuccess) {
                PictureFmt oPict = new PictureFmt(sLocale);
                BooleanHolder pbSuccess = new BooleanHolder();
                sUnFormatted = oPict.parse(sVal, this.mPictureFormatInfo.msPictureFormat, pbSuccess);
                bSuccess = pbSuccess.value;
            }
            if (bSuccess) {
                sStr = sUnFormatted;
            }
        }
        return sStr;
    }

    @Override
    public final boolean isTransient() {
        Node domPeer = this.getXmlPeer();
        return domPeer.isTransient();
    }

    void updateIsNull(boolean bIsNull) {
        int eNullType = this.getNullType();
        Node domPeer = this.getXmlPeer();
        if (bIsNull) {
            this.setValue("", false);
            if (eNullType == 5046273) {
                domPeer.isTransient(true, false);
            } else if (eNullType == 0x4D0000 && domPeer instanceof Element && !(domPeer instanceof DataModel.AttributeWrapper)) {
                ((Element)domPeer).setXsiNilAttribute("true");
            }
        } else if (eNullType == 5046273) {
            this.isTransient(false, false);
        } else if (eNullType == 0x4D0000 && domPeer instanceof Element && !(domPeer instanceof DataModel.AttributeWrapper)) {
            ((Element)domPeer).setXsiNilAttribute("false");
        }
        this.mbIsNull = bIsNull;
        this.mbIsNullDetermined = true;
    }

    private String getDataNodeAsXML(DataNode oNode) {
        if (oNode == null) {
            return "";
        }
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        if (oNode.getXmlPeer() instanceof DataModel.AttributeWrapper) {
            Attribute attribute = ((DataModel.AttributeWrapper)oNode.getXmlPeer()).mAttribute;
            try {
                oStream.write(Document.MarkupSpace);
                oStream.write(attribute.getQName().getBytes("UTF-8"));
                oStream.write(Document.MarkupAttrMiddle);
                oStream.write(StringUtils.toXML(attribute.getAttrValue(), true).getBytes("UTF-8"));
                oStream.write(Document.MarkupDQuoteString);
            }
            catch (IOException iOException) {}
        } else {
            DataNode tempNode = (DataNode)oNode.clone(null);
            if (tempNode.getXmlPeer() instanceof Element) {
                tempNode.getModel().normalizeNameSpaces((Element)tempNode.getXmlPeer(), "");
            }
            DOMSaveOptions options = new DOMSaveOptions();
            options.setDisplayFormat(0);
            options.setSaveTransient(true);
            options.setEntityChars("\r");
            options.setRangeMin('\u007f');
            options.setRangeMax('\u00ff');
            options.setExcludePreamble(true);
            tempNode.saveXML(oStream, options);
        }
        try {
            return new String(oStream.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            return "";
        }
    }

    private void logDomChange(Node oCurrent, Attribute currentAttr, Node oRollback, Attribute rollbackAttr, Node.ChangeLogger oChangeLogger, Object oUserData) {
        Node oModelledNode;
        assert (oChangeLogger != null);
        boolean bCurrentModelled = false;
        boolean bRollbackModelled = false;
        Node oCurrentParent = null;
        Node oRollbackParent = null;
        if (oCurrent != null) {
            oModelledNode = DataNode.getXfaPeer(oCurrent, currentAttr);
            if (oModelledNode == null && oCurrent instanceof Chars) {
                oModelledNode = DataNode.getXfaPeer(oCurrent.getXMLParent(), null);
            }
            if (oModelledNode != null) {
                bCurrentModelled = true;
                oCurrentParent = oModelledNode;
            }
        }
        if (oRollback != null) {
            oModelledNode = DataNode.getXfaPeer(oRollback, rollbackAttr);
            if (oModelledNode == null && oRollback instanceof Chars) {
                oModelledNode = DataNode.getXfaPeer(oRollback.getXMLParent(), null);
            }
            if (oModelledNode != null) {
                bRollbackModelled = true;
                oRollbackParent = oModelledNode;
            }
        }
        while (oCurrentParent == null && oCurrent != null) {
            oCurrentParent = DataNode.getXfaPeer(oCurrent, currentAttr);
            if (currentAttr != null) {
                currentAttr = null;
                oCurrent = null;
                continue;
            }
            oCurrent = oCurrent.getXMLParent();
        }
        while (oRollbackParent == null && oRollback != null) {
            oRollbackParent = DataNode.getXfaPeer(oRollback, rollbackAttr);
            if (rollbackAttr != null) {
                rollbackAttr = null;
                oRollback = null;
                continue;
            }
            oRollback = oRollback.getXMLParent();
        }
        oChangeLogger.logDataChange(oCurrentParent, oRollbackParent, bCurrentModelled, bRollbackModelled, this.getDataNodeAsXML((DataNode)oCurrentParent), oUserData);
    }

    private static Node getXfaPeer(Node xmlPeer, Attribute attribute) {
        Node node = xmlPeer;
        while (!(node instanceof ModelPeer) && !(node instanceof Model)) {
            node = node.getXMLParent();
        }
        if (node == null) {
            assert (false);
            return null;
        }
        if (node instanceof Model) {
            return xmlPeer;
        }
        Model model = (Model)((ModelPeer)node).getXfaPeer();
        if (model instanceof Model.DualDomModel) {
            Node xfaPeer = DataNode.findMatchingXfaPeer(model, xmlPeer);
            if (attribute == null) {
                return xfaPeer;
            }
            if (xfaPeer != null) {
                for (Node child = xfaPeer.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    Node childXmlPeer = ((Element.DualDomNode)((Object)child)).getXmlPeer();
                    if (!(childXmlPeer instanceof DataModel.AttributeWrapper)) continue;
                    DataModel.AttributeWrapper wrapper = (DataModel.AttributeWrapper)childXmlPeer;
                    if (wrapper.mAttribute != attribute) continue;
                    return child;
                }
            }
            return null;
        }
        return xmlPeer;
    }

    private static Node findMatchingXfaPeer(Node xfaPeer, Node xmlPeer) {
        if (((Element.DualDomNode)((Object)xfaPeer)).getXmlPeer() == xmlPeer) {
            return xfaPeer;
        }
        if (xfaPeer instanceof Element) {
            for (Node child = ((Element)xfaPeer).getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                Node node = DataNode.findMatchingXfaPeer(child, xmlPeer);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    private boolean isEmptyTextNode(Node oNode) {
        if (oNode == null) {
            return false;
        }
        if (oNode instanceof Chars) {
            return ((Chars)oNode).isXMLSpace();
        }
        return false;
    }

    private boolean compareDomNodes(Node oCurrent, Node oRollback, Node.ChangeLogger oChangeLogger, Object oUserData) {
        String sRollbackValue;
        int nAt;
        int i;
        String oRollbackNS;
        String oRollbackName;
        String oCurrentNS;
        String oCurrentName;
        if (oCurrent == null && oRollback == null) {
            return true;
        }
        if (oCurrent == null || oRollback == null) {
            if (oChangeLogger != null) {
                this.logDomChange(oCurrent, null, oRollback, null, oChangeLogger, oUserData);
            }
            return false;
        }
        if (oCurrent instanceof Element) {
            Element currentElement = (Element)oCurrent;
            oCurrentName = currentElement.getLocalName();
            oCurrentNS = currentElement.getNS();
        } else {
            oCurrentName = oCurrent.getName();
            oCurrentNS = "";
        }
        if (oRollback instanceof Element) {
            Element rollbackElement = (Element)oRollback;
            oRollbackName = rollbackElement.getLocalName();
            oRollbackNS = rollbackElement.getNS();
        } else {
            oRollbackName = oCurrent.getName();
            oRollbackNS = "";
        }
        if (oCurrentName != oRollbackName || oCurrentNS != oRollbackNS) {
            if (oChangeLogger != null) {
                this.logDomChange(oCurrent, null, oRollback, null, oChangeLogger, oUserData);
            }
            return false;
        }
        boolean bMatches = true;
        Element oCurrentDataNode = null;
        int nSizeCurrent = 0;
        if (oCurrent instanceof Element) {
            oCurrentDataNode = (Element)oCurrent;
            nSizeCurrent = oCurrentDataNode.getNumAttrs();
        }
        Element oRollbackDataNode = null;
        int nSizeRollback = 0;
        if (oRollback instanceof Element) {
            oRollbackDataNode = (Element)oRollback;
            nSizeRollback = oRollbackDataNode.getNumAttrs();
        }
        for (i = 0; i < nSizeCurrent; ++i) {
            Attribute oRollbackAttr;
            Attribute oCurrentAttr = oCurrentDataNode.getAttr(i);
            if (oCurrentAttr.isNameSpaceAttr()) continue;
            nAt = oRollbackDataNode.findAttr(oCurrentAttr.getNS(), oCurrentAttr.getLocalName());
            Attribute attribute = oRollbackAttr = nAt == -1 ? null : oRollbackDataNode.getAttr(nAt);
            if (oRollbackAttr != null && oCurrentAttr.getAttrValue().equals(oRollbackAttr.getAttrValue())) continue;
            bMatches = false;
            if (oChangeLogger == null) continue;
            this.logDomChange(oCurrent, oCurrentAttr, oRollback, oRollbackAttr, oChangeLogger, oUserData);
        }
        for (i = 0; i < nSizeRollback; ++i) {
            Attribute oCurrentAttr;
            Attribute oRollbackAttr = oRollbackDataNode.getAttr(i);
            if (oRollbackAttr.isNameSpaceAttr()) continue;
            nAt = oCurrentDataNode.findAttr(oRollbackAttr.getNS(), oRollbackAttr.getLocalName());
            Attribute attribute = oCurrentAttr = nAt == -1 ? null : oCurrentDataNode.getAttr(nAt);
            if (oCurrentAttr != null) continue;
            bMatches = false;
            if (oChangeLogger == null) continue;
            this.logDomChange(oCurrent, oCurrentAttr, oRollback, oRollbackAttr, oChangeLogger, oUserData);
        }
        if (!bMatches && oChangeLogger == null) {
            return false;
        }
        Node oCurrentChild = null;
        if (oCurrent instanceof Element) {
            oCurrentChild = oCurrent.getFirstXMLChild();
            while (this.isEmptyTextNode(oCurrentChild)) {
                oCurrentChild = oCurrentChild.getNextXMLSibling();
            }
        }
        Node oRollbackChild = null;
        if (oRollback instanceof Element) {
            oRollbackChild = oRollback.getFirstXMLChild();
            while (this.isEmptyTextNode(oRollbackChild)) {
                oRollbackChild = oRollbackChild.getNextXMLSibling();
            }
        }
        while (oCurrentChild != null || oRollbackChild != null) {
            if (!this.compareDomNodes(oCurrentChild, oRollbackChild, oChangeLogger, oUserData)) {
                bMatches = false;
            }
            if (oCurrentChild != null) {
                oCurrentChild = oCurrentChild.getNextXMLSibling();
                while (this.isEmptyTextNode(oCurrentChild)) {
                    oCurrentChild = oCurrentChild.getNextXMLSibling();
                }
            }
            if (oRollbackChild == null) continue;
            oRollbackChild = oRollbackChild.getNextXMLSibling();
            while (this.isEmptyTextNode(oRollbackChild)) {
                oRollbackChild = oRollbackChild.getNextXMLSibling();
            }
        }
        String sCurrentValue = oCurrent.getData();
        if (!sCurrentValue.equalsIgnoreCase(sRollbackValue = oRollback.getData())) {
            bMatches = false;
            if (oChangeLogger != null) {
                this.logDomChange(oCurrent, null, oRollback, null, oChangeLogger, oUserData);
            }
        }
        return bMatches;
    }

    @Override
    protected boolean compareVersions(Node oRollbackNode, Node oContainer, Node.ChangeLogger oChangeLogger, Object oUserData) {
        if (oRollbackNode instanceof Element.DualDomNode) {
            oRollbackNode = ((Element.DualDomNode)((Object)oRollbackNode)).getXmlPeer();
        }
        return this.compareDomNodes((Element)this.getXmlPeer(), oRollbackNode, oChangeLogger, oUserData);
    }

    @Override
    public void connectPeerToDocument() {
        super.connectPeerToDocument();
        if (this.getClassTag() == XFA.DATAGROUPTAG) {
            ((DataModel)this.getModel()).getDataWindow().resetRecordDepth();
        }
    }

    @Override
    public void setXmlPeer(Node peer) {
        this.mXmlPeer = peer;
        this.mbContainsData = !(peer instanceof DataModel.AttributeWrapper);
    }

    @Override
    public Node getXmlPeer() {
        return this.mXmlPeer;
    }

    @Override
    protected ScriptDynamicPropObj getDynamicScriptProp(String sPropertyName, boolean bPropertyOverride, boolean bPeek) {
        DataNode dataDescription;
        if (this.getClassTag() == XFA.DATAGROUPTAG && (dataDescription = this.getDataDescription()) != null) {
            for (DataNode child = (DataNode)dataDescription.getFirstXFAChild(); child != null; child = (DataNode)child.getNextXFASibling()) {
                int index;
                Element assoc = (Element)child.getXmlPeer();
                if (assoc.getNS() != "http://ns.adobe.com/data-description/" || assoc.getLocalName() != "association" || (index = assoc.findAttr("http://ns.adobe.com/data-description/", "name")) == -1 || !assoc.getAttr(index).getAttrValue().equals(sPropertyName)) continue;
                return resolveAssociationPropObj;
            }
        }
        return super.getDynamicScriptProp(sPropertyName, bPropertyOverride, bPeek);
    }

    private static class PictureFormatInfo {
        final String msPictureFormat;
        final String msLocale;

        PictureFormatInfo(String sPictureFormat, String sLocale) {
            this.msPictureFormat = sPictureFormat;
            this.msLocale = sLocale;
        }
    }
}

