/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.data;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Element;
import com.adobe.xfa.Model;
import com.adobe.xfa.ModelFactory;
import com.adobe.xfa.ModelPeer;
import com.adobe.xfa.Node;
import com.adobe.xfa.Option;
import com.adobe.xfa.XFA;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.data.DataTransformations;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import org.xml.sax.Attributes;

public final class DataModelFactory
extends ModelFactory {
    private static final String gsAttrOption = "delegate|ignore|preserve";
    private static final String gsRecordOption = "%d|%s";
    private Option mAttributesOption = new Option("attributes", "delegate|ignore|preserve");
    private Option mDataWindowOption;
    private Option mExcludeNSOption;
    private int mnDataWindowRecordsAfter = 0;
    private int mnDataWindowRecordsBefore = 0;
    private Option mRangeOption;
    private Option mRecordOption = new Option("record", "%d|%s");
    private Option mStartNodeOption;
    private DataTransformations mTransformations = null;
    private Option mTransformOption = new Option("transform", "%s");

    public DataModelFactory() {
        super(XFA.DATAMODELTAG, "data", "$data");
        this.mRangeOption = new Option("range", "%s");
        this.mStartNodeOption = new Option("startNode", "%s");
        this.mExcludeNSOption = new Option("excludeNS", "%s");
        this.mDataWindowOption = new Option("window", "%s");
        this.attributesAreValues(true);
    }

    public boolean attributesAreValues() {
        return this.mAttributesOption.getMatchingIndex() == 2;
    }

    public void attributesAreValues(boolean bSetting) {
        String sSetting = bSetting ? "preserve" : "ignore";
        this.mAttributesOption.setValue(sSetting, false);
    }

    @Override
    public Model createDOM(Element parent) {
        DataModel m = new DataModel(parent.getAppModel(), null);
        m.setDocument(parent.getOwnerDocument());
        ModelPeer modelPeer = new ModelPeer(parent, null, "http://www.xfa.org/schema/xfa-data/1.0/", "datasets", "xfa:datasets", null, m);
        m.setXmlPeer(modelPeer);
        Element dataPeer = new Element(modelPeer, null, "http://www.xfa.org/schema/xfa-data/1.0/", "data", "xfa:data", null, XFA.INVALID_ELEMENT, "");
        dataPeer.setModel(m);
        dataPeer.setAttribute("http://www.xfa.org/schema/xfa-data/1.0/", "xfa:dataNode", "dataNode", "dataGroup", false);
        DataNode dataNode = new DataNode(m, null, null, null, null, null);
        dataNode.setClass("dataGroup", XFA.DATAGROUPTAG);
        dataNode.setModel(m);
        dataNode.setXmlPeer(dataPeer);
        dataPeer.setXfaPeer(dataNode);
        m.setAliasNode(dataNode);
        return m;
    }

    @Override
    public boolean getAllowAdd() {
        return true;
    }

    @Override
    public boolean isRootName(String name) {
        return name == "data" || name == "datasets";
    }

    @Override
    protected boolean isRootNode(AppModel parent, String uri, String localName) {
        if (!parent.getAllowThirdPartyXml()) {
            return localName == "datasets";
        }
        return true;
    }

    @Override
    protected Model newModel(AppModel parent, Node prevSibling, String uri, String localName, String qName, Attributes a) {
        Element dataModelPeer;
        DataModel dataModel = new DataModel(parent, prevSibling);
        if (uri.equals("http://www.xfa.org/schema/xfa-data/1.0/") && localName.equals("datasets")) {
            dataModelPeer = new ModelPeer(null, null, uri, localName, qName, a, dataModel);
        } else {
            dataModelPeer = new Element(null, null, uri, localName, qName, a, XFA.INVALID_ELEMENT, "");
            dataModelPeer.setDocument(dataModel.getOwnerDocument());
        }
        dataModel.setXmlPeer(dataModelPeer);
        if (this.mAttributesOption.isSet()) {
            if (this.mAttributesOption.getMatchingIndex() == 1) {
                dataModel.setAttributesAreValues(false);
            } else if (this.mAttributesOption.getMatchingIndex() == 2) {
                dataModel.setAttributesAreValues(true);
            }
        }
        if (this.mRecordOption.isSet()) {
            int recordLevel = 1;
            String recordName = null;
            if (this.mRecordOption.getMatchingIndex() == 0) {
                recordLevel = this.mRecordOption.getInteger();
            } else {
                recordName = this.mRecordOption.getString();
            }
            dataModel.setRecordOptions(recordLevel, recordName);
        }
        if (this.mRangeOption.isSet()) {
            String sRange = this.mRangeOption.getString();
            dataModel.setRangeOptions(sRange);
        }
        if (this.mStartNodeOption.isSet()) {
            int nLength = this.mStartNodeOption.getString().length();
            dataModel.setStartNodeSOMString(this.mStartNodeOption.getString().substring(7, nLength - 1));
        }
        if (this.mExcludeNSOption.isSet()) {
            dataModel.setExcludeNSList(this.mExcludeNSOption.getString());
        }
        if (this.mDataWindowOption.isSet()) {
            dataModel.setDataWindowParameters(this.mnDataWindowRecordsBefore, this.mnDataWindowRecordsAfter);
        }
        if (this.mTransformations != null && this.mTransformations.size() > 0) {
            dataModel.setTransformations(this.mTransformations);
        }
        return dataModel;
    }

    @Override
    public void setOption(String optionName, String optionValue, boolean bCritical) {
        int nOption;
        Option[] optionArray = new Option[]{this.mAttributesOption, this.mRecordOption, this.mStartNodeOption, this.mExcludeNSOption, this.mDataWindowOption, this.mRangeOption, this.mTransformOption, null};
        String name = optionName;
        int nPackageSeparatorOffset = optionName.indexOf(95);
        if (nPackageSeparatorOffset != -1) {
            if (nPackageSeparatorOffset == 0) {
                throw new ExFull(ResId.OptionWrongPackageException, optionName);
            }
            String packageName = optionName.substring(0, nPackageSeparatorOffset);
            if (!this.isRootName(packageName.intern())) {
                throw new ExFull(ResId.OptionWrongPackageException, optionName);
            }
            name = optionName.substring(nPackageSeparatorOffset + 1);
        }
        if ((nOption = Option.setOptionByArray("", optionArray, name, optionValue, bCritical)) == 2) {
            String sStartNodeString = this.mStartNodeOption.getString();
            if (!sStartNodeString.startsWith("xfasom(") || !sStartNodeString.endsWith(")")) {
                MsgFormatPos oMessage = new MsgFormatPos(ResId.InvalidOptionValueException);
                oMessage.format(this.mStartNodeOption.getName());
                oMessage.format(sStartNodeString);
                throw new ExFull(oMessage);
            }
        } else if (nOption == 4) {
            String sWindowString = this.mDataWindowOption.getString();
            int before = 0;
            int after = 0;
            int iteration = 1;
            boolean bValid = false;
            String[] tokens = sWindowString.split(",");
            for (int i = 0; i < tokens.length; ++i) {
                int num;
                String sToken = tokens[i];
                try {
                    num = Integer.parseInt(sToken);
                }
                catch (NumberFormatException e) {
                    bValid = false;
                    break;
                }
                if (iteration == 1) {
                    bValid = true;
                    before = num;
                    after = num;
                } else if (iteration == 2) {
                    after = num;
                } else {
                    bValid = false;
                    break;
                }
                ++iteration;
            }
            if (!bValid) {
                MsgFormatPos oMessage = new MsgFormatPos(ResId.InvalidOptionValueException);
                oMessage.format(this.mDataWindowOption.getName());
                oMessage.format(sWindowString);
                throw new ExFull(oMessage);
            }
            this.mnDataWindowRecordsBefore = before;
            this.mnDataWindowRecordsAfter = after;
        } else if (nOption == 6) {
            if (this.mTransformations == null) {
                this.mTransformations = new DataTransformations();
            }
            this.mTransformations.add(this.mTransformOption.getString());
        }
    }

    public void reset() {
        if (this.mTransformations == null) {
            this.mTransformations.reset();
        }
    }
}

