/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.content;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.content.IntegerScript;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;

public final class IntegerValue
extends Content {
    public IntegerValue(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "integer", "integer", null, XFA.INTEGERTAG, "integer");
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return super.equals(object) && this.getValue() == ((IntegerValue)object).getValue();
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.getValue();
    }

    @Override
    public ScriptTable getScriptTable() {
        return IntegerScript.getScriptTable();
    }

    public int getValue() {
        String sValue = this.getStrValue();
        if (StringUtils.isEmpty(sValue)) {
            return 0;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            MsgFormatPos oMessage = new MsgFormatPos(ResId.FoundBadElementValueException);
            oMessage.format(sValue);
            oMessage.format(this.getSOMExpression());
            oMessage.format("0");
            this.getModel().addErrorList(new ExFull(oMessage), 3, this);
            return 0;
        }
    }

    public void setValue(int newValue) {
        this.setStrValue(Integer.toString(newValue), true, false);
    }

    public void setValue(String sValue, boolean bFromData) {
        if (StringUtils.isEmpty(sValue)) {
            this.setStrValue("", true, false);
        } else {
            boolean bTypeMismatch = false;
            int nVal = 0;
            try {
                nVal = Integer.parseInt(sValue);
            }
            catch (NumberFormatException e) {
                this.setStrValue("", true, false);
                bTypeMismatch = true;
            }
            if (bTypeMismatch) {
                if (!this.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V30_SCRIPTING)) {
                    MsgFormatPos oMessage = new MsgFormatPos(ResId.TypeMismatch);
                    oMessage.format(this.getSOMExpression());
                    oMessage.format(sValue);
                    this.getModel().addErrorList(new ExFull(oMessage), 3, this);
                }
                if (this.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V29_SCRIPTING)) {
                    this.setValue(nVal);
                } else if (bFromData) {
                    this.setStrValue(sValue, true, false);
                }
                return;
            }
            this.setValue(nVal);
        }
    }

    @Override
    public String toString() {
        if (this.getIsNull()) {
            return "0";
        }
        return this.getStrValue();
    }

    public boolean valueHasTypeMismatch() {
        String sValue = this.getStrValue();
        if (StringUtils.isEmpty(sValue)) {
            return false;
        }
        try {
            Integer.parseInt(sValue);
            return false;
        }
        catch (NumberFormatException ex) {
            return true;
        }
    }
}

