/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.content;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Int;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.RichTextNode;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.XMLMultiSelectNode;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.content.ExDataScript;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public final class ExDataValue
extends Content {
    public ExDataValue(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "exData", "exData", null, XFA.EXDATATAG, "exData");
    }

    @Override
    protected boolean childrenAreIndexable() {
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return super.equals(object) && this.getValue(true, true, true).equals(((ExDataValue)object).getValue(true, true, true));
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.getValue(true, true, true).hashCode();
    }

    @Override
    public ScriptTable getScriptTable() {
        return ExDataScript.getScriptTable();
    }

    @Override
    public String getStrValue() {
        return this.getValue(false, false, true);
    }

    @Override
    public void updateIDValues(String sPrefix, List<String> oldReferenceList) {
        Node oNode = this.getOneOfChild(true, false);
        if (oNode instanceof RichTextNode) {
            ((RichTextNode)oNode).updateIDValuesImpl(sPrefix, oldReferenceList);
        }
    }

    public String getValue(boolean bAsFragment, boolean bSuppressPreamble, boolean bLegacyWhitespaceProcessing) {
        Int maxLength;
        int nMaxLength;
        String sValue = "";
        if (!this.getIsNull()) {
            Node node = this.getOneOfChild();
            if (node instanceof RichTextNode) {
                RichTextNode richTextValue = (RichTextNode)node;
                sValue = richTextValue.getValue(bAsFragment, bSuppressPreamble, bLegacyWhitespaceProcessing);
            } else if (node instanceof TextNode) {
                TextNode textValue = (TextNode)node;
                sValue = textValue.getValue();
            } else if (node instanceof XMLMultiSelectNode) {
                XMLMultiSelectNode multiSelectValue = (XMLMultiSelectNode)node;
                sValue = multiSelectValue.getValue(bAsFragment, bSuppressPreamble);
            }
        }
        Element grandParent = null;
        if (this.getXFAParent() != null) {
            grandParent = this.getXFAParent().getXFAParent();
        }
        if (grandParent != null && grandParent.isSameClass(XFA.FIELDTAG) && !bAsFragment && 0 < (nMaxLength = (maxLength = (Int)this.getAttribute(XFA.MAXLENGTHTAG)).getValue()) && nMaxLength < sValue.length()) {
            sValue = sValue.substring(0, maxLength.getValue());
        }
        return sValue;
    }

    public void getValues(List<String> values) {
        if (!this.getIsNull()) {
            Node child = this.getOneOfChild(true, false);
            if (child instanceof XMLMultiSelectNode) {
                ((XMLMultiSelectNode)child).getValues(values);
            } else {
                String sValue = this.getValue(false, false, true);
                values.add(sValue);
            }
        }
    }

    @Override
    public boolean processTextChildrenDuringParse() {
        return false;
    }

    @Override
    public void loadXML(InputStream sInFile, boolean bIgnoreAggregatingTag, Element.ReplaceContent eReplaceContent) {
        this.removeXmlChildren();
        Document doc = this.getOwnerDocument();
        Element imported = doc.loadIntoDocument(sInFile);
        Element startNode = imported.getFirstXMLChildElement();
        if (startNode == null) {
            return;
        }
        if (!bIgnoreAggregatingTag) {
            this.setContent(startNode, false);
        } else if ((startNode = startNode.getFirstXMLChildElement()) != null) {
            this.setContent(startNode, false);
        }
    }

    public void setContent(Node domNode, boolean bDefault) {
        this.mbIsNullDetermined = false;
        this.removeXsiNilAttribute();
        Model model = this.getModel();
        Element element = null;
        if (domNode instanceof Element) {
            element = (Element)domNode;
        }
        if (element != null && (element.getNS() == "http://www.w3.org/1999/xhtml" || element.getLocalName() == "body" || element.getLocalName() == "xhtml")) {
            StringAttr prop = new StringAttr("contentType", "text/html");
            this.setAttribute(prop, XFA.CONTENTTYPETAG);
            RichTextNode richTextNode = new RichTextNode(null, null);
            this.copyDomElementOntoXfa(element, richTextNode);
            this.removeXmlChildren();
            this.setOneOfChild(richTextNode);
            if (!bDefault) {
                this.makeNonDefault(false);
            }
            if (this.getAppModel() != null && this.getAppModel().bumpVersionOnRichTextLoad() && !this.validateUsage(richTextNode.getVersionRequired(), 0, true)) {
                MsgFormatPos reason = new MsgFormatPos(ResId.InvalidChildVersionException);
                reason.format("");
                reason.format(element.getClassAtom());
                model.addErrorList(new ExFull(reason), 3, this);
            }
            this.notifyPeers(2, "", null);
        } else if (this.getAttribute(XFA.CONTENTTYPETAG).toString().equals("text/xml")) {
            Node newContent = null;
            if (element != null) {
                XMLMultiSelectNode xmlMultiSelectNode = new XMLMultiSelectNode(null, null);
                this.copyDomElementOntoXfa(element, xmlMultiSelectNode);
                newContent = xmlMultiSelectNode;
            } else if (domNode instanceof TextNode) {
                newContent = domNode;
            }
            this.removeXmlChildren();
            this.setOneOfChild(newContent);
            if (!bDefault) {
                this.makeNonDefault(false);
            }
            this.notifyPeers(2, "", null);
        } else {
            if (this.getAttribute(XFA.CONTENTTYPETAG).toString().equals("text/html")) {
                StringAttr prop = new StringAttr("contentType", "");
                this.setAttribute(prop, XFA.CONTENTTYPETAG);
            }
            if (domNode instanceof TextNode) {
                this.removeXmlChildren();
                this.setOneOfChild(domNode);
                if (!bDefault) {
                    this.makeNonDefault(false);
                }
                this.notifyPeers(2, "", null);
            } else {
                this.appendChild(domNode, false);
                MsgFormatPos format = new MsgFormatPos(ResId.UnsupportedContentWarning);
                format.format(this.getClassAtom());
                format.format(domNode.getName());
                ExFull err = new ExFull(format);
                model.addErrorList(err, 3, this);
            }
        }
    }

    private void removeXmlChildren() {
        Node child = this.getFirstXMLChild();
        while (child != null) {
            this.removeChild(child);
            child = this.getFirstXMLChild();
        }
    }

    private void copyDomElementOntoXfa(Element domNode, Element xfaNode) {
        xfaNode.setModel(this.getModel());
        xfaNode.setDocument(this.getOwnerDocument());
        xfaNode.setDOMProperties(domNode.getNS(), domNode.getLocalName(), domNode.getXMLName(), null);
        for (int i = 0; i < domNode.getNumAttrs(); ++i) {
            Attribute a = domNode.getAttr(i);
            xfaNode.setAttribute(a.getNS(), a.getQName(), a.getLocalName(), a.getAttrValue(), false);
        }
        Node child = domNode.getFirstXMLChild();
        while (child != null) {
            Node nextSibling = child.getNextXMLSibling();
            xfaNode.appendChild(child);
            child = nextSibling;
        }
    }

    public void setValue(List<String> values) {
        if (this.getAttribute(XFA.CONTENTTYPETAG).toString().equals("text/xml")) {
            Element parent;
            if (this.getFirstXFAChild() != null) {
                Node child = this.getFirstXFAChild();
                if (child instanceof XMLMultiSelectNode) {
                    ((XMLMultiSelectNode)child).setValues(values);
                    return;
                }
                while (this.getFirstXMLChild() != null) {
                    this.getFirstXMLChild().remove();
                }
            }
            Model model = this.getModel();
            XMLMultiSelectNode newNode = (XMLMultiSelectNode)model.getSchema().getInstance(XFA.XMLMULTISELECTNODETAG, model, this, null, false);
            for (parent = this.getXFAParent(); parent != null && !parent.isContainer(); parent = parent.getXFAParent()) {
            }
            String aName = "items";
            if (parent != null) {
                aName = parent.getName();
            }
            newNode.setLocalName(aName);
            newNode.setValues(values);
        } else {
            String sValue = values.get(0);
            this.setValue(sValue);
        }
    }

    public void setValue(String sText) {
        String sContent = this.getAttribute(XFA.CONTENTTYPETAG).toString();
        if (sContent.equals("text/xml")) {
            ArrayList<String> selectionList = new ArrayList<String>();
            if (!StringUtils.isEmpty(sText)) {
                StringTokenizer tokenizer = new StringTokenizer(sText, "\n");
                while (tokenizer.hasMoreTokens()) {
                    selectionList.add(tokenizer.nextToken());
                }
            }
            this.setValue(selectionList);
        } else {
            if (StringUtils.isEmpty(sContent) || sContent.equals("text/html")) {
                this.setAttribute(new StringAttr("contentType", "text/plain"), XFA.CONTENTTYPETAG);
            }
            this.setStrValue(sText, true, false);
        }
    }

    @Override
    public String toString() {
        return this.getValue(false, false, true);
    }
}

