/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Arg;
import com.adobe.xfa.ArrayNodeList;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Element;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.Obj;
import com.adobe.xfa.PseudoModel;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.util.ArrayList;
import java.util.List;

public final class SOMParser {
    private static final int BRT_ABSOLUTE = 2;
    private static final int BRT_ALL = 0;
    private static final int BRT_LAST = 3;
    private static final int BRT_RELATIVE = 1;
    private static final Arg[] emptyParameters = new Arg[0];
    private final List<Node> m_RefStack = new ArrayList<Node>();
    private boolean mbLastInstance;
    private boolean mbNoProperties;
    private boolean mbPeek;
    private int mBracketType;
    private DependencyTracker mDependencyTracker;
    private Object[] mObjectParameters;
    private Arg[] mParameters;
    static final String patentRef = "AdobePatentID=\"B1082\"";

    private static int findChar(String src, int offset, char charToFind) {
        int length = src.length();
        while (offset < length) {
            char c = src.charAt(offset);
            if (c == charToFind) {
                return offset;
            }
            if (c == '\\') {
                ++offset;
            } else if (c == '\"' || c == '\'') {
                char cQuote = c;
                ++offset;
                while (offset < length) {
                    if (src.charAt(offset) == cQuote) {
                        if (offset < length - 1 && src.charAt(offset + 1) != cQuote) break;
                        ++offset;
                    }
                    ++offset;
                }
            } else if (c == '(' || c == '[') {
                int rightParenOrBracket = SOMParser.findChar(src, offset + 1, c == '(' ? (char)')' : ']');
                if (rightParenOrBracket == -1) {
                    return -1;
                }
                offset = rightParenOrBracket;
            }
            ++offset;
        }
        return -1;
    }

    static int findDot(String src, int offset) {
        int p_dot = SOMParser.findChar(src, offset, '.');
        while (p_dot != -1 && p_dot < src.length() - 1 && (src.charAt(p_dot + 1) == '(' || src.charAt(p_dot + 1) == '[')) {
            p_dot = SOMParser.findChar(src, p_dot + 1, '.');
        }
        return p_dot;
    }

    static String escapeSomName(String sSomExpr) {
        if (sSomExpr.indexOf(46) != -1) {
            StringBuilder somExpr = new StringBuilder(sSomExpr);
            SOMParser.escapeSomName(somExpr);
            return somExpr.toString();
        }
        return sSomExpr;
    }

    static void escapeSomName(StringBuilder somExpr) {
        int nOffset = somExpr.length() - 1;
        while ((nOffset = somExpr.lastIndexOf(".", nOffset)) != -1) {
            somExpr.replace(nOffset, nOffset + 1, "\\.");
        }
    }

    static String unescapeSomName(String sSomExpr) {
        if (sSomExpr.contains("\\.")) {
            StringBuilder somExpr = new StringBuilder(sSomExpr);
            SOMParser.unescapeSomName(somExpr);
            return somExpr.toString();
        }
        return sSomExpr;
    }

    static void unescapeSomName(StringBuilder somExpr) {
        int nOffset = 0;
        while ((nOffset = somExpr.indexOf("\\.", nOffset)) != -1) {
            somExpr.replace(nOffset, nOffset + 2, ".");
        }
    }

    private static int getTreeIndex(Node poTree) {
        if (poTree == null) {
            return 1;
        }
        boolean bUseName = poTree.useNameInSOM();
        return poTree.getIndex(bUseName);
    }

    public SOMParser(DependencyTracker dependencyTracker) {
        this.mDependencyTracker = dependencyTracker;
    }

    public SOMParser() {
        this(null);
    }

    private boolean locateNodes(Obj startObject, String name, int brt, int index, boolean searchParent, List<SomResultInfo> somResult, String somExpression, BooleanHolder isAssociation) {
        if (name.equals("*")) {
            if (!(startObject instanceof Node)) {
                MsgFormatPos oErr = new MsgFormatPos(ResId.SearchNonNodeSOMException);
                oErr.format(startObject.getClassName());
                oErr.format(somExpression);
                throw new ExFull(oErr);
            }
            Node startNode = (Node)startObject;
            NodeList allChildren = startNode.getNodes();
            int nLen = allChildren.length();
            if (brt == 1 && index != 0) {
                throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
            }
            if (brt == 2) {
                if (index > nLen) {
                    return false;
                }
                somResult.add(new SomResultInfo(allChildren.item(index)));
                return true;
            }
            if (brt == 3 && nLen > 0) {
                somResult.add(new SomResultInfo(allChildren.item(nLen - 1)));
                return true;
            }
            for (int i = 0; i < nLen; ++i) {
                somResult.add(new SomResultInfo(allChildren.item(i)));
            }
            return true;
        }
        Arg arg = new Arg();
        StringBuilder sFunctionName = new StringBuilder();
        this.mParameters = null;
        boolean bUseName = !name.startsWith("#");
        boolean bPassed = false;
        if (this.parseParams(name, sFunctionName, somExpression)) {
            bPassed = startObject.invokeFunction(arg, sFunctionName.toString(), this.mParameters, this.mDependencyTracker, false);
            if (arg.getArgType() == 8) {
                throw arg.getException();
            }
        } else {
            bPassed = startObject.getScriptProperty(arg, name, this.mDependencyTracker, this.mbPeek, true);
        }
        Node childNode = null;
        if (bPassed) {
            if (arg.getArgType() == 7) {
                Obj obj = arg.getObject();
                AppModel appModel = null;
                if (startObject instanceof Element) {
                    appModel = ((Element)startObject).getAppModel();
                }
                if (obj == null) {
                    arg.empty();
                } else {
                    if (obj instanceof NodeList) {
                        NodeList nodeList = (NodeList)obj;
                        if (appModel == null && nodeList.length() > 0 && nodeList.item(0) != null && nodeList.item(0) instanceof Element) {
                            appModel = ((Element)nodeList.item(0)).getAppModel();
                        }
                        if (appModel != null && !appModel.getLegacySetting(AppModel.XFA_LEGACY_V32_SCRIPTING) && this.mbNoProperties & arg.isXFAProperty()) {
                            return false;
                        }
                        if (appModel != null && !appModel.getLegacySetting(AppModel.XFA_LEGACY_V30_SCRIPTING)) {
                            if (isAssociation != null) {
                                isAssociation.value = true;
                            }
                            if (brt == 0) {
                                for (int i = 0; i < nodeList.length(); ++i) {
                                    somResult.add(new SomResultInfo(nodeList.item(i), null, 0, arg));
                                }
                            } else if (brt == 3) {
                                somResult.add(new SomResultInfo(nodeList.item(nodeList.length() - 1), null, 0, arg));
                            } else if (brt == 2) {
                                somResult.add(new SomResultInfo(nodeList.item(index), null, 0, arg));
                            } else if (brt == 1) {
                                if (index == 0) {
                                    somResult.add(new SomResultInfo(nodeList, null, 0, arg));
                                } else {
                                    throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                                }
                            }
                            return true;
                        }
                    }
                    if (!(obj instanceof Node)) {
                        somResult.add(new SomResultInfo(arg.getObject()));
                        return true;
                    }
                    childNode = (Node)obj;
                    if (appModel != null && !appModel.getLegacySetting(AppModel.XFA_LEGACY_V32_SCRIPTING) && this.mbNoProperties & arg.isXFAProperty()) {
                        return false;
                    }
                    if (arg.isRefObject()) {
                        if (isAssociation != null) {
                            isAssociation.value = true;
                        }
                        if (!(brt == 0 || brt == 3 || brt == 2 && index == 0 || brt == 1 && index == 0)) {
                            throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                        }
                        somResult.add(new SomResultInfo(childNode, null, 0, arg));
                        return true;
                    }
                }
            }
            if (childNode == null && arg.getArgType() != 8) {
                if (this.mbNoProperties) {
                    return false;
                }
                int nPropIndex = 0;
                if (brt == 1 && index == 0) {
                    nPropIndex = 0;
                } else if (brt == 2) {
                    nPropIndex = index;
                } else {
                    throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                }
                somResult.add(new SomResultInfo(startObject, name, nPropIndex, arg));
                return true;
            }
        }
        if (childNode != null) {
            if (!childNode.useNameInSOM()) {
                bUseName = false;
            }
            if (brt == 0 || brt == 3) {
                NodeList all = null;
                int nLen = 0;
                if (childNode instanceof Element) {
                    all = ((Element)childNode).getAll(bUseName);
                    nLen = all.length();
                }
                if (this.mDependencyTracker != null) {
                    this.mDependencyTracker.addDependency(startObject);
                }
                if (brt == 3 && nLen > 0) {
                    somResult.add(new SomResultInfo(all.item(nLen - 1)));
                    return true;
                }
                for (int i = 0; i < nLen; ++i) {
                    somResult.add(new SomResultInfo(all.item(i)));
                }
                return true;
            }
            int nSearchIndex = index;
            if (brt == 1 && (nSearchIndex = this.m_RefStack.size() == 0 ? index : SOMParser.getTreeIndex(this.m_RefStack.get(this.m_RefStack.size() - 1)) + index) < 0) {
                return false;
            }
            if (nSearchIndex == 0 && !childNode.isTransparent()) {
                somResult.add(new SomResultInfo(childNode));
            } else {
                Node node = childNode.getSibling(nSearchIndex, bUseName, false);
                if (node == null) {
                    if (brt == 1 && index == 0 && nSearchIndex > 0) {
                        Node oSecondInstance = null;
                        if (nSearchIndex > 1) {
                            oSecondInstance = childNode.getSibling(1, bUseName, false);
                        }
                        if (oSecondInstance == null) {
                            node = childNode.getSibling(0, bUseName, false);
                        }
                        if (node == null) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                somResult.add(new SomResultInfo(node));
            }
            return true;
        }
        if (searchParent) {
            if (!(startObject instanceof Node)) {
                MsgFormatPos oErr = new MsgFormatPos(ResId.SearchNonNodeSOMException);
                oErr.format(startObject.getClassName());
                oErr.format(somExpression);
                throw new ExFull(oErr);
            }
            Node startNode = (Node)startObject;
            Element oParent = startNode.getXFAParent();
            if (oParent != null) {
                this.m_RefStack.add(startNode);
                if (this.locateNodes(oParent, name, brt, index, true, somResult, somExpression, isAssociation)) {
                    return true;
                }
            } else {
                boolean bValid = false;
                if (brt == 1 && index == 0) {
                    bValid = true;
                } else if (brt == 2 && index == 0) {
                    bValid = true;
                }
                if (!bValid) {
                    return false;
                }
                this.m_RefStack.add(null);
                if (name.equals(startNode.getName())) {
                    somResult.add(new SomResultInfo(startNode));
                    return true;
                }
            }
        }
        return false;
    }

    private int parseBrackets(String bracketSection, int offset, String somExpression) {
        int digit_ptr;
        boolean bNegative = false;
        int index = 0;
        while (Character.isWhitespace(bracketSection.charAt(offset))) {
            ++offset;
        }
        if (bracketSection.charAt(offset) == '*') {
            ++offset;
            while (Character.isWhitespace(bracketSection.charAt(offset))) {
                ++offset;
            }
            if (bracketSection.charAt(offset) != ']') {
                throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
            }
            this.mBracketType = this.mbLastInstance ? 3 : 0;
            return index;
        }
        if (bracketSection.charAt(offset) == '+' || bracketSection.charAt(offset) == '-') {
            this.mBracketType = 1;
            bNegative = bracketSection.charAt(offset) == '-';
            digit_ptr = offset + 1;
        } else {
            this.mBracketType = 2;
            digit_ptr = offset;
        }
        while (Character.isWhitespace(bracketSection.charAt(digit_ptr))) {
            ++digit_ptr;
        }
        if (!Character.isDigit(bracketSection.charAt(digit_ptr))) {
            throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
        }
        while (Character.isDigit(bracketSection.charAt(digit_ptr))) {
            index *= 10;
            index += bracketSection.charAt(digit_ptr) - 48;
            ++digit_ptr;
        }
        if (bNegative) {
            index = -index;
        }
        while (Character.isWhitespace(bracketSection.charAt(digit_ptr))) {
            ++digit_ptr;
        }
        if (bracketSection.charAt(digit_ptr) != ']') {
            throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
        }
        return index;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseParams(String name, StringBuilder sFunctionName, String somExpression) {
        int p_name = 0;
        int p_left_paren = SOMParser.findChar(name, p_name, '(');
        if (p_left_paren == -1) {
            return false;
        }
        int p_right_paren = SOMParser.findChar(name, p_left_paren + 1, ')');
        if (p_right_paren == -1) {
            throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
        }
        if (p_right_paren - p_name != name.length() - 1) {
            throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
        }
        sFunctionName.setLength(0);
        sFunctionName.append(name, 0, p_left_paren - p_name);
        while (sFunctionName.length() > 0 && Character.isWhitespace(sFunctionName.charAt(sFunctionName.length() - 1))) {
            sFunctionName.setLength(sFunctionName.length() - 1);
        }
        this.mParameters = null;
        int p_scan = p_left_paren + 1;
        while (Character.isWhitespace(name.charAt(p_scan))) {
            ++p_scan;
        }
        while (name.charAt(p_scan) != ')') {
            Arg arg = new Arg();
            int p_param = p_scan;
            if (name.charAt(p_scan) == '-' || Character.isDigit(name.charAt(p_scan))) {
                ++p_scan;
                while (Character.isDigit(name.charAt(p_scan)) || name.charAt(p_scan) == '.') {
                    ++p_scan;
                }
                String sNum = name.substring(p_param, p_scan);
                double dNum = 0.0;
                try {
                    dNum = Double.parseDouble(sNum);
                }
                catch (NumberFormatException n) {
                    throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                }
                if (Double.isInfinite(dNum)) {
                    throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                }
                arg.setDouble(new Double(dNum));
            } else if (name.charAt(p_scan) == '\"' || name.charAt(p_scan) == '\'') {
                char cQuote = name.charAt(p_scan);
                ++p_param;
                ++p_scan;
                boolean bInlineQuote = false;
                while (true) {
                    if (p_scan == name.length()) {
                        throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                    }
                    if (name.charAt(p_scan) == cQuote) {
                        if (p_scan == name.length() || name.charAt(p_scan + 1) != cQuote) break;
                        ++p_scan;
                        bInlineQuote = true;
                    }
                    ++p_scan;
                }
                StringBuilder sStringArg = new StringBuilder(name.substring(p_param, p_scan));
                if (bInlineQuote) {
                    String sDoubledQuote = null;
                    sDoubledQuote = cQuote == '\'' ? "''" : "\"\"";
                    int nFoundAt = sStringArg.indexOf(sDoubledQuote);
                    while (nFoundAt != -1) {
                        sStringArg.delete(nFoundAt, nFoundAt + 1);
                        nFoundAt = sStringArg.indexOf(sDoubledQuote, nFoundAt + 1);
                    }
                }
                arg.setString(sStringArg.toString());
                ++p_scan;
            } else if (name.charAt(p_scan) == '%') {
                if (!name.regionMatches(p_scan, "%null%", 0, 6)) throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                arg.empty();
                p_scan += 6;
            } else {
                if (name.charAt(p_scan) != '#') throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                if (this.mObjectParameters == null) {
                    throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                }
                if (!Character.isDigit(name.charAt(++p_scan))) {
                    throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                }
                int index = 0;
                while (Character.isDigit(name.charAt(p_scan))) {
                    index *= 10;
                    index += name.charAt(p_scan) - 48;
                    ++p_scan;
                }
                arg.setObject((Obj)this.mObjectParameters[index]);
            }
            Arg[] newParameters = new Arg[this.mParameters == null ? 1 : this.mParameters.length + 1];
            if (this.mParameters != null) {
                System.arraycopy(this.mParameters, 0, newParameters, 0, this.mParameters.length);
            }
            this.mParameters = newParameters;
            this.mParameters[this.mParameters.length - 1] = arg;
            while (Character.isWhitespace(name.charAt(p_scan))) {
                ++p_scan;
            }
            if (name.charAt(p_scan) == ',') {
                if (name.charAt(++p_scan) == ')') {
                    throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                }
                while (Character.isWhitespace(name.charAt(p_scan))) {
                    ++p_scan;
                }
                continue;
            }
            if (name.charAt(p_scan) == ')') continue;
            throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
        }
        if (this.mParameters != null) return true;
        this.mParameters = emptyParameters;
        return true;
    }

    public boolean resolve(Node startNode, String somExpression, List<SomResultInfo> result) {
        return this.resolve(startNode, somExpression, null, result, null);
    }

    public boolean resolve(Node startNode, String somExpression, List<SomResultInfo> result, BooleanHolder isAssociation) {
        return this.resolve(startNode, somExpression, null, result, isAssociation);
    }

    boolean resolve(Node startNode, String somExpression, ArrayNodeList result, BooleanHolder isAssociation) {
        ArrayList<SomResultInfo> nodeInfo = new ArrayList<SomResultInfo>();
        while (result.length() > 0) {
            result.remove(result.item(0));
        }
        if (!this.resolve(startNode, somExpression, nodeInfo, isAssociation)) {
            return false;
        }
        for (int i = 0; i < nodeInfo.size(); ++i) {
            PseudoModel pseudoModel;
            if (((SomResultInfo)nodeInfo.get((int)i)).propertyName != null) continue;
            Obj obj = ((SomResultInfo)nodeInfo.get((int)i)).object;
            if (obj instanceof Node) {
                result.append(obj);
                continue;
            }
            if (!(obj instanceof PseudoModel) || !((obj = (pseudoModel = (PseudoModel)obj).getAliasObject()) instanceof Node)) continue;
            result.append(obj);
        }
        return true;
    }

    public boolean resolve(Node startNode, String somExpression, Object[] objectParameters, List<SomResultInfo> result, BooleanHolder isAssociation) {
        int prev;
        this.mObjectParameters = objectParameters;
        this.m_RefStack.clear();
        int p_dot = SOMParser.findDot(somExpression, 0);
        boolean beforeFirstDot = true;
        for (prev = 0; prev < somExpression.length() && Character.isWhitespace(somExpression.charAt(prev)); ++prev) {
        }
        if (prev < somExpression.length() && somExpression.charAt(prev) == '!') {
            Node parentNode = startNode;
            if (startNode instanceof Node) {
                parentNode = startNode.getModel();
            }
            while (parentNode.getXFAParent() != null) {
                parentNode = parentNode.getXFAParent();
            }
            result.add(new SomResultInfo(parentNode));
            if (!this.resolveDotSection("datasets", 0, 8, true, result, false, somExpression, isAssociation)) {
                return false;
            }
            ++prev;
        } else {
            result.add(new SomResultInfo(startNode));
        }
        if (p_dot == prev) {
            throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
        }
        boolean bSearchChildren = false;
        while (p_dot != -1) {
            if (p_dot == prev) {
                bSearchChildren = true;
                if (++prev < somExpression.length() && somExpression.charAt(prev) == '.') {
                    throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                }
                p_dot = SOMParser.findDot(somExpression, prev);
                if (p_dot == -1) break;
            }
            if (!this.resolveDotSection(somExpression, prev, p_dot - prev, beforeFirstDot, result, bSearchChildren, somExpression, isAssociation)) {
                return false;
            }
            beforeFirstDot = false;
            prev = p_dot + 1;
            p_dot = SOMParser.findDot(somExpression, prev);
            bSearchChildren = false;
        }
        return this.resolveDotSection(somExpression, prev, somExpression.length() - prev, beforeFirstDot, result, bSearchChildren, somExpression, isAssociation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resolveDotSection(String src, int dotSection, int length, boolean beforeFirstDot, List<SomResultInfo> somResult, boolean bSearchChildren, String somExpression, BooleanHolder isAssociation) {
        int i;
        int p_garbage;
        boolean bAllChildren;
        while (dotSection < src.length() && Character.isWhitespace(src.charAt(dotSection))) {
            ++dotSection;
            --length;
        }
        while (length > 0 && dotSection + length - 1 < src.length() && Character.isWhitespace(src.charAt(dotSection + length - 1))) {
            --length;
        }
        if (length == 0) {
            throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
        }
        boolean bl = bAllChildren = length == 1 && src.charAt(dotSection) == '*';
        if (bAllChildren && beforeFirstDot) {
            throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
        }
        int brt = 1;
        int bracket_index = 0;
        int p_script_check = SOMParser.findChar(src, dotSection, '.');
        String p_script_lang = null;
        String sScriptContents = "";
        if (p_script_check != -1 && p_script_check - dotSection < length) {
            int p_scriptcontents_end = -1;
            if (src.charAt(++p_script_check) == '[') {
                p_script_lang = "formcalc";
                p_scriptcontents_end = SOMParser.findChar(src, p_script_check + 1, ']');
            } else if (src.charAt(p_script_check) == '(') {
                p_script_lang = "javascript";
                p_scriptcontents_end = SOMParser.findChar(src, p_script_check + 1, ')');
            } else {
                throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
            }
            if (p_scriptcontents_end == -1 || p_scriptcontents_end - dotSection >= length) {
                throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
            }
            sScriptContents = src.substring(p_script_check + 1, p_scriptcontents_end);
            length = p_script_check - dotSection - 1;
            p_garbage = SOMParser.findChar(src, dotSection, '[');
            if (p_garbage != -1 && p_garbage - dotSection < length) {
                throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
            }
            p_garbage = SOMParser.findChar(src, dotSection, ']');
            if (p_garbage != -1 && p_garbage - dotSection < length) {
                throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
            }
            if (length > 1 && (p_garbage = SOMParser.findChar(src, dotSection, '*')) != -1 && p_garbage - dotSection < length) {
                throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
            }
            brt = 0;
        } else {
            int p_left_bracket = SOMParser.findChar(src, dotSection, '[');
            if (p_left_bracket != -1 && p_left_bracket - dotSection < length) {
                int p_right_bracket = SOMParser.findChar(src, p_left_bracket + 1, ']');
                if (p_right_bracket == -1) {
                    throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                }
                if (p_right_bracket - dotSection != length - 1) {
                    throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                }
                bracket_index = this.parseBrackets(src, p_left_bracket + 1, somExpression);
                brt = this.mBracketType;
                for (length = p_left_bracket - dotSection; length > 0 && Character.isWhitespace(src.charAt(dotSection + length - 1)); --length) {
                }
            } else if (!bAllChildren) {
                p_garbage = SOMParser.findChar(src, dotSection, ']');
                if (p_garbage != -1 && p_garbage - dotSection < length) {
                    throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                }
                p_garbage = SOMParser.findChar(src, dotSection, '*');
                if (p_garbage != -1 && p_garbage - dotSection < length) {
                    throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                }
            }
        }
        StringBuilder s = new StringBuilder(src.substring(dotSection, dotSection + length));
        if (s.indexOf(".") != -1 && s.indexOf("(") == -1) {
            SOMParser.unescapeSomName(s);
        }
        if (s.length() == 0) {
            throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
        }
        if (src.charAt(dotSection) == '$') {
            if (brt != 1 || bracket_index != 0) {
                throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
            }
            if (length == 1) {
                return true;
            }
            if (!beforeFirstDot) {
                throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
            }
            SomResultInfo sri = somResult.get(0);
            if (!(sri.object instanceof Node)) {
                return false;
            }
            if (sri.object instanceof Node) {
                Model parentModel = ((Node)sri.object).getModel();
                if (parentModel == null) {
                    return false;
                }
                AppModel appModel = parentModel.getAppModel();
                somResult.clear();
                if (!Character.isLetter(s.charAt(1))) {
                    throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                }
                String sPseudoRootAtom = s.toString();
                Node pseudoRoot = Model.lookupShortCut(appModel, sPseudoRootAtom);
                if (pseudoRoot != null) {
                    somResult.add(new SomResultInfo(pseudoRoot));
                    return true;
                }
                Obj obj = appModel.lookupPseudoModel(sPseudoRootAtom);
                if (obj instanceof PseudoModel) {
                    PseudoModel pPseudoModelIMpl = (PseudoModel)obj;
                    obj = pPseudoModelIMpl.getAliasObject();
                }
                if (obj != null) {
                    somResult.add(new SomResultInfo(obj));
                    return true;
                }
            }
            return false;
        }
        if (src.charAt(dotSection) == '#' && s.toString().equals("#0")) {
            if (!beforeFirstDot || this.mObjectParameters == null) {
                throw new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
            }
            somResult.clear();
            somResult.add(new SomResultInfo((Obj)this.mObjectParameters[0]));
            return true;
        }
        int nOldResultsSize = somResult.size();
        if (bSearchChildren) {
            Node childNode = null;
            for (i = 0; i < nOldResultsSize; ++i) {
                Node test;
                boolean bSearchByClass;
                Obj obj = somResult.get((int)i).object;
                if (!(obj instanceof Node)) {
                    MsgFormatPos oErr = new MsgFormatPos(ResId.SearchNonNodeSOMException);
                    oErr.format(obj.getClassName());
                    oErr.format(somExpression);
                    throw new ExFull(oErr);
                }
                StringBuilder sChildName = new StringBuilder(s);
                boolean bl2 = bSearchByClass = sChildName.charAt(0) == '#';
                if (bSearchByClass) {
                    sChildName.delete(0, 1);
                }
                if ((test = this.searchForChild((Node)obj, sChildName.toString(), bSearchByClass)) == null) {
                    somResult.remove(i);
                    --i;
                    --nOldResultsSize;
                    continue;
                }
                childNode = test;
                somResult.set(i, new SomResultInfo(childNode.getXFAParent()));
            }
        }
        ArrayList<SomResultInfo> oNewResult = new ArrayList<SomResultInfo>();
        for (i = 0; i < nOldResultsSize; ++i) {
            if (!StringUtils.isEmpty(somResult.get((int)i).propertyName)) {
                MsgFormatPos oErr = new MsgFormatPos(ResId.SOMRefPropertyException);
                oErr.format(s.toString());
                oErr.format(somExpression);
                throw new ExFull(oErr);
            }
            int nNewSize = oNewResult.size();
            if (this.locateNodes(somResult.get((int)i).object, s.toString(), brt, bracket_index, beforeFirstDot, oNewResult, somExpression, isAssociation)) continue;
            while (oNewResult.size() > nNewSize) {
                oNewResult.remove(oNewResult.size() - 1);
            }
        }
        somResult.clear();
        somResult.addAll(oNewResult);
        if (!StringUtils.isEmpty(sScriptContents)) {
            String sScriptLanguage = p_script_lang;
            for (i = 0; i < somResult.size(); ++i) {
                Boolean bAccept = Boolean.FALSE;
                SomResultInfo sri = somResult.get(i);
                if (StringUtils.isEmpty(sri.propertyName) && sri.object instanceof Element) {
                    Element oNode = (Element)sri.object;
                    try {
                        oNode.getAppModel().setPermsLock(true);
                        Arg oScriptResult = oNode.evaluate(sScriptContents, sScriptLanguage, 16, true);
                        if (oScriptResult.getArgType() == 8) {
                            ExFull oErr = new ExFull(new MsgFormat(ResId.InvalidSOMException, somExpression));
                            oErr.insert(oScriptResult.getException(), true);
                            throw oErr;
                        }
                        bAccept = oScriptResult.getAsBool(false);
                    }
                    finally {
                        oNode.getAppModel().setPermsLock(false);
                    }
                }
                if (bAccept.booleanValue()) continue;
                somResult.remove(i);
                --i;
            }
        }
        if (this.m_RefStack.size() > 0) {
            this.m_RefStack.remove(this.m_RefStack.size() - 1);
        }
        return somResult.size() > 0;
    }

    private Node searchForChild(Node startNode, String childName, boolean bSearchByClass) {
        boolean bAllChildren = childName.equals("*");
        for (Node child = startNode.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (childName == null && !bSearchByClass) {
                return null;
            }
            if (childName.equals(bSearchByClass ? child.getClassName() : child.getName())) {
                return child;
            }
            Node childNode = this.searchForChild(child, childName, bSearchByClass);
            if (childNode != null) {
                return childNode;
            }
            if (!bAllChildren) continue;
            return child;
        }
        return null;
    }

    public void setOptions(boolean bPeek, boolean bLastInstance, boolean bNoProperties) {
        this.mbPeek = bPeek;
        this.mbLastInstance = bLastInstance;
        this.mbNoProperties = bNoProperties;
    }

    public void setDependencyTracker(DependencyTracker dependencyTracker) {
        this.mDependencyTracker = dependencyTracker;
    }

    public static final class SomResultInfo {
        public final Obj object;
        public final int occurrence;
        public final String propertyName;
        public final Arg value;

        SomResultInfo(Obj initObject) {
            this.object = initObject;
            this.occurrence = 0;
            this.value = new Arg();
            this.propertyName = null;
            this.value.setObject(initObject);
        }

        SomResultInfo(Obj initObject, String initPropertyName, int initOccurrence, Arg initValue) {
            this.object = initObject;
            this.propertyName = initPropertyName;
            this.occurrence = initOccurrence;
            this.value = initValue;
        }
    }
}

