/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.LogMessageData;
import com.adobe.xfa.ut.ExErrItem;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ISODate;
import com.adobe.xfa.ut.ISOTime;
import com.adobe.xfa.ut.LcLocale;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.StringUtils;
import java.util.ArrayList;
import java.util.List;

public final class LogMessage {
    public static final int MSG_FATAL_ERROR = 6;
    public static final int MSG_IGNORE = 0;
    public static final int MSG_INFORMATION = 2;
    public static final int MSG_TRACE = 1;
    public static final int MSG_VALIDATION_ERROR = 5;
    public static final int MSG_VALIDATION_WARNING = 4;
    public static final int MSG_WARNING = 3;
    int meSeverity;
    private final List<LogMessageData> mItems = new ArrayList<LogMessageData>();
    private String msLocale;

    private String getLocale() {
        LcLocale oLocale;
        if (StringUtils.isEmpty(this.msLocale)) {
            this.msLocale = LcLocale.getLocale();
        }
        this.msLocale = !(oLocale = new LcLocale(this.msLocale)).isValid() ? "en_US" : oLocale.getIsoName();
        return this.msLocale;
    }

    public LogMessage() {
    }

    public LogMessage(ExFull oSource, int eSeverity) {
        this.meSeverity = 2;
        this.msLocale = "";
        this.insertMessage(oSource, eSeverity, "");
    }

    public LogMessage(int nId, String sText, int eSeverity) {
        this.meSeverity = 2;
        this.msLocale = "";
        this.insertMessage(nId, sText, eSeverity, "");
    }

    public LogMessage(MsgFormatPos oSource, int eSeverity) {
        this.meSeverity = eSeverity;
        this.msLocale = "";
        this.insertMessage(oSource, eSeverity, "");
    }

    private void addMessage(int nId, String sText, int eSeverity, ISODate pDate, ISOTime pTime, String sSOMExpression) {
        if (pDate != null && pTime != null) {
            LogMessageData oMsgData = new LogMessageData(nId, sText, eSeverity, pDate, pTime, sSOMExpression);
            this.mItems.add(oMsgData);
            return;
        }
        if (pDate == null) {
            pDate = new ISODate(this.getLocale(), 30);
        }
        if (pTime == null) {
            pTime = new ISOTime(this.getLocale(), 30);
        }
        LogMessageData oMsgData = new LogMessageData(nId, sText, eSeverity, pDate, pTime, sSOMExpression);
        this.mItems.add(oMsgData);
    }

    public int count() {
        return this.mItems.size();
    }

    public LogMessageData get(int index) {
        return this.mItems.get(index);
    }

    public int getSeverity() {
        return this.meSeverity;
    }

    public void insertMessage(ExFull oSource, int eSeverity, String sLocale) {
        ISODate oDate = new ISODate(sLocale, 30);
        ISOTime oTime = new ISOTime(sLocale, 0);
        String sText = "";
        int nSize = oSource.count();
        oSource.resolve();
        for (int i = 0; i < nSize; ++i) {
            ExErrItem oExErrItem = oSource.item(i);
            int nId = oExErrItem.resId();
            sText = oExErrItem.text();
            StringBuilder sTextBuf = new StringBuilder(sText);
            StringUtils.trim(sTextBuf);
            sText = sTextBuf.toString();
            this.addMessage(nId, sText, eSeverity, oDate, oTime, "");
        }
        this.updateSeverity(eSeverity);
    }

    public void insertMessage(int nId, String sText, int eSeverity, String sLocale) {
        ISODate oDate = new ISODate(sLocale, 30);
        ISOTime oTime = new ISOTime(sLocale, 0);
        String str = sText;
        str = str.trim();
        this.addMessage(nId, str, eSeverity, oDate, oTime, "");
        this.updateSeverity(eSeverity);
    }

    public void insertMessage(MsgFormatPos oSource, int eSeverity, String sLocale) {
        ISODate oDate = new ISODate(sLocale, 30);
        ISOTime oTime = new ISOTime(sLocale, 0);
        int nId = oSource.resId();
        String sText = oSource.toString();
        sText = sText.trim();
        this.addMessage(nId, sText, eSeverity, oDate, oTime, "");
        this.updateSeverity(eSeverity);
    }

    public void insertValidationError(String sValidationMsg, String sSOMExpression, String sLocale) {
        ISODate oDate = new ISODate(sLocale, 30);
        ISOTime oTime = new ISOTime(sLocale, 0);
        this.addMessage(0, sValidationMsg, 5, oDate, oTime, sSOMExpression);
    }

    public void insertValidationWarning(String sValidationMsg, String sSOMExpression, String sLocale) {
        ISODate oDate = new ISODate(sLocale, 30);
        ISOTime oTime = new ISOTime(sLocale, 0);
        this.addMessage(0, sValidationMsg, 4, oDate, oTime, sSOMExpression);
    }

    public void setSeverity(int eSeverity) {
        this.meSeverity = eSeverity;
    }

    private void updateSeverity(int eSeverity) {
        if (eSeverity > this.getSeverity()) {
            this.setSeverity(eSeverity);
        }
    }
}

