/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;

public final class Int
extends Attribute {
    private final int miValue;

    private Int(String NS, String localName, String qName, String value, boolean internSymbols) {
        super(NS, localName, qName, value, internSymbols);
        int iValue = 0;
        if (!StringUtils.isEmpty(value)) {
            try {
                iValue = Integer.parseInt(value);
            }
            catch (NumberFormatException n) {
                MsgFormatPos oContext = new MsgFormatPos(ResId.InvalidPropertyValueException);
                oContext.format(value);
                oContext.format("integer");
                ExFull oErr = new ExFull(oContext);
                throw oErr;
            }
        }
        this.miValue = iValue;
    }

    public Int(String qName, int value) {
        this(qName, value, true);
    }

    public Int(String qName, int value, boolean internSymbols) {
        super(null, null, qName, Integer.toString(value), false);
        this.miValue = value;
    }

    public Int(String qName, String value) {
        this(null, null, qName, value, true);
    }

    public int getValue() {
        return this.miValue;
    }

    @Override
    public Attribute newAttribute(String value) {
        return this.newAttribute(this.getNS(), this.getLocalName(), this.getQName(), value, false);
    }

    @Override
    public Attribute newAttribute(String NS, String localName, String qName, String value) {
        return this.newAttribute(NS, localName, qName, value, true);
    }

    @Override
    public Attribute newAttribute(String NS, String localName, String qName, String value, boolean internSymbols) {
        return new Int(NS, localName, qName, value, internSymbols);
    }

    public int toInt() {
        return this.getValue();
    }

    @Override
    public String toString() {
        return Integer.toString(this.miValue);
    }
}

