/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class DOMSaveOptions {
    public static final int PRETTY_OUTPUT = 2;
    public static final int RAW_OUTPUT = 0;
    public static final int SIMPLE_OUTPUT = 1;
    private boolean mbExcludePreamble;
    private boolean mbExpandElement;
    private boolean mbFormatOutside;
    private boolean mbIncludeDTD;
    private boolean mbSaveFragment;
    private boolean mbSaveTransient;
    private boolean mbUseSingleQuoteAttr;
    private boolean mbCanonicalizeNamespaceOrder;
    private boolean mbIgnoreExtraRootData;
    private char mcRangeMax;
    private char mcRangeMin;
    private int mePrintFmt;
    private int mnIndentLevel;
    private String msDisabledEntityChars;
    private String msEntityChars;
    private static volatile byte[] mIndent;
    private final Object sync = new Object();

    public DOMSaveOptions() {
        this.mePrintFmt = 1;
        this.mnIndentLevel = 3;
        this.msEntityChars = "";
        this.msDisabledEntityChars = "";
    }

    public DOMSaveOptions(DOMSaveOptions oOptions) {
        this.mePrintFmt = oOptions.mePrintFmt;
        this.mbExcludePreamble = oOptions.mbExcludePreamble;
        this.mbIncludeDTD = oOptions.mbIncludeDTD;
        this.mbFormatOutside = oOptions.mbFormatOutside;
        this.mbExpandElement = oOptions.mbExpandElement;
        this.mbUseSingleQuoteAttr = oOptions.mbUseSingleQuoteAttr;
        this.mbSaveTransient = oOptions.mbSaveTransient;
        this.mbSaveFragment = oOptions.mbSaveFragment;
        this.mnIndentLevel = oOptions.mnIndentLevel;
        this.msEntityChars = oOptions.msEntityChars;
        this.mcRangeMin = oOptions.mcRangeMin;
        this.mcRangeMax = oOptions.mcRangeMax;
        this.msDisabledEntityChars = oOptions.msDisabledEntityChars;
        this.mbCanonicalizeNamespaceOrder = oOptions.mbCanonicalizeNamespaceOrder;
        this.mbIgnoreExtraRootData = oOptions.mbIgnoreExtraRootData;
    }

    public DOMSaveOptions(int ePrintFmt, boolean bExcludePreamble, boolean bIncludeDTD, boolean bFormatOutside, int nIndentLevel, boolean bExpandElement, boolean bUseSingleQuoteAttr, String sEntityChars, char cRangeMin, char cRangeMax, String sDisabledEntityChars, boolean bIsUTF8, boolean bSaveTransient, boolean bSaveFragment) {
        this.mePrintFmt = ePrintFmt;
        this.mnIndentLevel = nIndentLevel;
        this.msEntityChars = sEntityChars;
        this.mcRangeMin = cRangeMin;
        this.mcRangeMax = cRangeMax;
        this.msDisabledEntityChars = sDisabledEntityChars;
        this.mbSaveTransient = bSaveTransient;
        this.mbSaveFragment = bSaveFragment;
        this.mbExcludePreamble = bExcludePreamble;
        this.mbIncludeDTD = bIncludeDTD;
        this.mbFormatOutside = bFormatOutside;
        this.mbExpandElement = bExpandElement;
        this.mbUseSingleQuoteAttr = bUseSingleQuoteAttr;
    }

    boolean canBeSaved(boolean bFragmentFlag, boolean bDefaultFlag, boolean bTransientFlag) {
        return bFragmentFlag && this.getSaveFragment() || !bTransientFlag && !bDefaultFlag || this.getSaveTransient();
    }

    public boolean getCanonicalizeNamespaceOrder() {
        return this.mbCanonicalizeNamespaceOrder;
    }

    public String getDisabledEntityChars() {
        return this.msDisabledEntityChars;
    }

    public int getDisplayFormat() {
        return this.mePrintFmt;
    }

    public String getEntityChars() {
        return this.msEntityChars;
    }

    public boolean getExcludePreamble() {
        return this.mbExcludePreamble;
    }

    public boolean getExpandElement() {
        return this.mbExpandElement;
    }

    public boolean getFormatOutside() {
        return this.mbFormatOutside;
    }

    public boolean getIncludeDTD() {
        return this.mbIncludeDTD;
    }

    public int getIndentLevel() {
        return this.mnIndentLevel;
    }

    public char getRangeMax() {
        return this.mcRangeMax;
    }

    public char getRangeMin() {
        return this.mcRangeMin;
    }

    public boolean getSaveFragment() {
        return this.mbSaveFragment;
    }

    public boolean getSaveTransient() {
        return this.mbSaveTransient;
    }

    public boolean getUseSingleQuoteAttr() {
        return this.mbUseSingleQuoteAttr;
    }

    public boolean getIgnoreExtraRootData() {
        return this.mbIgnoreExtraRootData;
    }

    public void setCanonicalizeNamespaceOrder(boolean bCanonicalizeNamespaceOrder) {
        this.mbCanonicalizeNamespaceOrder = bCanonicalizeNamespaceOrder;
    }

    public void setDisabledEntityChars(String sEntityChars) {
        this.msDisabledEntityChars = sEntityChars;
    }

    public void setDisplayFormat(int ePrintFmt) {
        this.mePrintFmt = ePrintFmt;
    }

    public void setEntityChars(String sEntityChars) {
        this.msEntityChars = sEntityChars;
    }

    public void setExcludePreamble(boolean bExcludePreamble) {
        this.mbExcludePreamble = bExcludePreamble;
    }

    public void setExpandElement(boolean bExpandElement) {
        this.mbExpandElement = bExpandElement;
    }

    public void setFormatOutside(boolean bFormatOutside) {
        this.mbFormatOutside = bFormatOutside;
    }

    public void setIncludeDTD(boolean bIncludeDTD) {
        this.mbIncludeDTD = bIncludeDTD;
    }

    public void setIndentLevel(int nIndentLevel) {
        this.mnIndentLevel = nIndentLevel;
    }

    public void setRangeMax(char cRangeMax) {
        this.mcRangeMax = cRangeMax;
    }

    public void setRangeMin(char cRangeMin) {
        this.mcRangeMin = cRangeMin;
    }

    public void setSaveFragment(boolean bSaveFragment) {
        this.mbSaveFragment = bSaveFragment;
    }

    public void setSaveTransient(boolean bSaveTransient) {
        this.mbSaveTransient = bSaveTransient;
    }

    public void setUseSingleQuoteAttr(boolean bUseSingleQuoteAttr) {
        this.mbUseSingleQuoteAttr = bUseSingleQuoteAttr;
    }

    public void setIgnoreExtraRootData(boolean bIgnoreExtraRootData) {
        this.mbIgnoreExtraRootData = bIgnoreExtraRootData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeIndent(OutputStream out, int level) throws IOException {
        if (this.mePrintFmt == 2) {
            out.write(10);
            int n = level * this.getIndentLevel();
            byte[] indent = mIndent;
            if (indent == null || indent.length < n) {
                Object object = this.sync;
                synchronized (object) {
                    indent = mIndent;
                    if (indent == null || indent.length < n) {
                        indent = new byte[n];
                        Arrays.fill(indent, (byte)32);
                        mIndent = indent;
                    }
                }
            }
            out.write(indent, 0, n);
        }
    }
}

