/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;
import java.util.ArrayList;
import java.util.List;

public final class ArrayNodeList
extends NodeList {
    private final List<Node> mArray;

    public ArrayNodeList() {
        this.mArray = new ArrayList<Node>();
    }

    public ArrayNodeList(List<? extends Node> list) {
        this.mArray = new ArrayList<Node>(list);
    }

    public ArrayNodeList(Element e) {
        this.mArray = new ArrayList<Node>();
        for (Node child = e.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            this.mArray.add(child);
        }
    }

    @Override
    public void append(Obj newNode) {
        if (this.isReadOnly() || newNode == null) {
            return;
        }
        if (!(newNode instanceof Node)) {
            throw new ExFull(ResId.ArgumentMismatchException);
        }
        this.mArray.add((Node)newNode);
    }

    @Override
    public Object clone() {
        return new ArrayNodeList(this.mArray);
    }

    @Override
    public String getClassAtom() {
        return "nodeList";
    }

    @Override
    public String getClassName() {
        return "nodeList";
    }

    @Override
    public Node getNamedItem(String name) {
        if (name == null) {
            return null;
        }
        String aName = name.intern();
        int n = this.mArray.size();
        for (int i = 0; i < n; ++i) {
            Node child = this.mArray.get(i);
            if (aName != child.getName()) continue;
            return child;
        }
        return null;
    }

    @Override
    public Node getNamedItem(String aName, String aClassName, int nTargetOccurrence) {
        if (aName == null && aClassName == null) {
            return null;
        }
        int nLength = this.length();
        int nOccurrence = 0;
        if (nTargetOccurrence > nLength) {
            return null;
        }
        for (int i = 0; i < nLength; ++i) {
            boolean bMatched = false;
            Node tmp = (Node)this.item(i);
            if (aName != null && aClassName != null) {
                if (aClassName == tmp.getClassAtom() && aName == tmp.getName()) {
                    bMatched = true;
                }
            } else if (aClassName != null && aClassName == tmp.getClassAtom()) {
                bMatched = true;
            } else if (aName != null && aName == tmp.getName()) {
                bMatched = true;
            }
            if (!bMatched) continue;
            if (nOccurrence == nTargetOccurrence) {
                return tmp;
            }
            ++nOccurrence;
        }
        return null;
    }

    @Override
    Integer getOccurrence(Node oNode) {
        int nLength = this.length();
        int nOccurrence = 0;
        String aName = oNode.getName();
        String aClassName = oNode.getClassAtom();
        for (int i = 0; i < nLength; ++i) {
            Node oTemp = this.mArray.get(i);
            if (aClassName != oTemp.getClassAtom() || aName != oTemp.getName()) continue;
            if (oNode == oTemp) {
                return nOccurrence;
            }
            ++nOccurrence;
        }
        return null;
    }

    @Override
    public void insert(Obj newNode, Obj refNode) {
        if (this.isReadOnly() || newNode == null) {
            return;
        }
        if (refNode == null) {
            throw new ExFull(ResId.InsertFailedException);
        }
        if (!(newNode instanceof Node)) {
            throw new ExFull(ResId.ArgumentMismatchException);
        }
        if (!(refNode instanceof Node)) {
            throw new ExFull(ResId.ArgumentMismatchException);
        }
        for (int i = 0; i < this.mArray.size(); ++i) {
            if (this.mArray.get(i) != refNode) continue;
            this.mArray.add(i, (Node)newNode);
        }
    }

    @Override
    public Obj item(int index) {
        return this.mArray.get(index);
    }

    @Override
    public int length() {
        return this.mArray.size();
    }

    @Override
    public void remove(Obj removeNode) {
        if (this.isReadOnly() || removeNode == null) {
            return;
        }
        if (!(removeNode instanceof Node)) {
            throw new ExFull(ResId.ArgumentMismatchException);
        }
        this.mArray.remove(removeNode);
    }

    @Override
    boolean appendPermsCheck() {
        return true;
    }

    @Override
    boolean removePermsCheck(Obj obj) {
        return true;
    }

    @Override
    boolean insertPermsCheck() {
        return true;
    }
}

