/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.action;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionLaunch;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFWindowsLaunchParameters;
import com.adobe.internal.pdftoolkit.xpdf.XPDFHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFAction;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFWindowsLaunchParameters;
import com.adobe.internal.pdftoolkit.xpdf.model.document.XPDFFileSpecification;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPDFActionLaunch
extends XPDFAction {
    private PDFActionLaunch pdfActionLaunch;

    public XPDFActionLaunch(PDFActionLaunch pdfActionLaunch) {
        super(pdfActionLaunch);
        this.pdfActionLaunch = pdfActionLaunch;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        ch.startElement(parentName);
        AttributesImpl att = new AttributesImpl();
        if (this.pdfActionLaunch.hasNewWindow()) {
            att.addAttribute("", "NewWindow", "NewWindow", "CDATA", this.pdfActionLaunch.getNewWindow() ? "true" : "false");
        }
        ch.startElement("Launch", att);
        if (this.pdfActionLaunch.hasFileSpecification()) {
            new XPDFFileSpecification(this.pdfActionLaunch.getFileSpecification()).toXPDF(ch, "File");
        }
        if (this.pdfActionLaunch.hasWindowsLaunchParameters()) {
            new XPDFWindowsLaunchParameters(this.pdfActionLaunch.getWindowsLaunchParameters()).toXPDF(ch, "Win");
        }
        super.exportNextToXPDF(ch, parentName);
        ch.endElement("Launch");
        ch.endElement(parentName);
    }

    @Override
    public void fromXPDFStart(XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        String s = att.getValue("NewWindow");
        if (s != null) {
            if (!"true".equals(s) && !"false".equals(s)) {
                eh.XPDFError("Invalid value ('" + s + "') for 'NewWindow' attribute");
            }
            this.pdfActionLaunch.setNewWindow("true".equals(s));
        }
    }

    @Override
    public XPDFHandler fromXPDFStartElement(String lName, XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if ("File".equals(lName)) {
            PDFFileSpecification file = PDFFileSpecification.newSkeletonInstance(this.pdfActionLaunch.getPDFDocument());
            this.pdfActionLaunch.setFileSpecification(file);
            return new XPDFFileSpecification(file);
        }
        if ("Win".equals(lName)) {
            PDFWindowsLaunchParameters win = PDFWindowsLaunchParameters.newInstance(this.pdfActionLaunch.getPDFDocument());
            this.pdfActionLaunch.setWindowsLaunchParameters(win);
            return new XPDFWindowsLaunchParameters(win);
        }
        return super.fromXPDFStartElement(lName, att, eh);
    }

    @Override
    public void fromXPDFEnd(XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if (!this.pdfActionLaunch.hasWindowsLaunchParameters() && !this.pdfActionLaunch.hasFileSpecification()) {
            eh.XPDFError("A 'File' or 'Win' child element is required");
        }
    }
}

