/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.action;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFormImportData;
import com.adobe.internal.pdftoolkit.xpdf.XPDFHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFAction;
import com.adobe.internal.pdftoolkit.xpdf.model.document.XPDFFileSpecification;
import org.xml.sax.SAXException;

public class XPDFActionFormImportData
extends XPDFAction {
    private PDFActionFormImportData pdfActionFormImportData;

    public XPDFActionFormImportData(PDFActionFormImportData pdfActionFormImportData) {
        super(pdfActionFormImportData);
        this.pdfActionFormImportData = pdfActionFormImportData;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        ch.startElement(parentName);
        ch.startElement("ImportData");
        if (!this.pdfActionFormImportData.hasFileSpecification()) {
            throw new PDFInvalidDocumentException("Missing /F key in javascript action dict.");
        }
        new XPDFFileSpecification(this.pdfActionFormImportData.getFileSpecification()).toXPDF(ch, "File");
        super.exportNextToXPDF(ch, parentName);
        ch.endElement("ImportData");
        ch.endElement(parentName);
    }

    @Override
    public XPDFHandler fromXPDFStartElement(String lName, XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if ("File".equals(lName)) {
            PDFFileSpecification file = PDFFileSpecification.newSkeletonInstance(this.pdfActionFormImportData.getPDFDocument());
            try {
                this.pdfActionFormImportData.setFileSpecification(file);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException(e);
            }
            return new XPDFFileSpecification(file);
        }
        return super.fromXPDFStartElement(lName, att, eh);
    }

    @Override
    public void fromXPDFEnd(XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if (!this.pdfActionFormImportData.hasFileSpecification()) {
            eh.XPDFError("One 'File' child element is required");
        }
    }
}

