/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xml;

import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class XMLElement {
    private final boolean stripNamespaceVersion;
    private final String originalNamespace;
    private final String namespace;
    private final String element;
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final String ATTRIBUTE_TYPE_CDATA = "CDATA";
    private static final Pattern namespaceVersionRegEx = Pattern.compile("(?:/\\d+(?:\\.\\d+)*){0,1}/?$");

    public XMLElement(String namespace, String element, boolean stripNamespaceVersion) {
        this.stripNamespaceVersion = stripNamespaceVersion;
        this.originalNamespace = namespace;
        this.namespace = this.stripNamespaceVersion ? XMLElement.stripNamespaceVersion(namespace) : namespace;
        this.element = element;
    }

    public XMLElement(String namespace, String element) {
        this(namespace, element, false);
    }

    public String getElementName() {
        return this.element;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getOriginalNamespace() {
        return this.originalNamespace;
    }

    public boolean getShouldStripNamespaceVersion() {
        return this.stripNamespaceVersion;
    }

    public boolean matches(String namespace, String name) {
        return this.matches(namespace, name, this.stripNamespaceVersion);
    }

    private boolean matches(String namespace, String name, boolean stripNamespaceVersion) {
        if (this.element != null && name != null && !this.element.equals(name)) {
            return false;
        }
        if (stripNamespaceVersion) {
            namespace = XMLElement.stripNamespaceVersion(namespace);
        }
        return this.namespace == null || namespace == null || this.namespace.equals(namespace);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XMLElement)) {
            return false;
        }
        XMLElement otherElement = (XMLElement)obj;
        if (!this.matches(otherElement.namespace, otherElement.element, false)) {
            return false;
        }
        return otherElement.getShouldStripNamespaceVersion() == this.stripNamespaceVersion;
    }

    public int hashCode() {
        return this.element.hashCode() ^ this.namespace.hashCode() * (this.stripNamespaceVersion ? 1 : -1);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.element == null ? "\"null\"" : this.element);
        buffer.append(" : ");
        buffer.append(this.namespace == null ? "\"null\"" : this.namespace);
        buffer.append("  -  ");
        buffer.append(this.stripNamespaceVersion ? "strip namespace version" : "dont' strip namespace version");
        return buffer.toString();
    }

    protected static String stripNamespaceVersion(String namespace) {
        if (namespace == null) {
            return null;
        }
        Matcher m = namespaceVersionRegEx.matcher(namespace);
        if (m.find()) {
            return m.replaceFirst("");
        }
        return namespace;
    }

    public void startElement(ContentHandler handler, NamespaceSupport namespaceSupport, Attributes atts) throws SAXException {
        handler.startElement(this.getNamespace(), XMLUtils.getQualifiedName(this.getNamespace(), this.getElementName(), namespaceSupport), this.getElementName(), atts);
    }

    public void startElement(ContentHandler handler, NamespaceSupport namespaceSupport) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        this.startElement(handler, namespaceSupport, atts);
    }

    public void endElement(ContentHandler handler, NamespaceSupport namespaceSupport) throws SAXException {
        handler.endElement(this.getNamespace(), XMLUtils.getQualifiedName(this.getNamespace(), this.getElementName(), namespaceSupport), this.getElementName());
    }
}

