/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import java.util.ArrayList;
import java.util.List;

final class XFDFFieldList
extends ArrayList {
    private static final long serialVersionUID = 1L;
    private String name;
    private XFDFFieldList parent;
    private PDFFieldNode basePDFField;

    private XFDFFieldList(List pdfFields, String fieldName) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this.name = fieldName;
        this.basePDFField = null;
        if (pdfFields != null) {
            for (int fieldInd = 0; fieldInd < pdfFields.size(); ++fieldInd) {
                this.placeXFDFField(pdfFields.get(fieldInd));
            }
        }
    }

    private XFDFFieldList(PDFFieldNode parent, String fieldName) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this(parent.getChildren(), fieldName);
        this.basePDFField = parent;
    }

    XFDFFieldList(List pdfFields) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this(pdfFields, "");
    }

    private XFDFFieldList(String prefix) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this((List)null, prefix);
    }

    private void placeXFDFField(Object curField) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        XFDFFieldList parentField;
        Object newField;
        if (curField instanceof PDFFieldNode) {
            PDFField realField;
            PDFFieldNode pdfField = (PDFFieldNode)curField;
            newField = pdfField;
            String fieldName = pdfField.getPartialName();
            if (fieldName == null) {
                if (pdfField.isTerminalField() && ((PDFField)pdfField).isAnnotation()) {
                    return;
                }
                throw new PDFInvalidDocumentException("Expected a partial field name");
            }
            String baseName = XFDFFieldList.getBaseFieldName(fieldName);
            parentField = this.getParentField(fieldName);
            if (!((PDFFieldNode)curField).isTerminalField() && ((XFDFFieldList)(newField = new XFDFFieldList((PDFFieldNode)curField, baseName))).size() == 0 && (realField = PDFField.getInstance(pdfField.getCosObject())) != null) {
                newField = realField;
            }
        } else {
            throw new PDFInvalidDocumentException("Expected a field");
        }
        parentField.add(newField);
    }

    static String getBaseFieldName(String fieldName) {
        String baseName = fieldName;
        int startBaseName = fieldName.lastIndexOf(46);
        if (startBaseName >= 0) {
            baseName = fieldName.substring(startBaseName + 1);
        }
        return baseName;
    }

    private XFDFFieldList getParentField(String fieldName) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        int startBaseName = fieldName.lastIndexOf(46);
        if (startBaseName == -1) {
            return this;
        }
        return this.getFieldByName(fieldName.substring(0, startBaseName));
    }

    private XFDFFieldList getFieldByName(String fieldName) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        XFDFFieldList parentField = this.getParentField(fieldName);
        String baseName = XFDFFieldList.getBaseFieldName(fieldName);
        XFDFFieldList namedField = parentField.findFieldByName(fieldName);
        if (namedField != null) {
            return namedField;
        }
        XFDFFieldList child = new XFDFFieldList(baseName);
        parentField.add(child);
        return child;
    }

    XFDFFieldList findFieldByName(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        for (int fieldInd = 0; fieldInd < this.size(); ++fieldInd) {
            Object curField = this.get(fieldInd);
            if (!(curField instanceof XFDFFieldList) || !fieldName.equals(((XFDFFieldList)curField).name)) continue;
            return (XFDFFieldList)curField;
        }
        return null;
    }

    @Override
    public boolean add(Object child) {
        super.add(child);
        if (child instanceof XFDFFieldList) {
            ((XFDFFieldList)child).parent = this;
        }
        return true;
    }

    public PDFFieldNode getBaseField() {
        return this.basePDFField;
    }

    String getName() {
        return this.name;
    }

    XFDFFieldList getParent() {
        return this.parent;
    }
}

