/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSquare;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationSquare
extends XFDFAnnotation {
    static final String ELEM_SQUARE = "square";

    XFDFAnnotationSquare(PDFAnnotationSquare pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotationSquare(PDFDocument pdfDocument) {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        AttributesImpl annotsAtts = new AttributesImpl();
        this.addCommonXFDFAttributes(annotsAtts, pageNum);
        this.addMarkupXFDFAttributes(annotsAtts);
        this.addBorderStyleXFDFAttributes(annotsAtts, true);
        this.addInteriorColorXFDFAttribute(annotsAtts);
        this.addFringeXFDFAttribute(annotsAtts);
        try {
            handler.startElement("", ELEM_SQUARE, ELEM_SQUARE, annotsAtts);
            if (!this.createXFDFRichContent(handler)) {
                this.createXFDFContent(handler);
            }
            this.createXFDFExData3DMarkup(handler);
            this.addAppearanceToXFDF(handler);
            this.createXFDFPopupElement(handler, pageNum);
            handler.endElement("", ELEM_SQUARE, ELEM_SQUARE);
            handler.characters(END_ELEM, 0, 1);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", e);
        }
    }

    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        int gotPage = -1;
        PDFAnnotationSquare squareAnnot = PDFAnnotationSquare.newInstance(this.pdfDoc);
        this.pdfAnnot = null;
        gotPage = this.fillCommonAttributes(squareAnnot, elemAttrs);
        if (gotPage >= 0) {
            String rotation;
            this.fillCommonAttributes(squareAnnot, elemAttrs);
            this.fillMarkupAttributes(squareAnnot, elemAttrs);
            this.fillBorderStyleAttributes(squareAnnot, elemAttrs);
            this.fillBorderEffectsAttributes(squareAnnot, elemAttrs);
            this.fillInteriorColorAttribute(squareAnnot, elemAttrs);
            this.fillFringeAttribute(squareAnnot, elemAttrs);
            int attrInd = XFDFAnnotationSquare.findAttribute("rotation", elemAttrs);
            if (attrInd != 0 && (rotation = elemAttrs.getValue(attrInd)) != null) {
                squareAnnot.setRotation(Integer.parseInt(rotation));
                PDFAnnotationRotationEnum rotationType = this.getRotationType();
                if (rotationType == PDFAnnotationRotationEnum.OnlyPageRotation || rotationType == PDFAnnotationRotationEnum.WithPageRotation) {
                    squareAnnot.applyRotation(this.pdfDoc.requirePages().getPage(gotPage).getCropBox(), this.pdfDoc.requirePages().getPage(gotPage).getRotation().getValue());
                }
            }
            if (this.setAnnotation(squareAnnot, gotPage)) {
                this.pdfAnnot = squareAnnot;
                this.curPage = gotPage;
            }
        }
        return this.pdfAnnot;
    }
}

