/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationCircle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationCircle
extends XFDFAnnotation {
    static final String ELEM_CIRCLE = "circle";

    XFDFAnnotationCircle(PDFAnnotationCircle pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotationCircle(PDFDocument pdfDocument) {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        AttributesImpl annotsAtts = new AttributesImpl();
        this.addCommonXFDFAttributes(annotsAtts, pageNum);
        this.addMarkupXFDFAttributes(annotsAtts);
        this.addBorderStyleXFDFAttributes(annotsAtts, true);
        this.addInteriorColorXFDFAttribute(annotsAtts);
        this.addFringeXFDFAttribute(annotsAtts);
        try {
            handler.startElement("", ELEM_CIRCLE, ELEM_CIRCLE, annotsAtts);
            if (!this.createXFDFRichContent(handler)) {
                this.createXFDFContent(handler);
            }
            this.createXFDFExData3DMarkup(handler);
            this.addAppearanceToXFDF(handler);
            this.createXFDFPopupElement(handler, pageNum);
            handler.endElement("", ELEM_CIRCLE, ELEM_CIRCLE);
            handler.characters(END_ELEM, 0, 1);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", e);
        }
    }

    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        int gotPage = -1;
        PDFAnnotationCircle circleAnnot = PDFAnnotationCircle.newInstance(this.pdfDoc);
        this.pdfAnnot = null;
        gotPage = this.fillCommonAttributes(circleAnnot, elemAttrs);
        if (gotPage >= 0) {
            String rotation;
            this.fillCommonAttributes(circleAnnot, elemAttrs);
            this.fillMarkupAttributes(circleAnnot, elemAttrs);
            this.fillBorderStyleAttributes(circleAnnot, elemAttrs);
            this.fillBorderEffectsAttributes(circleAnnot, elemAttrs);
            this.fillInteriorColorAttribute(circleAnnot, elemAttrs);
            this.fillFringeAttribute(circleAnnot, elemAttrs);
            int attrInd = XFDFAnnotationCircle.findAttribute("rotation", elemAttrs);
            if (attrInd != 0 && (rotation = elemAttrs.getValue(attrInd)) != null) {
                circleAnnot.setRotation(Integer.parseInt(rotation));
                PDFAnnotationRotationEnum rotationType = this.getRotationType();
                if (rotationType == PDFAnnotationRotationEnum.OnlyPageRotation || rotationType == PDFAnnotationRotationEnum.WithPageRotation) {
                    circleAnnot.applyRotation(this.pdfDoc.requirePages().getPage(gotPage).getCropBox(), this.pdfDoc.requirePages().getPage(gotPage).getRotation().getValue());
                }
            }
            if (this.setAnnotation(circleAnnot, gotPage)) {
                this.pdfAnnot = circleAnnot;
                this.curPage = gotPage;
            }
        }
        return this.pdfAnnot;
    }
}

