/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.template;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFAInternalUtils;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.ut.ExFull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XFASeedValue {
    private PDFInteractiveForm mForm;
    private XFADOM xfaDOM = null;
    private Element filterElement = null;
    Element certificatesElement = null;
    private Field xfaField;
    private TemplateModel model = null;
    private static final String URLPOLICY = "urlPolicy";
    private static final String RoamingCredentialServer = "roamingCredentialServer";
    private static final String ASSP = "ASSP";
    private static final String BROWSER = "browser";
    private static final String SEEDVALUEREQUIRED = "required";
    private static final String SEEDVALUEOPTIONAL = "optional";
    private static final String SEEDVALUENONE = "none";
    private static final String SIGNATURE_FIELD = "ui.signature";
    public static final String MDP_AUTHOR_SIG = "author";
    public static final String MDP_FILLER_SIG = "filler";
    private boolean debug = false;

    public XFASeedValue(PDFDocument pdfDoc, Field xfaField) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfDoc == null) {
            throw new PDFInvalidDocumentException("PDF Document cannot be equal to null");
        }
        if (xfaField == null) {
            throw new PDFInvalidDocumentException("XFA Field cannot be equal to null");
        }
        if (xfaField instanceof FormField) {
            this.xfaField = (Field)xfaField.getProto();
        }
        if (this.xfaField == null) {
            this.xfaField = xfaField;
        }
        this.mForm = pdfDoc.getInteractiveForm();
        this.xfaDOM = XFADOMService.ensureXFADOMCreated(pdfDoc);
        if (this.model == null && this.getTemplateModel() == null) {
            throw new PDFInvalidParameterException("Unable to get TemplateModel from the XFA.");
        }
        if (this.filterElement == null) {
            this.getFilterElement();
        }
        if (this.certificatesElement == null) {
            this.getCertificateElement();
        }
    }

    public List<String> getDigestMethod() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            Element digestMethodsElement = this.findTemplateModelElement("digestMethods", true, false);
            if (digestMethodsElement == null) {
                return null;
            }
            return this.extractChildList(digestMethodsElement, "digestMethod");
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public void setDigestMethod(List<String> digestMethods, boolean enforceValue) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            Element digestMethodsElement = this.findTemplateModelElement("digestMethods", true, false);
            this.updateAttribute(digestMethodsElement, XFA.TYPETAG, "type", this.getTypeValue(enforceValue));
            this.replaceElementChildData(digestMethodsElement, digestMethods, "digestMethod");
            this.createSequentialChildElement(this.model, this.filterElement, digestMethodsElement, digestMethods, "digestMethods", "digestMethod", true);
            this.markXFADOMDirty();
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public List<String> getReasons() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            Element reasonsElement = this.findTemplateModelElement("reasons", true, false);
            if (reasonsElement == null) {
                return null;
            }
            if (this.debug) {
                System.out.println("Got the reasons element" + reasonsElement.getXMLChildCount());
            }
            return this.extractChildList(reasonsElement, "reason");
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public void setReasons(List<String> reasons, boolean enforceValue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            Element reasonsElement = this.findTemplateModelElement("reasons", true, false);
            this.updateAttribute(reasonsElement, XFA.TYPETAG, "type", this.getTypeValue(enforceValue));
            this.replaceElementChildData(reasonsElement, reasons, "reason");
            reasonsElement = this.createSequentialChildElement(this.model, this.filterElement, reasonsElement, reasons, "reasons", "reason", true);
            this.markXFADOMDirty();
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public List<ASName> getSubFilters() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            List<String> childList;
            Element encodingsElement = this.findTemplateModelElement("encodings", true, false);
            if (encodingsElement == null) {
                return null;
            }
            if (this.debug) {
                System.out.println("Got the encodings element" + encodingsElement.getXMLChildCount());
            }
            if ((childList = this.extractChildList(encodingsElement, "encoding")) == null) {
                return null;
            }
            ArrayList<ASName> subFiltersList = new ArrayList<ASName>(childList.size());
            Iterator<String> itr = childList.iterator();
            while (itr.hasNext()) {
                subFiltersList.add(ASName.create(itr.next()));
            }
            return subFiltersList;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public void setSubFilters(List<ASName> subFilters, boolean enforceValue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            Element encodingsElement = this.findTemplateModelElement("encodings", true, false);
            this.updateAttribute(encodingsElement, XFA.TYPETAG, "type", this.getTypeValue(enforceValue));
            this.replaceASNameElementChildData(encodingsElement, subFilters, "encoding");
            encodingsElement = this.createSequentialChildElement(this.model, this.filterElement, encodingsElement, subFilters, "encodings", "encoding", false);
            this.markXFADOMDirty();
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public boolean getAddRevInfo() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (this.filterElement == null) {
                return false;
            }
            String attrValue = XFASeedValue.getAttributeValue(this.filterElement, "addRevocationInfo");
            if (this.debug) {
                System.out.println("Add rev info flag value = " + attrValue);
            }
            if (attrValue == null) {
                return false;
            }
            return attrValue.equals(SEEDVALUEREQUIRED);
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public void setAddRevInfo(boolean revInfo) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.updateAttribute(this.filterElement, XFA.ADDREVOCATIONINFOTAG, "addRevocationInfo", this.getTypeValue(revInfo));
        this.markXFADOMDirty();
    }

    public int getFlags() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int sigSeedFlagValue = 0;
        int[] attributeList = new int[]{1, 2, 64, 8, 4, 128, 256};
        String[] tagList = new String[]{"handler", "encodings", "digestMethods", "reasons", "version", "lockDocument", "appearanceFilter"};
        for (int i = 0; i < tagList.length; ++i) {
            Element handlerElement = this.findTemplateModelElement(tagList[i], false, false);
            if (handlerElement == null || !this.isAttrValueRequired(handlerElement)) continue;
            sigSeedFlagValue += attributeList[i];
        }
        if (this.getAddRevInfoFlag()) {
            sigSeedFlagValue += 32;
        }
        return sigSeedFlagValue;
    }

    public void setFlags(Integer flagValue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            int sigFlagValue = 0;
            if (flagValue != null) {
                sigFlagValue = flagValue;
            }
            int[] attributeList = new int[]{1, 2, 64, 8, 128, 256};
            String[] tagList = new String[]{"handler", "encodings", "digestMethods", "reasons", "lockDocument", "appearanceFilter"};
            boolean enforceValue = false;
            for (int i = 0; i < tagList.length; ++i) {
                enforceValue = (sigFlagValue & attributeList[i]) != 0;
                Element flagElement = this.findTemplateModelElement(tagList[i], true, false);
                this.updateAttribute(flagElement, XFA.TYPETAG, "type", this.getTypeValue(enforceValue));
            }
            enforceValue = (sigFlagValue & 0x20) != 0;
            this.setAddRevInfoFlag(enforceValue);
            this.markXFADOMDirty();
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public int getMDP() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int mdpValNotSet = -1;
        try {
            Element mdpElement = this.findTemplateModelElement("mdp", true, false);
            if (mdpElement == null) {
                return mdpValNotSet;
            }
            String signatureType = XFASeedValue.getAttributeValue(mdpElement, "signatureType");
            if (signatureType == null || signatureType.length() == 0) {
                return mdpValNotSet;
            }
            if (signatureType.equals(MDP_FILLER_SIG)) {
                return 0;
            }
            if (signatureType.equals(MDP_AUTHOR_SIG)) {
                String permType = mdpElement.getAttribute(XFA.PERMISSIONSTAG).getAttrValue();
                if (permType == null || permType.length() == 0) {
                    return -1;
                }
                try {
                    return Integer.parseInt(permType);
                }
                catch (NumberFormatException e) {
                    throw new PDFInvalidDocumentException("MDP Permissions are not a number", e);
                }
            }
            return -1;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public void setMDP(int permValue, String sigType) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (permValue == 0 && sigType.equalsIgnoreCase(MDP_AUTHOR_SIG)) {
            throw new PDFInvalidParameterException("Invalid permissions value for an author signature field");
        }
        if (permValue == 0 && sigType.equalsIgnoreCase(MDP_FILLER_SIG)) {
            permValue = 2;
        }
        Element mdpElement = this.findTemplateModelElement("mdp", true, false);
        if (permValue != -1) {
            this.updateAttribute(mdpElement, XFA.PERMISSIONSTAG, "permissions", String.valueOf(permValue));
            this.updateAttribute(mdpElement, XFA.SIGNATURETYPETAG, "signatureType", sigType);
        } else {
            mdpElement.remove();
        }
        this.markXFADOMDirty();
    }

    public String getFilter() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            String text;
            Element handlerElement = this.findTemplateModelElement("handler", true, false);
            if (handlerElement == null) {
                return null;
            }
            TextNode textNode = handlerElement.getText(false, false, false);
            if (textNode != null && (text = textNode.getValue()) != null && text.length() > 0) {
                return text;
            }
            return null;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public void setFilter(String handlerName, boolean enforceValue) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Element handlerElement = this.findTemplateModelElement("handler", true, false);
        TextNode textNode = handlerElement.getText(false, false, false);
        if (handlerName == null) {
            textNode.remove();
        } else {
            textNode.setValue(handlerName, true, false);
            this.updateAttribute(handlerElement, XFA.TYPETAG, "type", this.getTypeValue(enforceValue));
        }
        this.markXFADOMDirty();
    }

    public String getLockDocument() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            String text;
            Element lockElement = this.findTemplateModelElement("lockDocument", true, false);
            if (lockElement == null) {
                return null;
            }
            TextNode textNode = lockElement.getText(false, false, false);
            if (textNode != null && (text = textNode.getValue()) != null && text.length() > 0) {
                return text;
            }
            return null;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public void setLockDocument(String lockDocument, boolean enforceValue) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        AppModel appModel = this.getAppModel();
        if (appModel.getVersionRestriction() < 28) {
            appModel.setVersionRestriction(28, 0x7F0000);
            appModel.setSourceBelow(0x7D0000);
        }
        Element lockDocumentElement = this.findTemplateModelElement("lockDocument", true, false);
        TextNode textNode = lockDocumentElement.getText(false, false, false);
        if (lockDocument == null) {
            textNode.remove();
        } else {
            textNode.setValue(lockDocument, true, false);
            this.updateAttribute(lockDocumentElement, XFA.TYPETAG, "type", this.getTypeValue(enforceValue));
        }
        this.markXFADOMDirty();
    }

    public String getTimeStampURL() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            Element timestampElement = this.findTemplateModelElement("timeStamp", true, false);
            if (timestampElement == null) {
                return null;
            }
            String tsURLValue = XFASeedValue.getAttributeValue(timestampElement, "server");
            if (this.debug) {
                System.out.println("Got the timestamp server url" + tsURLValue);
            }
            return tsURLValue;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public boolean getTimeStampFlag() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            Element timestampElement = this.findTemplateModelElement("timeStamp", true, false);
            if (timestampElement == null) {
                return false;
            }
            String type = XFASeedValue.getAttributeValue(timestampElement, "type");
            return type != null && type.equalsIgnoreCase(SEEDVALUEREQUIRED);
        }
        catch (ExFull e) {
            throw new PDFInvalidDocumentException(e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public void setTimeStampUrl(String timeStampUrl, boolean enforceValue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            String typeValue = SEEDVALUEOPTIONAL;
            if (enforceValue) {
                typeValue = SEEDVALUEREQUIRED;
            }
            Element timestampElement = this.findTemplateModelElement("timeStamp", true, false);
            this.updateAttribute(timestampElement, XFA.SERVERTAG, "server", timeStampUrl);
            this.updateAttribute(timestampElement, XFA.TYPETAG, "type", typeValue);
            this.markXFADOMDirty();
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public void setTimeStampFlag(boolean timeFlag) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            String typeValue = SEEDVALUEOPTIONAL;
            if (timeFlag) {
                typeValue = SEEDVALUEREQUIRED;
            }
            Element timestampElement = this.findTemplateModelElement("timeStamp", true, false);
            this.updateAttribute(timestampElement, XFA.TYPETAG, "type", typeValue);
            this.markXFADOMDirty();
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public String getVersion() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (this.filterElement == null) {
                return null;
            }
            String versionProperty = XFASeedValue.getAttributeValue(this.filterElement, "version");
            if (this.debug) {
                System.out.println("Version value = " + versionProperty);
            }
            return versionProperty;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public void setVersion(String version) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            this.updateAttribute(this.filterElement, XFA.VERSIONTAG, "version", version);
            this.markXFADOMDirty();
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public String getAppearanceFilter() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            String text;
            Element appFilterElement = this.findTemplateModelElement("appearanceFilter", true, false);
            if (appFilterElement == null) {
                return null;
            }
            TextNode textNode = appFilterElement.getText(false, false, false);
            if (textNode != null && (text = textNode.getValue()) != null && text.length() > 0) {
                return text;
            }
            return null;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public void setAppearanceFilter(String filter, boolean enforceValue) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        AppModel appModel = this.getAppModel();
        if (appModel.getVersionRestriction() < 28) {
            appModel.setVersionRestriction(28, 0x7F0000);
            appModel.setSourceBelow(0x7D0000);
        }
        Element appFilterElement = this.findTemplateModelElement("appearanceFilter", true, false);
        if (filter == null) {
            appFilterElement.remove();
        } else {
            TextNode textNode = appFilterElement.getText(false, false, false);
            textNode.setValue(filter, true, false);
            this.updateAttribute(appFilterElement, XFA.TYPETAG, "type", this.getTypeValue(enforceValue));
        }
        this.markXFADOMDirty();
    }

    public String[] getLegalAttestations() {
        return null;
    }

    public void setLegalAttestations(String[] attestations) {
    }

    public List<String> getIssuerCertificates() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            Element certificatesElement = this.findTemplateModelElement("issuers", true, true);
            if (certificatesElement == null) {
                return null;
            }
            if (this.debug) {
                System.out.println("Got the issuer certs element" + certificatesElement.getXMLChildCount());
            }
            return this.extractChildList(certificatesElement, "certificate");
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public void setIssuerCertificates(List certificateList, boolean enforceValue) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            Element issuersElement = this.findTemplateModelElement("issuers", true, true);
            if (issuersElement == null) {
                return;
            }
            this.updateAttribute(issuersElement, XFA.TYPETAG, "type", this.getTypeValue(enforceValue));
            this.replaceElementChildData(issuersElement, certificateList, "certificate");
            this.createSequentialChildElement(this.model, this.certificatesElement, issuersElement, certificateList, "issuers", "certificate", true);
            this.markXFADOMDirty();
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public List<String> getSigningCertificates() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            Element signingElement = this.findTemplateModelElement("signing", true, true);
            if (signingElement == null) {
                return null;
            }
            if (this.debug) {
                System.out.println("Got the certs element" + signingElement.getXMLChildCount());
            }
            return this.extractChildList(signingElement, "certificate");
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public void setSigningCertificates(List certificateList, boolean enforceValue) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            Element signingElement = this.findTemplateModelElement("signing", true, true);
            if (signingElement == null) {
                return;
            }
            this.updateAttribute(signingElement, XFA.TYPETAG, "type", this.getTypeValue(enforceValue));
            this.replaceElementChildData(signingElement, certificateList, "certificate");
            this.createSequentialChildElement(this.model, this.certificatesElement, signingElement, certificateList, "signing", "certificate", true);
            this.markXFADOMDirty();
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public List getOIDS() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            Element oidsElement = this.findTemplateModelElement("oids", true, true);
            if (oidsElement == null) {
                return null;
            }
            if (this.debug) {
                System.out.println("Got the oids element" + oidsElement.getXMLChildCount());
            }
            return this.extractChildList(oidsElement, "oid");
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public void setOIDS(List oidsList, boolean enforceValue) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            Element oidsElement = this.findTemplateModelElement("oids", true, true);
            if (oidsElement == null) {
                return;
            }
            this.updateAttribute(oidsElement, XFA.TYPETAG, "type", this.getTypeValue(enforceValue));
            this.replaceElementChildData(oidsElement, oidsList, "oid");
            this.createSequentialChildElement(this.model, this.certificatesElement, oidsElement, oidsList, "oids", "oid", true);
            this.markXFADOMDirty();
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public String getKeyUsages() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            Element keyUsageElement = this.findTemplateModelElement("keyUsage", true, true);
            char[] keyUsageString = new char[9];
            if (keyUsageElement != null) {
                keyUsageString[0] = this.setKeyUsageBit(XFASeedValue.getAttributeValue(keyUsageElement, "digitalSignature"));
                keyUsageString[1] = this.setKeyUsageBit(XFASeedValue.getAttributeValue(keyUsageElement, "nonRepudiation"));
                keyUsageString[2] = this.setKeyUsageBit(XFASeedValue.getAttributeValue(keyUsageElement, "keyEncipherment"));
                keyUsageString[3] = this.setKeyUsageBit(XFASeedValue.getAttributeValue(keyUsageElement, "dataEncipherment"));
                keyUsageString[4] = this.setKeyUsageBit(XFASeedValue.getAttributeValue(keyUsageElement, "keyAgreement"));
                keyUsageString[5] = this.setKeyUsageBit(XFASeedValue.getAttributeValue(keyUsageElement, "keyCertSign"));
                keyUsageString[6] = this.setKeyUsageBit(XFASeedValue.getAttributeValue(keyUsageElement, "crlSign"));
                keyUsageString[7] = this.setKeyUsageBit(XFASeedValue.getAttributeValue(keyUsageElement, "encipherOnly"));
                keyUsageString[8] = this.setKeyUsageBit(XFASeedValue.getAttributeValue(keyUsageElement, "decipherOnly"));
                for (int i = 0; i < 9; ++i) {
                    if (keyUsageString[i] == 'X') continue;
                    return new String(keyUsageString);
                }
            }
            return null;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public void setKeyUsages(char[] keyUsages, boolean enforceValue) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        try {
            Element keyUsagesElement = this.findTemplateModelElement("keyUsage", true, true);
            if (keyUsages == null || keyUsages.length == 0) {
                keyUsagesElement.remove();
            } else {
                this.updateAttribute(keyUsagesElement, XFA.DIGITALSIGNATURETAG, "digitalSignature", this.getKeyUsageBitValue(keyUsages[0]));
                this.updateAttribute(keyUsagesElement, XFA.NONREPUDIATIONTAG, "nonRepudiation", this.getKeyUsageBitValue(keyUsages[1]));
                this.updateAttribute(keyUsagesElement, XFA.KEYENCIPHERMENTTAG, "keyEncipherment", this.getKeyUsageBitValue(keyUsages[2]));
                this.updateAttribute(keyUsagesElement, XFA.DATAENCIPHERMENTTAG, "dataEncipherment", this.getKeyUsageBitValue(keyUsages[3]));
                this.updateAttribute(keyUsagesElement, XFA.KEYAGREEMENTTAG, "keyAgreement", this.getKeyUsageBitValue(keyUsages[4]));
                this.updateAttribute(keyUsagesElement, XFA.KEYCERTSIGNTAG, "keyCertSign", this.getKeyUsageBitValue(keyUsages[5]));
                this.updateAttribute(keyUsagesElement, XFA.CRLSIGNTAG, "crlSign", this.getKeyUsageBitValue(keyUsages[6]));
                this.updateAttribute(keyUsagesElement, XFA.ENCIPHERONLYTAG, "encipherOnly", this.getKeyUsageBitValue(keyUsages[7]));
                this.updateAttribute(keyUsagesElement, XFA.DECIPHERONLYTAG, "decipherOnly", this.getKeyUsageBitValue(keyUsages[8]));
                this.updateAttribute(keyUsagesElement, XFA.TYPETAG, "type", this.getTypeValue(enforceValue));
            }
            this.markXFADOMDirty();
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public String getURL() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (this.certificatesElement == null) {
                return null;
            }
            String urlValue = XFASeedValue.getAttributeValue(this.certificatesElement, "url");
            if (this.debug) {
                System.out.println("Got the credential server url" + urlValue);
            }
            return urlValue;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public String getURLPolicy() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (this.certificatesElement == null) {
                return null;
            }
            String urlPolicyValue = XFASeedValue.getAttributeValue(this.certificatesElement, URLPOLICY);
            if (this.debug) {
                System.out.println("URL policy = " + urlPolicyValue);
            }
            if (urlPolicyValue == null) {
                return BROWSER;
            }
            if ("enrollmentServer".equals(urlPolicyValue)) {
                return BROWSER;
            }
            if (urlPolicyValue.equals(RoamingCredentialServer)) {
                return ASSP;
            }
            return urlPolicyValue;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public void setURL(String serverURL, String urlPolicy, boolean enforceValue) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        try {
            if (this.certificatesElement == null) {
                return;
            }
            this.updateAttribute(this.certificatesElement, XFA.URLTAG, "url", serverURL);
            this.updateAttribute(this.certificatesElement, XFA.URLPOLICYTAG, URLPOLICY, urlPolicy);
            this.updateAttribute(this.certificatesElement, XFA.CREDENTIALSERVERPOLICYTAG, "credentialServerPolicy", this.getTypeValue(enforceValue));
            this.markXFADOMDirty();
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public List<String> getSubjectDNS() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            Element subjectDNSElement = this.findTemplateModelElement("subjectDNs", true, true);
            if (subjectDNSElement == null) {
                return null;
            }
            if (this.debug) {
                System.out.println("Got the subjectdns element" + subjectDNSElement.getXMLChildCount());
            }
            return this.extractChildList(subjectDNSElement, "subjectDN");
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public void setSubjectDNS(List subjectDNSList, String delimiter, boolean enforceValue) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            Element subjectDNSElement = this.findTemplateModelElement("subjectDNs", true, true);
            if (subjectDNSElement == null) {
                return;
            }
            this.updateAttribute(subjectDNSElement, XFA.TYPETAG, "type", this.getTypeValue(enforceValue));
            this.replaceElementChildData(subjectDNSElement, subjectDNSList, "subjectDN");
            this.createSequentialChildElement(this.model, this.certificatesElement, subjectDNSElement, subjectDNSList, "subjectDNs", "subjectDN", true);
            this.updateAttributeForChildrenSet(subjectDNSElement, XFA.DELIMITERTAG, "delimiter", delimiter);
            this.markXFADOMDirty();
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public int getCertificateSeedValueFlags() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int sigSeedFlagValue = 0;
        int[] attributeList = new int[]{2, 32, 4, 1, 8};
        String[] tagList = new String[]{"issuers", "keyUsage", "oids", "signing", "subjectDNs"};
        for (int i = 0; i < tagList.length; ++i) {
            Element handlerElement = this.findTemplateModelElement(tagList[i], false, true);
            if (handlerElement == null || !this.isAttrValueRequired(handlerElement)) continue;
            sigSeedFlagValue += attributeList[i];
        }
        if (this.getCertUrlFlag()) {
            sigSeedFlagValue += 64;
        }
        return sigSeedFlagValue;
    }

    public void setCertificateSeedValueFlags(Integer flagValue) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int sigFlagValue = 0;
        if (flagValue != null) {
            sigFlagValue = flagValue;
        }
        boolean enforceValue = false;
        int[] attributeList = new int[]{2, 32, 4, 1, 8};
        String[] tagList = new String[]{"issuers", "keyUsage", "oids", "signing", "subjectDNs"};
        for (int i = 0; i < tagList.length; ++i) {
            enforceValue = (sigFlagValue & attributeList[i]) != 0;
            Element flagElement = this.findTemplateModelElement(tagList[i], true, true);
            this.updateAttribute(flagElement, XFA.TYPETAG, "type", this.getTypeValue(enforceValue));
        }
        enforceValue = (sigFlagValue & 0x40) != 0;
        this.updateAttribute(this.certificatesElement, XFA.CREDENTIALSERVERPOLICYTAG, "credentialServerPolicy", this.getTypeValue(enforceValue));
        this.markXFADOMDirty();
    }

    private void getFilterElement() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            this.checkXFAVersion(true);
            if (this.model == null) {
                throw new PDFInvalidParameterException("Template Model is null");
            }
            Node signatureNode = this.xfaField.resolveNode(SIGNATURE_FIELD);
            if (!(signatureNode instanceof Element)) {
                throw new PDFInvalidParameterException("There is no signature element in the field");
            }
            Node filterNode = signatureNode.resolveNode("filter", false, false, false);
            if (!(filterNode instanceof Element)) {
                this.filterElement = this.model.createElement(XFA.FILTERTAG, null);
                signatureNode.getNodes().append(this.filterElement);
            } else {
                this.filterElement = (Element)filterNode;
            }
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    private void getCertificateElement() {
        this.certificatesElement = (Element)this.filterElement.resolveNode("certificates");
    }

    private void checkXFAVersion(boolean doVersionUpgrade) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        AppModel appModel = this.getAppModel();
        if (appModel.getVersionRestriction() < 25 && doVersionUpgrade) {
            appModel.setVersionRestriction(25, 0x7F0000);
            appModel.setSourceBelow(0x7D0000);
        }
    }

    public Element findTemplateModelElement(String elementSomExpr, boolean createIfNotPresent, boolean searchInCertificateElement) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            Node nodeFound = null;
            if (searchInCertificateElement) {
                if (this.certificatesElement == null) {
                    return null;
                }
                nodeFound = createIfNotPresent ? this.certificatesElement.resolveNode(elementSomExpr) : this.certificatesElement.resolveNode(elementSomExpr, true, false, false);
            } else {
                if (this.filterElement == null) {
                    return null;
                }
                nodeFound = createIfNotPresent ? this.filterElement.resolveNode(elementSomExpr) : this.filterElement.resolveNode(elementSomExpr, true, false, false);
            }
            if (!(nodeFound instanceof Element)) {
                return null;
            }
            return (Element)nodeFound;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public AppModel getAppModel() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.mForm == null) {
            return null;
        }
        if (this.xfaDOM == null) {
            return null;
        }
        return this.xfaDOM.getAppModel();
    }

    public TemplateModel getTemplateModel() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.mForm == null) {
            return null;
        }
        if (this.xfaDOM == null) {
            return null;
        }
        this.model = this.xfaDOM.getTemplateModel();
        return this.model;
    }

    private StringAttr createAttribute(String xfaTag, String value) {
        return new StringAttr(xfaTag, value);
    }

    private void updateAttribute(Element element, int attrTag, String attrName, String value) throws PDFInvalidParameterException {
        if (element == null) {
            return;
        }
        if (value != null) {
            if (element.getAttribute(attrTag, true, false) != null) {
                element.setAttribute(null, attrName, attrName, value);
            } else {
                this.setAttributeValue(element, this.createAttribute(attrName, value), attrTag);
            }
        } else {
            this.setAttributeValue(element, this.createAttribute(attrName, ""), attrTag);
        }
    }

    private void setAttributeValue(Element xfaElement, Attribute attribute, int attrTag) throws PDFInvalidParameterException {
        try {
            xfaElement.setAttribute(attribute, attrTag);
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    private void updateAttributeForChildrenSet(Element parentElement, int attrTag, String attrName, String value) throws PDFInvalidParameterException {
        for (Node child = parentElement.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            this.updateAttribute((Element)child, attrTag, attrName, value);
        }
    }

    private void replaceASNameElementChildData(Element filterChildElement, List<ASName> valueList, String xfaTagName) {
        Node child = filterChildElement.getFirstXFAChild();
        Node sibling = null;
        while (child != null) {
            Node childNode;
            if (child.getClassName().equals(xfaTagName) && (childNode = child.getFirstXFAChild()) instanceof TextNode) {
                ASName value = ASName.create(((TextNode)childNode).getValue());
                if (valueList != null && valueList.contains(value)) {
                    valueList.remove(value);
                } else {
                    sibling = child.getNextXFASibling();
                    filterChildElement.removeChild(child);
                    child = sibling;
                    continue;
                }
            }
            child = child.getNextXFASibling();
        }
    }

    private void replaceElementChildData(Element filterChildElement, List valueList, String xfaTagName) {
        Node child = filterChildElement.getFirstXFAChild();
        Node sibling = null;
        while (child != null) {
            Node childNode;
            if (child.getClassName().equals(xfaTagName) && (childNode = child.getFirstXFAChild()) instanceof TextNode) {
                String value = ((TextNode)childNode).getValue();
                if (valueList != null && valueList.contains(value)) {
                    valueList.remove(value);
                } else {
                    sibling = child.getNextXFASibling();
                    filterChildElement.removeChild(child);
                    child = sibling;
                    continue;
                }
            }
            child = child.getNextXFASibling();
        }
    }

    private Element createChildElementList(TemplateModel model, List valueList, Element childElement, String xfaTagName, boolean isString) throws PDFUnableToCompleteOperationException {
        Iterator listIter;
        Element childSequenceElement = null;
        if (valueList != null && (listIter = valueList.iterator()) != null) {
            while (listIter.hasNext()) {
                childSequenceElement = model.createElement(childElement, childElement.getLastXMLChild(), null, xfaTagName);
                Object curElement = listIter.next();
                if (curElement == null) continue;
                if (isString) {
                    model.createTextNode(childSequenceElement, null, (String)curElement);
                    continue;
                }
                model.createTextNode(childSequenceElement, null, ((ASName)curElement).asString());
            }
        }
        return childElement;
    }

    private Element createSequentialChildElement(TemplateModel model, Element parentElement, Element childElement, List valueList, String parentXFATagName, String childXFATagName, boolean isString) throws PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        if (childElement == null) {
            childElement = model.createElement(parentElement, null, null, parentXFATagName);
        }
        childElement = this.createChildElementList(model, valueList, childElement, childXFATagName, isString);
        return childElement;
    }

    private String getTypeValue(boolean enforceValue) {
        if (enforceValue) {
            return SEEDVALUEREQUIRED;
        }
        return SEEDVALUEOPTIONAL;
    }

    private String getKeyUsageBitValue(char value) {
        if (value == '1') {
            return "yes";
        }
        if (value == 'X') {
            return "no";
        }
        return "no";
    }

    private char setKeyUsageBit(String value) {
        if (value == null) {
            return 'X';
        }
        if ("yes".equals(value)) {
            return '1';
        }
        if ("no".equals(value)) {
            return '0';
        }
        return 'X';
    }

    public static String getAttributeValue(Element xfaElement, String attributeName) throws PDFInvalidParameterException {
        try {
            int numAttrs = xfaElement.getNumAttrs();
            for (int i = 0; i < numAttrs; ++i) {
                if (!xfaElement.getAttrName(i).equals(attributeName)) continue;
                return xfaElement.getAttrVal(i);
            }
            return null;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    private boolean isAttrValueRequired(Element xfaElement) throws PDFInvalidParameterException {
        try {
            String attributeValue = XFASeedValue.getAttributeValue(xfaElement, "type");
            return attributeValue != null && attributeValue.equals(SEEDVALUEREQUIRED);
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    private boolean getCertUrlFlag() throws PDFInvalidParameterException {
        try {
            if (this.certificatesElement == null) {
                return false;
            }
            String attributeValue = XFASeedValue.getAttributeValue(this.certificatesElement, "credentialServerPolicy");
            return attributeValue != null && attributeValue.equals(SEEDVALUEREQUIRED);
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    private boolean getAddRevInfoFlag() throws PDFInvalidParameterException {
        try {
            if (this.filterElement == null) {
                return false;
            }
            String attrValue = XFASeedValue.getAttributeValue(this.filterElement, "addRevocationInfo");
            if (this.debug) {
                System.out.println("Add rev info flag value = " + attrValue);
            }
            if (attrValue == null) {
                return false;
            }
            return !attrValue.equals(SEEDVALUENONE);
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    private void setAddRevInfoFlag(boolean isRequired) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!isRequired) {
            this.updateAttribute(this.filterElement, XFA.ADDREVOCATIONINFOTAG, "addRevocationInfo", SEEDVALUENONE);
            this.markXFADOMDirty();
        }
    }

    private List<String> extractChildList(Element listElement, String attribute) {
        int size = listElement.getXMLChildCount();
        if (size == 0) {
            return null;
        }
        ArrayList<String> childList = new ArrayList<String>(size);
        for (Node child = listElement.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            Node childNode;
            if (!child.getClassName().equals(attribute) || !((childNode = child.getFirstXFAChild()) instanceof TextNode)) continue;
            if (this.debug) {
                System.out.println("Child value = " + ((TextNode)childNode).getValue());
            }
            childList.add(((TextNode)childNode).getValue());
        }
        return childList;
    }

    private void markXFADOMDirty() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        XFAInternalUtils.markXFADOMDirty(this.xfaDOM);
    }

    public void removeSignatureFilterElement() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        try {
            if (this.filterElement != null) {
                this.filterElement.remove();
            }
            this.markXFADOMDirty();
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }
}

