/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CButtonField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CTextField;
import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.service.renderer.FormUtils;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.ui.UI;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringHolder;
import com.adobe.xfa.ut.StringUtils;

public class FieldValueExchange {
    private Node m_oNode;
    private CPDField m_PDField;
    private DocumentContext m_poContext;

    public FieldValueExchange(DocumentContext poContext, CPDField field, Node oNode) {
        this.m_oNode = oNode;
        this.m_PDField = field;
        this.m_poContext = poContext;
        assert (this.m_oNode != null);
    }

    public void updateAcroField() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        if (this.m_oNode == null) {
            return;
        }
        if (this.m_poContext != null && !this.m_poContext.getAllowFormUpdate()) {
            return;
        }
        if (this.m_oNode instanceof FormField) {
            assert (this.m_PDField != null);
            if (this.m_PDField.getType() == CPDField.k_Button) {
                CButtonField pCButtonFld = (CButtonField)this.m_PDField;
                pCButtonFld.setIconsFromXFAImageContent();
            } else if (this.m_PDField instanceof CTextField && ((CTextField)this.m_PDField).isXFABarcode()) {
                this.m_PDField.getPDFFieldNode().getCosDictionary().remove(ASName.k_V);
            } else {
                FormField oField = (FormField)this.m_oNode;
                StringHolder sNewAcroVal = new StringHolder();
                boolean bRichText = this.isRichTextField(oField, sNewAcroVal);
                if (!bRichText) {
                    sNewAcroVal.value = this.isChoiceField(oField) ? oField.getRawValue() : oField.getFormattedValue();
                    if (!"".equals(sNewAcroVal.value) && (this.m_PDField.getFlags() & 0x2000000) > 0) {
                        sNewAcroVal.value = StringUtils.toXHTML(sNewAcroVal.value, true);
                    }
                }
                this.setFieldValue(sNewAcroVal.value);
            }
        } else if (this.m_oNode instanceof ExclGroup) {
            ExclGroup oExclGroup = (ExclGroup)this.m_oNode;
            String sNewAcroVal = oExclGroup.getRawValue();
            this.setFieldValue(sNewAcroVal);
        }
    }

    private void setFieldValue(String sValue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        if (this.m_PDField.getType() == ASName.k_Tx && this.m_PDField.CPDField_getValue(ASName.k_V).getType() == 6) {
            return;
        }
        boolean bGenerateAppearances = this.m_PDField.setValueFromEStr(sValue);
        if (!bGenerateAppearances && this.m_PDField.getType() == CPDField.k_ListBox && StringUtils.isEmpty(sValue) && this.m_poContext.getNeedAppearances()) {
            bGenerateAppearances = true;
            this.m_poContext.setNeedAppearancesToExplicitFalseAfterLoad(true);
        }
        if (bGenerateAppearances) {
            this.m_PDField.generateAppearances(null, false);
        }
    }

    private boolean isChoiceField(FormField oField) {
        Element oChoiceListNode;
        UI oUINode;
        return oField != null && (oUINode = (UI)oField.getElement(XFA.UITAG, 0)) != null && (oChoiceListNode = oUINode.getUIElement(false)).isSameClass(XFA.CHOICELISTTAG);
    }

    private boolean isRichTextField(FormField field, StringHolder newAcroVal) {
        return FormUtils.getRichTextField(field, newAcroVal);
    }

    public boolean updateXFAField(String sAcroVal, boolean bCalcOverride) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION);
    }
}

