/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.acroform;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFVariableText;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.impl.PDFDefaultAppearanceWrapper;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.AFUtils;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CChkBxBasedField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.TextAppearance_t;

public abstract class CWidget {
    public static final int TextAP_charSpacing = 1;
    public static final int TextAP_wordSpacing = 2;
    public static final int TextAP_horizontalScale = 4;
    public static final int TextAP_leading = 8;
    public static final int TextAP_textRise = 16;
    public static final int TextAP_textSize = 32;
    public static final int TextAP_textMatrix = 64;
    public static final int TextAP_strokeColor = 128;
    public static final int TextAP_fillColor = 256;
    public static final int TextAP_renderMode = 512;
    public static final int TextAP_quadding = 1024;
    public static final int TextAP_baseFont = 2048;
    public static final int TextAP_nameFont = 4096;
    public static final int TextAP_options = 8192;
    public static final int TextAP_nativeZeroDigit = 16384;
    public static final int TextAP_ALL = 65535;
    protected int m_pdObjNum;
    protected int iWidget;

    CWidget(CosObject annot, int iWidget) {
        this.m_pdObjNum = annot.getObjNum();
        this.iWidget = iWidget;
    }

    public PDFAnnotationWidget getPDAnnot() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        return PDFAnnotationWidget.getInstance(this.getCPDField().getCosDoc().getIndirectObjectByNumber(this.m_pdObjNum));
    }

    public void setFlags(int flags, int flagType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        PDFAnnotationWidget pdan = this.getPDAnnot();
        int oldFlags = pdan.getFlags();
        if (flagType == 2) {
            flags |= oldFlags;
        } else if (flagType == 3) {
            flags = ~flags & oldFlags;
        }
        if (flags != oldFlags) {
            pdan.setFlags(flags);
        }
    }

    protected PDFDefaultAppearanceWrapper getDefaultAppearance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDefaultAppearanceWrapper defaultAppearance;
        PDFAnnotationWidget pdan = this.getPDAnnot();
        PDFDefaultAppearance defAp = null;
        PDFVariableText varTxt = PDFVariableText.getInstance(pdan.getCosObject());
        PDFDefaultAppearance defApFromParent = varTxt.getDefaultAppearance();
        if (defApFromParent == null) {
            throw new PDFInvalidDocumentException("Document doesn't contain default appearance /DA.");
        }
        boolean needClone = false;
        CosObject cosValue = pdan.getDictionaryValue(ASName.k_DA);
        if (cosValue == null) {
            needClone = true;
        } else if (cosValue.isIndirect()) {
            needClone = true;
        } else {
            defAp = defApFromParent;
        }
        if (needClone) {
            defAp = PDFDefaultAppearance.newInstance(pdan.getPDFDocument(), defApFromParent.asString());
            varTxt.setDefaultAppearance(defAp);
        }
        try {
            defaultAppearance = new PDFDefaultAppearanceWrapper(defAp);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidDocumentException("Cannot instantiate default appearance.", e);
        }
        return defaultAppearance;
    }

    public void setDefaultTextAppearance(TextAppearance_t textAP, int textAPType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
    }

    boolean getBorder(AFUtils.AFPDWidgetBorderRec pdwb) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosObject coWidth;
        pdwb.nWidth = 1;
        pdwb.nStyle = PDFBorderStyle.Style.Solid;
        CosDictionary coAnnot = this.getPDAnnot().getCosDictionary();
        CosObject coBorderStyle = coAnnot.get(ASName.k_BS);
        if (coBorderStyle == null || coBorderStyle.getType() == 0) {
            CosObject coBorder = coAnnot.get(ASName.k_Border);
            if (coBorder != null && coBorder.getType() == 5) {
                pdwb.nStyle = ((CosArray)coBorder).size() >= 4 ? PDFBorderStyle.Style.Dashed : PDFBorderStyle.Style.Solid;
                pdwb.nWidth = ((CosArray)coBorder).getInt(2);
                return true;
            }
            return false;
        }
        CosObject coName = ((CosDictionary)coBorderStyle).get(ASName.k_S);
        if (coName != null && coName.getType() == 3) {
            ASName asaName = ((CosName)coName).nameValue();
            pdwb.nStyle = asaName == ASName.k_D ? PDFBorderStyle.Style.Dashed : (asaName == ASName.k_I ? PDFBorderStyle.Style.Inset : (asaName == ASName.k_B ? PDFBorderStyle.Style.Beveled : (asaName == ASName.k_U ? PDFBorderStyle.Style.Underline : PDFBorderStyle.Style.Solid)));
        }
        if ((coWidth = ((CosDictionary)coBorderStyle).get(ASName.k_W)) != null && coWidth.getType() == 1) {
            pdwb.nWidth = ((CosNumeric)coWidth).intValue();
        }
        return pdwb.nWidth > 0;
    }

    void setBorder(AFUtils.AFPDWidgetBorderRec pdwb) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        AFUtils.AFPDWidgetBorderRec pdwbOld = new AFUtils.AFPDWidgetBorderRec();
        this.getBorder(pdwbOld);
        if (pdwb.nStyle == null && pdwb.nWidth < 0 || pdwb.nStyle != null && pdwb.nWidth >= 0 && pdwbOld.equals(pdwb)) {
            return;
        }
        CosDictionary coAnnot = this.getPDAnnot().getCosDictionary();
        coAnnot.remove(ASName.k_Border);
        if (pdwb.nWidth == 1 && pdwb.nStyle == PDFBorderStyle.Style.Solid) {
            coAnnot.remove(ASName.k_BS);
        } else {
            CosDictionary coBorder = AFUtils.AFCosDictEnsure(coAnnot, ASName.k_BS);
            CosDocument cd = coAnnot.getDocument();
            if (pdwb.nWidth >= 0) {
                coBorder.put(ASName.k_W, cd.createCosNumeric(pdwb.nWidth));
            }
            ASName asaName = pdwb.nStyle == PDFBorderStyle.Style.Dashed ? ASName.k_D : (pdwb.nStyle == PDFBorderStyle.Style.Inset ? ASName.k_I : (pdwb.nStyle == PDFBorderStyle.Style.Beveled ? ASName.k_B : (pdwb.nStyle == PDFBorderStyle.Style.Underline ? ASName.k_U : ASName.k_S)));
            if (pdwb.nStyle != null) {
                coBorder.put(ASName.k_S, cd.createCosName(asaName));
            }
            if (pdwb.nStyle == PDFBorderStyle.Style.Dashed) {
                CosArray coArray = cd.createCosArray();
                coArray.add(0, cd.createCosNumeric(196608));
                coBorder.put(ASName.k_D, coArray);
            }
            coAnnot.put(ASName.k_BS, coBorder);
        }
    }

    CosObject getAppearance(ASName asaFace, ASName asaSubFace) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject co = this.getPDAnnot().getDictionaryCosObjectValue(ASName.k_AP);
        if (co != null && co.getType() == 6) {
            if ((co = ((CosDictionary)co).get(asaFace)) != null && co.getType() == 6) {
                if (asaSubFace != null) {
                    return ((CosDictionary)co).get(asaSubFace);
                }
                return co;
            }
            if (co != null && co.getType() == 7) {
                return co;
            }
        }
        return this.getCPDField().getCosDoc().createCosNull();
    }

    CosObject getMK() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary coAnnot = this.getPDAnnot().getCosDictionary();
        CosObject coMK = coAnnot.get(ASName.k_MK);
        if (coMK != null && coMK.getType() == 6) {
            return coMK;
        }
        CosObject coApp = this.getAppearance(ASName.k_N, CChkBxBasedField.k_Off);
        if (coApp != null && coApp.getType() == 7 && (coMK = ((CosStream)coApp).get(ASName.k_MK)) != null && coMK.getType() == 6) {
            ((CosStream)coApp).remove(ASName.k_MK);
            coAnnot.put(ASName.k_MK, coMK);
            return coMK;
        }
        return coAnnot.getDocument().createCosNull();
    }

    protected CosDictionary makeMK() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosDictionary coAnnot = this.getPDAnnot().getCosDictionary();
        CosDictionary coMK = coAnnot.getDocument().createCosDictionary();
        coAnnot.put(ASName.k_MK, coMK);
        return coMK;
    }

    protected CosObject getOrCreateMK() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject coMK = this.getMK();
        if (coMK == null || coMK.getType() == 6) {
            coMK = this.makeMK();
        }
        assert (coMK.getType() == 6);
        return coMK;
    }

    void getBorderColor(TextAppearance_t.PDColorValueRec pdcvBorder) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject coMK = this.getMK();
        if (coMK.getType() == 6) {
            AFUtils.AFPDColorLoad(((CosDictionary)coMK).get(ASName.k_BC), pdcvBorder);
        } else {
            AFUtils.AFPDColorLoad(coMK.getDocument().createCosNull(), pdcvBorder);
        }
    }

    void setBorderColor(TextAppearance_t.PDColorValueRec pdcvBorder) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        TextAppearance_t.PDColorValueRec pdcvOldBorder = new TextAppearance_t.PDColorValueRec();
        CosObject coMK = this.getOrCreateMK();
        this.getBorderColor(pdcvOldBorder);
        if (!AFUtils.AFPDColorValueEqual(pdcvOldBorder, pdcvBorder)) {
            if (AFUtils.AFPDColorValueIsTransparent(pdcvBorder)) {
                if (coMK != null && coMK.getType() == 6) {
                    ((CosDictionary)coMK).remove(ASName.k_BC);
                }
            } else {
                if (coMK == null || coMK.getType() != 6) {
                    coMK = this.makeMK();
                }
                AFUtils.AFPDColorStore(coMK, ASName.k_BC, pdcvBorder);
            }
        }
    }

    void getBackgroundColor(TextAppearance_t.PDColorValueRec pdcvBackground) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject coMK = this.getMK();
        if (coMK.getType() == 6) {
            AFUtils.AFPDColorLoad(((CosDictionary)coMK).get(ASName.k_BG), pdcvBackground);
        } else {
            AFUtils.AFPDColorLoad(coMK.getDocument().createCosNull(), pdcvBackground);
        }
    }

    void setBackgroundColor(TextAppearance_t.PDColorValueRec pdcvBackground) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        TextAppearance_t.PDColorValueRec pdcvOldBackground = new TextAppearance_t.PDColorValueRec();
        CosObject coMK = this.getOrCreateMK();
        this.getBackgroundColor(pdcvOldBackground);
        if (!AFUtils.AFPDColorValueEqual(pdcvOldBackground, pdcvBackground)) {
            if (AFUtils.AFPDColorValueIsTransparent(pdcvBackground)) {
                if (coMK != null && coMK.getType() == 6) {
                    ((CosDictionary)coMK).remove(ASName.k_BG);
                }
            } else {
                if (coMK == null || coMK.getType() != 6) {
                    coMK = this.makeMK();
                }
                AFUtils.AFPDColorStore(coMK, ASName.k_BG, pdcvBackground);
            }
        }
    }

    abstract void generateAppearance(String var1, boolean var2) throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFFontException;

    abstract CPDField getCPDField();

    protected void generateAppearance() throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFFontException {
        this.generateAppearance(this.getCPDField().getValueForDisplay(null), false);
    }
}

