/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.acroform;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CChkBxBasedWidget;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CChkBxField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDField;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.ui.UI;

class CChkBxWidget
extends CChkBxBasedWidget {
    CChkBxField m_pParent;
    CurrentState m_iCurrState;

    public CChkBxWidget(CChkBxField chkBxField, CosObject annotation, int i) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        super(annotation, i);
        this.m_pParent = chkBxField;
        this.delayInit();
    }

    @Override
    public CPDField getCPDField() {
        return this.m_pParent;
    }

    private boolean allowNeutral() {
        Node oField = this.getCPDField().getXFAField(true);
        if (oField != null) {
            Element oCheckButton;
            assert (oField instanceof FormField);
            UI oUINode = (UI)((FormField)oField).peekElement(XFA.UITAG, false, 0);
            if (oUINode != null && (oCheckButton = oUINode.getUIElement(true)) != null && oCheckButton.isSameClass(XFA.CHECKBUTTONTAG) && oCheckButton.getEnum(XFA.ALLOWNEUTRALTAG) == 0x40040001) {
                return true;
            }
        }
        return false;
    }

    public CurrentState getCurrentState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        if (this.m_iCurrState == CurrentState.kUnknown) {
            String sValue;
            String sNeutral;
            Field oField;
            this.m_iCurrState = CurrentState.kOff;
            if (this.allowNeutral() && (oField = (Field)this.getCPDField().getXFAField(true)) != null && (sNeutral = oField.getNeutralValue()) != null && (sValue = oField.getRawValue()).equals(sNeutral)) {
                this.m_iCurrState = CurrentState.kNeutral;
            }
            if (this.m_iCurrState == CurrentState.kOff && this.isChecked()) {
                this.m_iCurrState = CurrentState.kOn;
            }
        }
        return this.m_iCurrState;
    }

    void invalidateCurrentState() {
        this.m_iCurrState = CurrentState.kUnknown;
    }

    @Override
    public void generateAppearance(String esDisplayVal, boolean onlyIfHasNoApp) throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFFontException {
        this.updateState();
    }

    public static enum CurrentState {
        kUnknown,
        kOff,
        kNeutral,
        kOn;

    }
}

