/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa;

import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFXFAArray;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFXFAPacket;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAElementContentFinder;
import com.adobe.internal.pdftoolkit.services.xfa.form.CosDocument;
import com.adobe.internal.pdftoolkit.services.xfa.impl.PDFFormSupport;
import com.adobe.internal.pdftoolkit.xml.XMLElement;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import com.adobe.xfa.ut.BooleanHolder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XFAService {
    private static final XFAElement XDPElement = new XFAElement("http://ns.adobe.com/xdp", "xdp", true);

    private XFAService() {
    }

    public static boolean importElement(PDFDocument pdfDocument, XFAElement xfaElement, InputStream xmlStream) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException {
        return XFAService.importElement(pdfDocument, xfaElement, new StreamSource(xmlStream));
    }

    public static boolean importElement(PDFDocument pdfDocument, XFAElement xfaElement, Source xmlSource) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException {
        PDFInteractiveForm iForm = pdfDocument.getInteractiveForm();
        if (iForm == null) {
            return false;
        }
        if (iForm.xfaIsArray()) {
            return PDFFormSupport.importXFAElementIntoArray(pdfDocument.getInteractiveForm(), xfaElement, xmlSource);
        }
        if (iForm.xfaIsStream()) {
            return PDFFormSupport.importXFAElementIntoStream(pdfDocument.getInteractiveForm(), xfaElement, xmlSource);
        }
        return false;
    }

    public static boolean exportElement(PDFDocument pdfDocument, XFAElement xfaElement, OutputStream xmlStream) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException {
        return XFAService.exportElement(pdfDocument, xfaElement, new StreamResult(xmlStream));
    }

    public static boolean exportElement(PDFDocument pdfDocument, XFAElement xfaElement, Result xmlResult) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException {
        PDFInteractiveForm iForm = pdfDocument.getInteractiveForm();
        if (iForm == null) {
            return false;
        }
        if (iForm.xfaIsArray()) {
            return PDFFormSupport.exportXFAElementFromArray(pdfDocument.getInteractiveForm(), xfaElement, xmlResult);
        }
        if (iForm.xfaIsStream()) {
            return PDFFormSupport.exportXFAElementFromStream(pdfDocument.getInteractiveForm(), xfaElement, xmlResult);
        }
        return false;
    }

    public static boolean exportFullXFA(PDFDocument pdfDocument, Result xmlResult, boolean includeXDPElement) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        InputByteStream ibs = null;
        InputStream stream = null;
        try {
            PDFInteractiveForm iForm = pdfDocument.getInteractiveForm();
            if (!iForm.hasXFA()) {
                boolean bl = false;
                return bl;
            }
            ibs = PDFFormSupport.getFullXFAStream(iForm);
            if (ibs == null || ibs.length() == 0L) {
                boolean bl = false;
                return bl;
            }
            stream = ibs.toInputStream();
            XMLUtils.extractXMLElement(new InputSource(stream), xmlResult, XDPElement, includeXDPElement, false);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        catch (TransformerException e) {
            throw new PDFInvalidXMLException(e);
        }
        catch (SAXException e) {
            throw new PDFInvalidXMLException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
                if (ibs != null) {
                    ibs.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
        return true;
    }

    public static boolean getFullStream(PDFDocument pdfDocument, OutputStream xfaStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        InputByteStream stream = null;
        try {
            PDFInteractiveForm iForm = pdfDocument.getInteractiveForm();
            if (iForm == null) {
                boolean bl = false;
                return bl;
            }
            if (!iForm.hasXFA()) {
                boolean bl = false;
                return bl;
            }
            stream = PDFFormSupport.getFullXFAStream(iForm);
            if (stream == null) {
                boolean bl = false;
                return bl;
            }
            IO.copy(stream, xfaStream);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
        return true;
    }

    public static void removeXFA(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFInteractiveForm iform = pdfDocument.getInteractiveForm();
        if (iform == null) {
            return;
        }
        iform.setXFA((PDFXFAArray)null);
    }

    private static InputByteStream getXFAConfigStream(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        ByteArrayOutputStream outStm = null;
        InputByteStream xfaStream = null;
        PDFInteractiveForm iform = pdfDocument.getInteractiveForm();
        try {
            if (iform == null || !iform.hasXFA()) {
                InputByteStream inputByteStream = null;
                return inputByteStream;
            }
            if (iform.xfaIsArray()) {
                PDFXFAArray xfaArray = iform.getXFAAsArray();
                PDFStream xfaConfigStream = xfaArray.getStream(new ASString("config"));
                if (xfaConfigStream == null) {
                    InputByteStream inputByteStream = null;
                    return inputByteStream;
                }
                outStm = new ByteArrayOutputStream(xfaConfigStream.getLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)xfaConfigStream.getLength());
                xfaConfigStream.getStreamData(outStm);
                xfaStream = pdfDocument.getStreamManager().getInputByteStream(outStm.toByteArray());
            } else {
                xfaStream = PDFFormSupport.getStreamFromXFAStream(iform.getXFAAsStream());
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            try {
                if (outStm != null) {
                    outStm.close();
                }
            }
            catch (IOException iOException) {}
        }
        return xfaStream;
    }

    private static XFAElementContentFinder setUpXFAElementContentFinder(InputByteStream xfaStream, ArrayList elements, String searchString) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        if (xfaStream == null) {
            return null;
        }
        XFAElementContentFinder finder = new XFAElementContentFinder(elements, searchString);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(xfaStream.toInputStream(), (DefaultHandler)finder);
        }
        catch (SAXException e) {
            throw new PDFInvalidXMLException("Invalid XML present when determining if the document contains dynamic forms", e);
        }
        catch (IOException e) {
            throw new PDFIOException("IO error encountered when determining if the document contains dynamic forms", e);
        }
        catch (ParserConfigurationException e) {
            throw new PDFConfigurationException("Configuration error encountered when determining if the document contains dynamic forms", e);
        }
        return finder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XFAElementContentFinder createDynamicXFAContentFinder(PDFDocument pdfDocument, String searchString) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        InputByteStream xfaConfig = XFAService.getXFAConfigStream(pdfDocument);
        try {
            XFAElementContentFinder xFAElementContentFinder = XFAService.createDynamicXFAContentFinder(xfaConfig, searchString);
            return xFAElementContentFinder;
        }
        finally {
            try {
                if (xfaConfig != null) {
                    xfaConfig.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    private static XFAElementContentFinder createDynamicXFAContentFinder(InputByteStream xfaConfig, String searchString) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        ArrayList<String> elements = new ArrayList<String>();
        elements.add("config");
        elements.add("acrobat");
        elements.add("acrobat7");
        elements.add("dynamicRender");
        XFAElementContentFinder findDynamicRender = XFAService.setUpXFAElementContentFinder(xfaConfig, elements, searchString);
        if (findDynamicRender == null || !findDynamicRender.foundAll()) {
            elements = new ArrayList();
            elements.add("config");
            elements.add("agent");
            elements.add("acrobat7");
            elements.add("dynamicRender");
            findDynamicRender = XFAService.setUpXFAElementContentFinder(xfaConfig, elements, searchString);
        }
        return findDynamicRender;
    }

    public static boolean hasPDFChunk(InputByteStream xdpStream) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        try {
            xdpStream.seek(0L);
            ArrayList<String> elements = new ArrayList<String>();
            elements.add("pdf");
            elements.add("document");
            elements.add("chunk");
            XFAElementContentFinder chunkFinder = XFAService.setUpXFAElementContentFinder(xdpStream, elements, null);
            return chunkFinder == null ? false : chunkFinder.foundAll();
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public static boolean isDynamic(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        XFAElementContentFinder findDynamicRender = XFAService.createDynamicXFAContentFinder(pdfDocument, "required");
        if (findDynamicRender == null) {
            return false;
        }
        return findDynamicRender.findContent();
    }

    public static boolean isShellXFA(InputByteStream config) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        try {
            config.seek(0L);
            XFAElementContentFinder finder = XFAService.createDynamicXFAContentFinder(config, null);
            return finder == null ? false : finder.foundAll();
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public static boolean isStaticXFANonShell(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        PDFInteractiveForm iform = pdfDocument.getInteractiveForm();
        if (iform == null || !iform.hasXFA()) {
            return false;
        }
        return !pdfDocument.requireCatalog().getNeedsRendering() && !XFAService.isDynamic(pdfDocument);
    }

    public static boolean isStaticXFAShell(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        return pdfDocument.requireCatalog().getNeedsRendering() && !XFAService.isDynamic(pdfDocument);
    }

    public static boolean isDynamicXFANonShell(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        return !pdfDocument.requireCatalog().getNeedsRendering() && XFAService.isDynamic(pdfDocument);
    }

    public static boolean isDynamicXFAShellNoAGMRender(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        return pdfDocument.requireCatalog().getNeedsRendering() && XFAService.isDynamic(pdfDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInteractive(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        ArrayList<String> elements = new ArrayList<String>();
        elements.add("config");
        elements.add("present");
        elements.add("pdf");
        elements.add("interactive");
        InputByteStream inputByteStream = XFAService.getXFAConfigStream(pdfDocument);
        XFAElementContentFinder interactiveFinder = null;
        try {
            interactiveFinder = XFAService.setUpXFAElementContentFinder(inputByteStream, elements, "1");
        }
        finally {
            try {
                if (inputByteStream != null) {
                    inputByteStream.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
        if (interactiveFinder == null) {
            return false;
        }
        boolean found = interactiveFinder.findContent();
        if (!found) {
            elements = new ArrayList();
            elements.add("config");
            elements.add("pa");
            elements.add("pdf");
            elements.add("interactive");
            interactiveFinder = XFAService.setUpXFAElementContentFinder(XFAService.getXFAConfigStream(pdfDocument), elements, "1");
            if (interactiveFinder == null) {
                return false;
            }
            return interactiveFinder.findContent();
        }
        return true;
    }

    private static boolean isProperXFA(PDFInteractiveForm iform) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!XFADOMService.isXFADOMCreated(iform.getPDFDocument()) && iform.xfaIsArray()) {
            PDFXFAArray xfaArray = iform.getXFAAsArray();
            Iterator<PDFXFAPacket> itr = xfaArray.iterator();
            PDFXFAPacket packet = null;
            ASString packetName = null;
            BooleanHolder bTemplateFound = new BooleanHolder(false);
            BooleanHolder bConfigFound = new BooleanHolder(false);
            BooleanHolder bSourcSetFound = new BooleanHolder(false);
            BooleanHolder bConnectionSetFound = new BooleanHolder(false);
            BooleanHolder bDataSetsFound = new BooleanHolder(false);
            BooleanHolder bLocaleSetFound = new BooleanHolder(false);
            BooleanHolder bFormFound = new BooleanHolder(false);
            BooleanHolder bFoundDup = new BooleanHolder(false);
            while (itr.hasNext()) {
                packet = itr.next();
                packetName = packet.getPacketName();
                CosDocument.isProperXFAPacket(packetName.asString(), bTemplateFound, bConfigFound, bSourcSetFound, bConnectionSetFound, bDataSetsFound, bLocaleSetFound, bFormFound, bFoundDup);
                if (!bFoundDup.value) continue;
                return false;
            }
            return bTemplateFound.value && !bFoundDup.value;
        }
        return true;
    }

    public static PDFDocument.PDFDocumentType getDocumentType(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFInteractiveForm iform = pdfDoc.getInteractiveForm();
        if (iform != null) {
            if (!iform.hasXFA()) {
                pdfDoc.setPDFDocumentType(PDFDocument.PDFDocumentType.Acroform);
            } else if (pdfDoc.getPDFDocumentType() == null) {
                try {
                    if (!XFAService.isProperXFA(iform)) {
                        pdfDoc.setPDFDocumentType(PDFDocument.PDFDocumentType.Acroform);
                    }
                    if (XFAService.isDynamic(pdfDoc)) {
                        if (XFAService.isDynamicXFANonShell(pdfDoc)) {
                            pdfDoc.setPDFDocumentType(PDFDocument.PDFDocumentType.DynamicNonShellXFA);
                        }
                        pdfDoc.setPDFDocumentType(PDFDocument.PDFDocumentType.DynamicShellXFA);
                    }
                    if (XFAService.isStaticXFANonShell(pdfDoc)) {
                        pdfDoc.setPDFDocumentType(PDFDocument.PDFDocumentType.StaticNonShellXFA);
                    }
                    pdfDoc.setPDFDocumentType(PDFDocument.PDFDocumentType.StaticShellXFA);
                }
                catch (PDFInvalidXMLException e) {
                    throw new PDFInvalidDocumentException(e);
                }
                catch (PDFConfigurationException e) {
                    throw new PDFInvalidDocumentException(e);
                }
            } else {
                PDFDocument.PDFDocumentType pdfDocType = pdfDoc.getPDFDocumentType();
                if (pdfDocType == PDFDocument.PDFDocumentType.DynamicNonShellXFA || pdfDocType == PDFDocument.PDFDocumentType.DynamicShellXFA) {
                    pdfDoc.setPDFDocumentType(pdfDoc.requireCatalog().getNeedsRendering() ? PDFDocument.PDFDocumentType.DynamicShellXFA : PDFDocument.PDFDocumentType.DynamicNonShellXFA);
                } else if (pdfDocType == PDFDocument.PDFDocumentType.StaticNonShellXFA || pdfDocType == PDFDocument.PDFDocumentType.StaticShellXFA) {
                    pdfDoc.setPDFDocumentType(pdfDoc.requireCatalog().getNeedsRendering() ? PDFDocument.PDFDocumentType.StaticShellXFA : PDFDocument.PDFDocumentType.StaticNonShellXFA);
                }
            }
        } else {
            pdfDoc.setPDFDocumentType(PDFDocument.PDFDocumentType.Flat);
        }
        return pdfDoc.getPDFDocumentType();
    }

    public static final class XFAElement
    extends XMLElement {
        public static final XFAElement TEMPLATE = new XFAElement("http://www.xfa.org/schema/xfa-template/", "template", true);
        public static final XFAElement CONFIG = new XFAElement("http://www.xfa.org/schema/xci/", "config", true);
        public static final XFAElement LOCALESET = new XFAElement("http://www.xfa.org/schema/xfa-locale-set/", "localeSet", true);
        public static final XFAElement DATASETS = new XFAElement("http://www.xfa.org/schema/xfa-data/", "datasets", true);
        public static final XFAElement CONNECTIONSET = new XFAElement("http://www.xfa.org/schema/xfa-connection-set/", "connectionSet", true);
        public static final XFAElement SOURCESET = new XFAElement("http://www.xfa.org/schema/xfa-source-set/", "sourceSet", true);
        public static final XFAElement FORM = new XFAElement("http://www.xfa.org/schema/xfa-form/", "form", true);
        private static final XFAElement[] knownElements = new XFAElement[]{CONFIG, CONNECTIONSET, DATASETS, LOCALESET, SOURCESET, TEMPLATE};

        public XFAElement(String namespace, String element, boolean stripNamespaceVersion) {
            super(namespace, element, stripNamespaceVersion);
        }

        public static XFAElement findElement(String namespace, String name) {
            for (int i = 0; i < knownElements.length; ++i) {
                if (!knownElements[i].matches(namespace, name)) continue;
                return knownElements[i];
            }
            return null;
        }
    }
}

