/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa;

import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptHandler;
import com.adobe.internal.pdftoolkit.services.xfa.CustomAuthHandlerInterface;
import com.adobe.internal.pdftoolkit.services.xfa.CustomProtocolInterface;
import com.adobe.xfa.ScriptHandler;
import java.util.HashSet;
import java.util.List;

public class XFAProcessingOptions {
    private boolean saveFormDOM = true;
    private boolean createFormDOM = true;
    private boolean executeScripts = true;
    private List<ScriptHandler> scriptHandlers;
    private JavaScriptHandler javascriptHandler;
    private boolean executeAcrobatJavaScripts = true;
    private boolean cacheXFADOMS = true;
    private boolean executeXFACOSSync = true;
    private CustomAuthHandlerInterface customAuthenticationHandler = null;
    private CustomProtocolInterface customProtocol = null;
    private HashSet<String> errorMessages = null;

    public XFAProcessingOptions(XFAProcessingOptions xfaOptions) {
        this.saveFormDOM = xfaOptions.saveFormDOM;
        this.createFormDOM = xfaOptions.createFormDOM;
        this.executeScripts = xfaOptions.executeScripts;
        this.scriptHandlers = xfaOptions.scriptHandlers;
        this.javascriptHandler = xfaOptions.javascriptHandler;
        this.executeAcrobatJavaScripts = xfaOptions.executeAcrobatJavaScripts;
        this.cacheXFADOMS = xfaOptions.cacheXFADOMS;
        this.executeXFACOSSync = xfaOptions.executeXFACOSSync;
        this.customAuthenticationHandler = xfaOptions.customAuthenticationHandler;
        this.customProtocol = xfaOptions.customProtocol;
        this.errorMessages = xfaOptions.errorMessages;
    }

    public XFAProcessingOptions(boolean saveFormDOM, boolean createFormDOM) {
        this.saveFormDOM = saveFormDOM;
        this.createFormDOM = createFormDOM;
    }

    public void enableFormDOMSave() {
        this.saveFormDOM = true;
    }

    public void disableFormDOMSave() {
        this.saveFormDOM = false;
    }

    public boolean saveFormDOMEnabled() {
        return this.saveFormDOM;
    }

    public void enableFormDOMCreate() {
        this.createFormDOM = true;
    }

    public void disableFormDOMCreate() {
        this.createFormDOM = false;
    }

    public boolean createFormDOMEnabled() {
        return this.createFormDOM;
    }

    public void enableScriptExecution() {
        this.executeScripts = true;
    }

    public void disableScriptExecution() {
        this.executeScripts = false;
    }

    public boolean scriptExecutionEnabled() {
        return this.executeScripts;
    }

    public void registerScriptHandlers(List<ScriptHandler> scriptHandlers) {
        this.scriptHandlers = scriptHandlers;
    }

    public List<ScriptHandler> getScriptHandlers() {
        return this.scriptHandlers;
    }

    public void registerJavaScriptHandler(JavaScriptHandler javascriptHandler) {
        this.javascriptHandler = javascriptHandler;
    }

    public JavaScriptHandler getJavaScriptHandler() {
        return this.javascriptHandler;
    }

    public void enableAcrobatJavaScriptExecution() {
        this.executeAcrobatJavaScripts = true;
    }

    public void disableAcrobatJavaScriptExecution() {
        this.executeAcrobatJavaScripts = false;
    }

    public boolean acrobatJavaScriptExecutionEnabled() {
        return this.executeAcrobatJavaScripts;
    }

    public void enableXFADOMCaching() {
        this.cacheXFADOMS = true;
    }

    public void disableXFADOMCaching() {
        this.cacheXFADOMS = false;
    }

    public boolean xfaDOMCachingEnabled() {
        return this.cacheXFADOMS;
    }

    public void enableXFACosSync() {
        this.executeXFACOSSync = true;
    }

    public void disableXFACosSync() {
        this.executeXFACOSSync = false;
    }

    public boolean xfaCosSyncEnabled() {
        return this.executeXFACOSSync;
    }

    public CustomAuthHandlerInterface getCustomAuthenticationHandler() {
        return this.customAuthenticationHandler;
    }

    public void setCustomAuthenticationHandler(CustomAuthHandlerInterface customAuthenticationHandler) {
        this.customAuthenticationHandler = customAuthenticationHandler;
    }

    public CustomProtocolInterface getCustomProtocol() {
        return this.customProtocol;
    }

    public void setCustomProtocol(CustomProtocolInterface customProtocol) {
        this.customProtocol = customProtocol;
    }

    public void addErrorMessage(String message) {
        if (this.errorMessages == null) {
            this.errorMessages = new HashSet();
        }
        this.errorMessages.add(message);
    }

    public HashSet<String> getErrorMessages() {
        return this.errorMessages;
    }

    public static enum SigningEvent {
        PRESIGN,
        PRESAVE,
        POSTSAVE,
        POSTSIGN;

    }
}

