/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xdp;

import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.RangedByteWriter;
import com.adobe.internal.io.TagSearchingOutputStream;
import com.adobe.internal.io.stream.SkippingOutputStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveIncrementalOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveOptions;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.xdp.XDPOptions;
import com.adobe.internal.pdftoolkit.services.xdp.XDPOptionsSet;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.PDF2XFDFAnnotationsReader;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import com.adobe.internal.util.base64.ToBase64ByteWriter;
import java.io.IOException;
import javax.xml.transform.Result;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

final class PDF2XDPWriter
extends XMLFilterImpl
implements TagSearchingOutputStream.Callback {
    static final char[] XDP_TAG = new char[]{'\ufdd0', '\ufdd1', '\ufdd2'};
    private static final String PDF_ELEMENT_NAME = "pdf";
    private static final String CHUNK_ELEMENT_NAME = "chunk";
    private static final String DOCUMENT_ELEMENT_NAME = "document";
    private static final String GENERATOR_NAME = "\"Adobe PDF Java Toolkit 1.0\"";
    private static final String API_VERSION = "\"2.2.4330.0\"";
    static final String GENERATOR_STRING = "generator=\"Adobe PDF Java Toolkit 1.0\" APIVersion=\"2.2.4330.0\"";
    private final PDFDocument pdfDocument;
    private final ByteWriter byteWriter;
    private final SkippingOutputStream originalStream;
    private final XDPOptions xdpOutputOptions;
    private final PDFSaveOptions saveOptions;

    PDF2XDPWriter(PDFDocument pdfDocument, ByteWriter byteWriter, SkippingOutputStream originalStream, XDPOptions writeOptions, PDFSaveOptions saveOptions) {
        this.pdfDocument = pdfDocument;
        this.byteWriter = byteWriter;
        this.originalStream = originalStream;
        this.xdpOutputOptions = writeOptions;
        this.saveOptions = saveOptions == null ? PDFSaveIncrementalOptions.newInstance() : saveOptions;
    }

    private void handleElement(XFAService.XFAElement element) throws IOException, SAXException {
        Result result = XMLUtils.createInsertionResult(this.getContentHandler(), element);
        try {
            XFAService.exportElement(this.pdfDocument, element, result);
        }
        catch (PDFInvalidDocumentException e) {
            throw new SAXException(e);
        }
        catch (PDFIOException e) {
            IOException ioe = new IOException("Error during XFA processing.");
            ioe.initCause(e);
            throw ioe;
        }
        catch (PDFInvalidXMLException e) {
            throw new SAXException(e);
        }
        catch (PDFSecurityException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        if (this.getContentHandler() == null) {
            throw new SAXException("No content handler");
        }
        try {
            this.getContentHandler().startDocument();
            this.getContentHandler().processingInstruction("xfa", GENERATOR_STRING);
            AttributesImpl nullAttrs = new AttributesImpl();
            AttributesImpl nsAttrs = new AttributesImpl();
            nsAttrs.addAttribute("", "", "xmlns:xdp", "CDATA", "http://ns.adobe.com/xdp/");
            this.getContentHandler().startElement("", "", "xdp:xdp", nsAttrs);
            PDFInteractiveForm iform = this.pdfDocument.getInteractiveForm();
            if (iform != null) {
                if (this.xdpOutputOptions.contains(XDPOptionsSet.kAllXFA)) {
                    Result result = XMLUtils.createInsertionResult(this.getContentHandler());
                    try {
                        XFAService.exportFullXFA(this.pdfDocument, result, false);
                    }
                    catch (PDFInvalidDocumentException e) {
                        throw new SAXException(e);
                    }
                    catch (PDFIOException e) {
                        IOException ioe = new IOException("Error during XFA processing.");
                        ioe.initCause(e);
                        throw ioe;
                    }
                    catch (PDFInvalidXMLException e) {
                        throw new SAXException(e);
                    }
                    catch (PDFSecurityException e) {
                        throw new SAXException(e);
                    }
                } else {
                    if (this.xdpOutputOptions.contains(XDPOptionsSet.kConfig)) {
                        this.handleElement(XFAService.XFAElement.CONFIG);
                    }
                    if (this.xdpOutputOptions.contains(XDPOptionsSet.kTemplate)) {
                        this.handleElement(XFAService.XFAElement.TEMPLATE);
                    }
                    if (this.xdpOutputOptions.contains(XDPOptionsSet.kLocaleSet)) {
                        this.handleElement(XFAService.XFAElement.LOCALESET);
                    }
                    if (this.xdpOutputOptions.contains(XDPOptionsSet.kSourceSet)) {
                        this.handleElement(XFAService.XFAElement.SOURCESET);
                    }
                    if (this.xdpOutputOptions.contains(XDPOptionsSet.kDatasets)) {
                        this.handleElement(XFAService.XFAElement.DATASETS);
                    }
                }
            }
            AttributesImpl pdfAttrs = new AttributesImpl();
            pdfAttrs.addAttribute("", "", "xmlns", "CDATA", "http://ns.adobe.com/xdp/pdf/");
            this.getContentHandler().startElement("", "", PDF_ELEMENT_NAME, pdfAttrs);
            this.getContentHandler().startElement("", "", DOCUMENT_ELEMENT_NAME, nullAttrs);
            this.getContentHandler().startElement("", "", CHUNK_ELEMENT_NAME, nullAttrs);
            this.getContentHandler().characters(XDP_TAG, 0, XDP_TAG.length);
            char[] lf = new char[]{'\n'};
            this.getContentHandler().characters(lf, 0, 1);
            this.getContentHandler().endElement("", "", CHUNK_ELEMENT_NAME);
            this.getContentHandler().endElement("", "", DOCUMENT_ELEMENT_NAME);
            this.getContentHandler().endElement("", "", PDF_ELEMENT_NAME);
            if (this.xdpOutputOptions.contains(XDPOptionsSet.kXfdf)) {
                PDF2XFDFAnnotationsReader annotsOut = new PDF2XFDFAnnotationsReader(this.pdfDocument);
                annotsOut.setContentHandler(this.getContentHandler());
                annotsOut.HandleAnnotations(false);
            }
            this.getContentHandler().endElement("", "", "xdp:xdp");
            this.getContentHandler().endDocument();
        }
        catch (PDFIOException e) {
            IOException newException = new IOException("Error during parsing.");
            newException.initCause(e);
            throw newException;
        }
        catch (PDFException e) {
            throw new SAXException("Error during parsing.", e);
        }
    }

    @Override
    public boolean tagFound(TagSearchingOutputStream oStream) throws IOException {
        long originalLength = this.byteWriter.length();
        RangedByteWriter rangeBW = new RangedByteWriter(this.byteWriter, originalLength);
        rangeBW.setCloseOriginal(false);
        ToBase64ByteWriter base64BW = new ToBase64ByteWriter(rangeBW);
        this.saveOptions.setSaveToCopy(true);
        try {
            this.pdfDocument.save(base64BW, this.saveOptions);
        }
        catch (PDFException e) {
            IOException ioe = new IOException("Problems saving PDFDocument to Base64 format for XDP.");
            ioe.initCause(e);
            throw ioe;
        }
        this.originalStream.skip(this.byteWriter.length() - originalLength);
        return false;
    }
}

