/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.textextraction.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.pdf.content.processor.CharacterScript;
import com.adobe.internal.pdftoolkit.pdf.content.processor.PDFCharacter;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.SamePositionCharacterComparator;
import java.util.Comparator;

class HorizontalCharacterSorter
implements Comparator<PDFCharacter> {
    private boolean ignoreYCoordinates;

    public HorizontalCharacterSorter() {
        this.ignoreYCoordinates = false;
    }

    public HorizontalCharacterSorter(boolean ignoreYCoordinates) {
        this.ignoreYCoordinates = ignoreYCoordinates;
    }

    @Override
    public int compare(PDFCharacter c1, PDFCharacter c2) {
        double endX2;
        int compareValue;
        boolean c2RTL;
        if (c1 == c2) {
            return 0;
        }
        boolean needsRTLSorting = false;
        ASCoordinate origin1 = c1.getSortCordinate() == null ? c1.getOrigin() : c1.getSortCordinate();
        ASCoordinate origin2 = c2.getSortCordinate() == null ? c2.getOrigin() : c2.getSortCordinate();
        double x1 = origin1.x();
        double y1 = origin1.y();
        double x2 = origin2.x();
        double y2 = origin2.y();
        if (this.ignoreYCoordinates) {
            y1 = y2;
        }
        if (y2 < y1) {
            return -1;
        }
        if (y1 < y2) {
            return 1;
        }
        CharacterScript script1 = c1.getScript();
        CharacterScript script2 = c2.getScript();
        boolean c1RTL = script1 != null && script1.isRTL();
        boolean bl = c2RTL = script2 != null && script2.isRTL();
        int n = c2RTL == c1RTL ? 0 : (compareValue = c1RTL ? 1 : -1);
        if (compareValue != 0) {
            return compareValue;
        }
        needsRTLSorting = c1RTL;
        if (needsRTLSorting) {
            double endX22;
            if (x1 > x2) {
                return -1;
            }
            if (x2 > x1) {
                return 1;
            }
            double endX1 = c1.getEnd().x();
            if (endX1 > (endX22 = c2.getEnd().x())) {
                return -1;
            }
            if (endX1 < endX22) {
                return 1;
            }
            try {
                return SamePositionCharacterComparator.compareTo(c1, c2);
            }
            catch (Exception e) {
                throw new PDFRuntimeException("Exception occured while comparing unicode strings.", e);
            }
        }
        if (x1 < x2) {
            return -1;
        }
        if (x1 > x2) {
            return 1;
        }
        double endX1 = c1.getEnd().x();
        if (endX1 < (endX2 = c2.getEnd().x())) {
            return -1;
        }
        if (endX1 > endX2) {
            return 1;
        }
        try {
            return SamePositionCharacterComparator.compareTo(c1, c2);
        }
        catch (Exception e) {
            throw new PDFRuntimeException("Exception occured while comparing unicode strings.", e);
        }
    }
}

