/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.textextraction.impl;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Base14;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.fontmanagement.FontResolutionPriority;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.fontset.impl.PDFFontSetImpl;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.StandardFontUtils;

public class Base14FontSetUtil {
    public static PDFFontSet buildBase14FontSet(PDFFontSet original, PDFDocument doc) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException {
        PDFFontSetImpl pdfFontSet = new PDFFontSetImpl((PDFFontSetImpl)original);
        pdfFontSet.setResolutionPriority(FontResolutionPriority.LAST);
        try {
            Font[] base14Fonts = StandardFontUtils.getBase14Fonts();
            for (int idxFont = 0; idxFont < base14Fonts.length; ++idxFont) {
                pdfFontSet.getCSS20FontSet().addFont(base14Fonts[idxFont]);
                pdfFontSet.getPSFontSet().addFont(new PostscriptFontDescription(base14Fonts[idxFont].getPDFFontDescription().getBase14Name()), base14Fonts[idxFont]);
            }
            if (!pdfFontSet.hasRootFallback()) {
                pdfFontSet.addFallbackFont(PDFDocument.ROOT_LOCALE, Base14.courierRegular);
            }
            if (original == null || ((PDFFontSetImpl)original).getCSS20FontSet().isEmpty()) {
                pdfFontSet.getCSS20FontSet().setFallbackFonts(pdfFontSet.getFallbackFontSet());
            }
        }
        catch (FontEngineException e) {
            throw new RuntimeException("Internal error with built-in base 14 font.", e);
        }
        return pdfFontSet;
    }
}

