/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.swf.utils;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.services.swf.utils.SWFSprite;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.PlaceObject;
import flash.swf.types.Matrix;
import flash.swf.types.TagList;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public class SWFUtils {
    public static PlaceObject placeObject(DefineTag symbol, Matrix matrix, SWFSprite swfSprite) {
        PlaceObject po3 = new PlaceObject(70);
        po3.setRef(symbol);
        DefineSprite sprite = swfSprite.getDefineSprite();
        po3.depth = ++sprite.depthCounter;
        po3.setBlendMode(1);
        po3.setMatrix(matrix);
        sprite.tagList.placeObject3(po3);
        return po3;
    }

    public static String getPathString(GeneralPath genPath, double pageHeight) {
        PathIterator pathItr = genPath.getPathIterator(null);
        double[] coords = new double[6];
        StringBuilder pathString = new StringBuilder();
        double[] lastMoveTo = new double[2];
        while (!pathItr.isDone()) {
            int segType = pathItr.currentSegment(coords);
            switch (segType) {
                case 0: {
                    pathString.append(" M " + coords[0] + " " + (pageHeight - coords[1]));
                    lastMoveTo[0] = coords[0];
                    lastMoveTo[1] = coords[1];
                    break;
                }
                case 1: {
                    pathString.append(" L " + coords[0] + " " + (pageHeight - coords[1]));
                    break;
                }
                case 2: {
                    pathString.append(" Q " + coords[0] + " " + (pageHeight - coords[1]) + " " + coords[2] + " " + (pageHeight - coords[3]));
                    break;
                }
                case 3: {
                    pathString.append(" C " + coords[0] + " " + (pageHeight - coords[1]) + " " + coords[2] + " " + (pageHeight - coords[3]) + " " + coords[4] + " " + (pageHeight - coords[5]));
                    break;
                }
                case 4: {
                    pathString.append(" L " + lastMoveTo[0] + " " + (pageHeight - lastMoveTo[1]));
                }
            }
            pathItr.next();
        }
        return pathString.toString();
    }

    public static float[] doubleArrayToFloat(double[] array) {
        float[] output = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            output[i] = (float)array[i];
        }
        return output;
    }

    public static SWFSprite createDefineSprite(String name) {
        if (name == null) {
            throw new RuntimeException("Please mention a name for the sprite.");
        }
        DefineSprite sprite = new DefineSprite();
        sprite.tagList = new TagList();
        sprite.framecount = 1;
        sprite.name = name;
        return new SWFSprite(sprite);
    }

    public static double toTwips(double d) {
        return d * 20.0;
    }

    public static double[] getImageBBox(double[] transformationMatrix) {
        ASMatrix transformMat = new ASMatrix(transformationMatrix[0], 0.0, 0.0, transformationMatrix[3], transformationMatrix[4], transformationMatrix[5]);
        ASCoordinate transformedOrigin = new ASCoordinate(0.0, 0.0).transform(transformMat);
        ASCoordinate transformedCoord = new ASCoordinate(1.0, 1.0).transform(transformMat);
        ASRectangle imageRect = null;
        try {
            imageRect = new ASRectangle(transformedOrigin, transformedCoord).normalized();
        }
        catch (PDFInvalidDocumentException e) {
            throw new RuntimeException(e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
        return new double[]{imageRect.left(), imageRect.bottom(), Math.abs(transformationMatrix[0]), Math.abs(transformationMatrix[3])};
    }
}

