/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.swf;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.graphicsDOM.AbstractContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItemsList;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentTextItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.Glyph;
import com.adobe.internal.pdftoolkit.graphicsDOM.GlyphOutlineGenerator;
import com.adobe.internal.pdftoolkit.graphicsDOM.PathPainting;
import com.adobe.internal.pdftoolkit.graphicsDOM.Type3Glyph;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.services.swf.SWFContentItem;
import com.adobe.internal.pdftoolkit.services.swf.SWFContentPathItem;
import com.adobe.internal.pdftoolkit.services.swf.SWFDocumentContext;
import com.adobe.internal.pdftoolkit.services.swf.SWFGlyphOutlineGenerator;
import com.adobe.internal.pdftoolkit.services.swf.SWFGraphicsState;
import com.adobe.internal.pdftoolkit.services.swf.SWFTextState;
import com.adobe.internal.pdftoolkit.services.swf.exceptions.SWFRuntimeException;
import com.adobe.internal.pdftoolkit.services.swf.utils.SWFUtils;
import com.adobe.internal.pdftoolkit.services.swf.utils.ShapeHelper;
import flash.swf.SwfUtils;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineFont3;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DefineText;
import flash.swf.tags.PlaceObject;
import flash.swf.types.GlyphEntry;
import flash.swf.types.Matrix;
import flash.swf.types.Rect;
import flash.swf.types.Shape;
import flash.swf.types.StyleChangeRecord;
import flash.swf.types.TextRecord;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

class SWFContentTextItem
extends ContentTextItem<SWFTextState, SWFGraphicsState>
implements SWFContentItem {
    private static final int MAX_SWF_TEXT_HEIGHT = 65535;
    private ArrayList<GlyphEntry> glyphsList = null;
    private HashMap<String, SWFDefineFont3> dFontsLoaded = null;
    private HashMap<String, ArrayList<Integer>> loadedFontChars = null;
    private ArrayList<Integer> charCodeList = null;
    private SWFDefineFont3 dFont = null;
    private DefineText dText = null;
    private TextRecord tRecord = null;
    private Font afeFont = null;
    private Matrix placeObjectMatrix = null;
    private int swfTextHeight = 0;
    private double textSpacingfactor = 1.0;

    SWFContentTextItem(SWFGraphicsState graphicsState, SWFTextState tState, int id) {
        super(graphicsState, tState, id);
    }

    private void initialize(SWFDocumentContext swfContext) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        int yScalingSign;
        this.dFontsLoaded = swfContext.getSWFFontsLoaded();
        this.loadedFontChars = swfContext.getLoadedSWFFontChars();
        this.charCodeList = this.loadedFontChars.get(((SWFTextState)this.getTState()).getFontName());
        this.dFont = this.dFontsLoaded.get(((SWFTextState)this.getTState()).getFontName());
        this.glyphsList = new ArrayList();
        this.dText = new DefineText(33);
        this.tRecord = new TextRecord();
        ASMatrix textMatrix = new ASMatrix(((SWFTextState)this.getTState()).getMatrix());
        double absXScalingFactor = Math.abs(textMatrix.geta());
        double absYScalingFactor = Math.abs(textMatrix.getd());
        if (absXScalingFactor < 1.0 || absYScalingFactor < 1.0) {
            this.textSpacingfactor = this.calculateTextSpacingFactor();
            if (this.textSpacingfactor < 0.001) {
                this.textSpacingfactor = 0.001;
            }
        }
        this.swfTextHeight = this.calculateHeight();
        this.placeObjectMatrix = new Matrix();
        double angle = Math.PI;
        ASMatrix mat2 = new ASMatrix(Math.cos(angle), Math.sin(angle), -1.0 * Math.sin(angle), Math.cos(angle), 0.0, 0.0);
        ASMatrix mat3 = new ASMatrix(1.0, -1.0 * (textMatrix.getb() / textMatrix.geta()), -1.0 * textMatrix.getc() / textMatrix.getd(), 1.0, 0.0, 0.0);
        ASMatrix mat4 = new ASMatrix(Math.cos(angle), Math.sin(angle), -1.0 * Math.sin(angle), Math.cos(angle), 0.0, 0.0);
        ASMatrix mat1 = null;
        int xScalingSign = textMatrix.geta() < 0.0 ? -1 : 1;
        int n = yScalingSign = textMatrix.getd() < 0.0 ? -1 : 1;
        if (this.shouldScalingBeConsidered(textMatrix)) {
            mat1 = new ASMatrix(xScalingSign, 0.0, 0.0, (double)yScalingSign * Math.abs(textMatrix.getd() / textMatrix.geta()), 0.0, 0.0);
            mat1 = mat1.concat(mat2).concat(mat3).concat(mat4);
        } else {
            mat1 = mat2.concat(mat3).concat(mat4);
        }
        ASMatrix mat5 = new ASMatrix(this.textSpacingfactor, 0.0, 0.0, this.textSpacingfactor, 0.0, 0.0);
        mat1 = mat1.concat(mat5);
        this.placeObjectMatrix.setScale(mat1.geta(), mat1.getd());
        this.placeObjectMatrix.setRotate(mat1.getb(), mat1.getc());
        SWFUtils.placeObject((DefineTag)this.dText, this.placeObjectMatrix, swfContext.getDefineSprite());
    }

    private double calculateTextSpacingFactor() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        ASMatrix textMatrix = new ASMatrix(((SWFTextState)this.getTState()).getMatrix());
        return Math.abs(((SWFTextState)this.getTState()).getFontSize() * textMatrix.geta() * 1024.0 * 20.0 / (65535.0 * this.afeFont.getUnitsPerEmY()));
    }

    private int calculateHeight() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        ASMatrix textMatrix = new ASMatrix(((SWFTextState)this.getTState()).getMatrix());
        double y = Math.abs(1.0 / this.textSpacingfactor * textMatrix.geta() * ((SWFTextState)this.getTState()).getFontSize());
        double h1 = y * 1024.0 / this.afeFont.getUnitsPerEmY();
        return SwfUtils.toTwips((double)h1);
    }

    @Override
    public void writeToDisplayArea(DocumentContext context) {
        if (this.isFontType3()) {
            this.writeSWFTextWithFontType3(context);
        } else {
            this.writeSWFText(context);
        }
    }

    private void writeSWFTextWithFontType3(DocumentContext context) {
        List<Glyph> text = this.getText();
        Iterator<Glyph> listItr = text.iterator();
        ContentItemsList contentItemsList = null;
        while (listItr.hasNext()) {
            contentItemsList = ((Type3Glyph)listItr.next()).getOutline();
            Iterator itr = contentItemsList.iterator();
            while (itr.hasNext()) {
                ((AbstractContentItem)itr.next()).writeToDisplayArea(context);
            }
        }
    }

    private boolean shouldScalingBeConsidered(ASMatrix textMatrix) {
        return textMatrix.geta() < 0.0 || textMatrix.getd() < 0.0 || textMatrix.geta() != textMatrix.getd();
    }

    private void writeSWFText(DocumentContext context) {
        super.writeToDisplayArea(context);
        try {
            this.afeFont = ((SWFTextState)this.getTState()).getFontMap().get(((SWFTextState)this.getTState()).getFontName());
            FontData fontData = null;
            if (this.afeFont == null || (fontData = ((FontImpl)this.afeFont).getFontData()) == null) {
                return;
            }
            ASMatrix textMatrix = new ASMatrix(((SWFTextState)this.getTState()).getMatrix());
            if (!this.shouldFillTextasCurves() && this.shouldFillText()) {
                this.initialize((SWFDocumentContext)context);
            }
            Glyph glyph = null;
            double prevX = 0.0;
            GlyphOutlineGenerator glyphOutlineGenerator = null;
            List<Glyph> text = this.getText();
            Iterator<Glyph> itr = text.iterator();
            while (itr.hasNext()) {
                glyphOutlineGenerator = null;
                glyph = itr.next();
                if (glyph.getGID() <= 0) continue;
                if (this.shouldFillTextasCurves()) {
                    glyphOutlineGenerator = new SWFGlyphOutlineGenerator(new ASMatrix(textMatrix.geta(), textMatrix.getb(), textMatrix.getc(), textMatrix.getd(), glyph.getXPos(), glyph.getYPos()));
                    fontData.getGlyphOutline(glyph.getGID(), glyphOutlineGenerator);
                    this.fillTextAsCurves(glyphOutlineGenerator.getOutline(), (SWFDocumentContext)context);
                } else if (this.shouldFillText()) {
                    if (this.dFont == null || !this.loadedFontChars.get(((SWFTextState)this.getTState()).getFontName()).contains(glyph.getCharCode())) {
                        glyphOutlineGenerator = new SWFGlyphOutlineGenerator(new ASMatrix(textMatrix.geta(), textMatrix.getb(), textMatrix.getc(), textMatrix.getd(), glyph.getXPos(), glyph.getYPos()));
                    }
                    prevX = this.fillTextAsText((SWFDocumentContext)context, (SWFGlyphOutlineGenerator)glyphOutlineGenerator, glyph, prevX);
                }
                if (!this.shouldStrokeTextAsCurves()) continue;
                if (glyphOutlineGenerator == null) {
                    glyphOutlineGenerator = new SWFGlyphOutlineGenerator(new ASMatrix(textMatrix.geta(), textMatrix.getb(), textMatrix.getc(), textMatrix.getd(), glyph.getXPos(), glyph.getYPos()));
                    fontData.getGlyphOutline(glyph.getGID(), glyphOutlineGenerator);
                }
                this.strokeTextAsCurves(glyphOutlineGenerator.getOutline(), (SWFDocumentContext)context);
            }
        }
        catch (FontLoadingException e) {
            throw new SWFRuntimeException(e);
        }
        catch (InvalidFontException e) {
            throw new SWFRuntimeException(e);
        }
        catch (UnsupportedFontException e) {
            throw new SWFRuntimeException(e);
        }
        finally {
            this.finalizeText((SWFDocumentContext)context);
        }
    }

    private void finalizeText(SWFDocumentContext writer) {
        if (this.glyphsList != null) {
            if (this.glyphsList.size() == 0 && !this.shouldFillTextasCurves() && !this.shouldStrokeTextAsCurves()) {
                List tags = writer.getDefineSprite().getDefineSprite().tagList.tags;
                if (tags != null && !tags.isEmpty() && ((PlaceObject)tags.get((int)(tags.size() - 1))).ref instanceof DefineText) {
                    tags.remove(tags.size() - 1);
                    --writer.getDefineSprite().getDefineSprite().depthCounter;
                }
            } else {
                Matrix matrix;
                this.tRecord.setFont((DefineFont)this.dFont);
                this.tRecord.entries = this.glyphsList.toArray(new GlyphEntry[this.glyphsList.size()]);
                this.tRecord.setColor(GraphicsUtils.toARGB(((SWFGraphicsState)this.getGState()).getFillColorValues(), ((SWFTextState)this.getTState()).getTextRenderingMode() == 3 ? 0.0 : ((SWFGraphicsState)this.getGState()).getNonStrokeAlpha()));
                this.dText.records.add(this.tRecord);
                this.dText.bounds = new Rect(0, 16000, 0, 16000);
                this.dText.matrix = matrix = new Matrix();
                matrix.hasRotate = false;
                matrix.hasScale = true;
                matrix.rotateSkew0 = 0;
                matrix.rotateSkew1 = 0;
                matrix.scaleX = 65536;
                matrix.scaleY = 65536;
                matrix.translateX = 0;
                matrix.translateY = 0;
            }
        }
    }

    private void strokeTextAsCurves(GeneralPath outline, SWFDocumentContext swfWriter) {
        SWFContentPathItem pathItem = new SWFContentPathItem((SWFGraphicsState)this.getGState(), this.getID());
        pathItem.setPath(outline, PathPainting.STROKE);
        pathItem.writeToDisplayArea(swfWriter);
    }

    private void fillTextAsCurves(GeneralPath outline, SWFDocumentContext swfWriter) {
        SWFContentPathItem pathItem = new SWFContentPathItem((SWFGraphicsState)this.getGState(), this.getID());
        pathItem.setPath(outline, PathPainting.FILL);
        pathItem.writeToDisplayArea(swfWriter);
    }

    private boolean shouldFillTextasCurves() {
        return this.shouldFillText() && ((SWFGraphicsState)this.getGState()).getFillTilingPatternName() != null;
    }

    private boolean shouldStrokeTextAsCurves() {
        return ((SWFTextState)this.getTState()).getTextRenderingMode() == 1 || ((SWFTextState)this.getTState()).getTextRenderingMode() == 2;
    }

    private boolean shouldFillText() {
        return ((SWFTextState)this.getTState()).getTextRenderingMode() != 1;
    }

    private double fillTextAsText(SWFDocumentContext swfContext, SWFGlyphOutlineGenerator glyphOutlineGenerator, Glyph glyph, double prevX) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        if (glyphOutlineGenerator != null) {
            ((FontImpl)this.afeFont).getFontData().getGlyphOutline(glyph.getGID(), glyphOutlineGenerator);
            Shape shape = new Shape();
            shape.shapeRecords = ShapeHelper.path(glyphOutlineGenerator.getOutlineString(), true);
            if (!shape.shapeRecords.isEmpty()) {
                ((StyleChangeRecord)shape.shapeRecords.get((int)0)).fillstyle0 = 1;
                ((StyleChangeRecord)shape.shapeRecords.get((int)0)).stateFillStyle0 = true;
            }
            if (this.dFont == null) {
                this.dFont = new SWFDefineFont3();
                this.dFont.name = ((SWFTextState)this.getTState()).getFontName();
                this.dFont.fontName = ((SWFTextState)this.getTState()).getFontName();
                this.dFontsLoaded.put(((SWFTextState)this.getTState()).getFontName(), this.dFont);
                this.dFont.glyphShapeTable = new ArrayList<Shape>();
                this.dFont.codeTable = new ArrayList<Character>();
                this.charCodeList = new ArrayList();
                this.loadedFontChars.put(((SWFTextState)this.getTState()).getFontName(), this.charCodeList);
            }
            this.charCodeList.add(glyph.getCharCode());
            this.dFont.glyphShapeTable.add(shape);
            this.dFont.codeTable.add(Character.valueOf((char)glyph.getCharCode()));
        }
        GlyphEntry gEntry = new GlyphEntry();
        gEntry.setIndex(this.charCodeList.indexOf(glyph.getCharCode()));
        if (!this.glyphsList.isEmpty()) {
            this.glyphsList.get((int)(this.glyphsList.size() - 1)).advance = (int)Math.rint(1.0 / this.textSpacingfactor * Math.abs(SWFUtils.toTwips(glyph.getXPos() - prevX)));
        }
        this.glyphsList.add(gEntry);
        ASMatrix textMatrix = new ASMatrix(((SWFTextState)this.getTState()).getMatrix());
        prevX = glyph.getXPos();
        if (this.glyphsList.size() == 1) {
            this.tRecord.setHeight(this.swfTextHeight);
            this.tRecord.setX(SwfUtils.toTwips((double)glyph.getXPos()));
            this.tRecord.setY(SwfUtils.toTwips((double)(swfContext.getPageHeight() - glyph.getYPos())));
            ASCoordinate point = new ASCoordinate(glyph.getXPos(), swfContext.getPageHeight() - glyph.getYPos());
            int xScalingSign = textMatrix.geta() < 0.0 ? -1 : 1;
            int yScalingSign = textMatrix.getd() < 0.0 ? -1 : 1;
            ASMatrix transformationMatrix = new ASMatrix((double)xScalingSign * this.textSpacingfactor, 0.0, 0.0, this.textSpacingfactor * (double)yScalingSign * Math.abs(textMatrix.getd() / textMatrix.geta()), 0.0, 0.0);
            ASCoordinate transformedPoint = point.transform(transformationMatrix);
            this.placeObjectMatrix.translateX += SwfUtils.toTwips((double)(point.x() - transformedPoint.x()));
            this.placeObjectMatrix.translateY += SwfUtils.toTwips((double)(point.y() - transformedPoint.y()));
            transformationMatrix = new ASMatrix(1.0, this.textSpacingfactor * 1.0 * textMatrix.getb() / Math.abs(textMatrix.geta()), this.textSpacingfactor * textMatrix.getc() / Math.abs(textMatrix.geta()), 1.0, 0.0, 0.0);
            transformedPoint = point.transform(transformationMatrix);
            this.placeObjectMatrix.translateX += SwfUtils.toTwips((double)(transformedPoint.x() - point.x()));
            this.placeObjectMatrix.translateY += SwfUtils.toTwips((double)(transformedPoint.y() - point.y()));
        }
        return prevX;
    }

    class SWFDefineFont3
    extends DefineFont3 {
        List<Shape> glyphShapeTable;
        List<Character> codeTable;

        SWFDefineFont3() {
        }
    }
}

