/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.security;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class UnicodePasswordUtil {
    private static boolean isAGLAvailable = true;
    private static Method saslPrep;
    private static Class UnicodePasswordUtilHelper;
    private Object unicodePasswordUtilHelperInstance;

    public UnicodePasswordUtil() {
        if (isAGLAvailable) {
            try {
                this.unicodePasswordUtilHelperInstance = UnicodePasswordUtilHelper.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Error while creating UnicodePasswordUtil", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error while creating UnicodePasswordUtil", e);
            }
        }
    }

    public byte[] getPasswordFromUnicode(String inPassword) {
        String toUCS = inPassword;
        if (isAGLAvailable) {
            try {
                toUCS = (String)saslPrep.invoke(this.unicodePasswordUtilHelperInstance, inPassword);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Error while getting unicode string", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error while getting unicode string", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error while getting unicode string", e);
            }
        }
        byte[] outPassword = null;
        try {
            outPassword = toUCS.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error while getting UTF-8 bytes for a string", e);
        }
        return outPassword;
    }

    static {
        try {
            Class.forName("com.adobe.agl.text.Normalizer");
        }
        catch (ClassNotFoundException e) {
            isAGLAvailable = false;
        }
        if (isAGLAvailable) {
            try {
                UnicodePasswordUtilHelper = Class.forName("com.adobe.internal.pdftoolkit.services.security.UnicodePasswordUtilHelper");
                saslPrep = UnicodePasswordUtilHelper.getDeclaredMethod("saslPrep", String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

