/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.sanitization.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCharProcs;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternTiling;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.ContentStreamSanitizer;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.PDFOptimizer;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.SanitizationContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ResourceSanitizer {
    ResourceSanitizer() {
    }

    static void sanitize(PDFResources resources, SanitizationContext context, Set<Integer> sanitizedResources, PDFPage pdfPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        if (resources == null) {
            return;
        }
        ResourceSanitizer.sanitizeXObjects(resources, context, sanitizedResources, pdfPage);
        ResourceSanitizer.sanitizePatterns(resources, context, sanitizedResources, pdfPage);
        ResourceSanitizer.sanitizeFonts(resources, context, sanitizedResources, pdfPage);
        resources.getCosDictionary().remove(ASName.create("CSML:PProtB"));
    }

    private static void sanitizeXObjects(PDFResources resources, SanitizationContext context, Set<Integer> sanitizedResources, PDFPage pdfPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        PDFXObjectMap xObjectMap = resources.getXObjectMap();
        if (xObjectMap != null) {
            Collection xObjects = xObjectMap.values();
            Iterator xObjectsItr = xObjects.iterator();
            PDFXObject xObject = null;
            while (xObjectsItr.hasNext()) {
                xObject = (PDFXObject)xObjectsItr.next();
                if (ResourceSanitizer.alreadyProcessed(xObject, sanitizedResources)) continue;
                PDFOptimizer.doXObjectOptimization(xObject);
                if (!(xObject instanceof PDFXObjectForm)) continue;
                PDFResources xObjectresources = ((PDFXObjectForm)xObject).getResources();
                ResourceSanitizer.sanitize(xObjectresources, context, sanitizedResources, pdfPage);
                PDFContents newContents = ContentStreamSanitizer.sanitize(((PDFXObjectForm)xObject).getContents(), null, xObjectresources == null ? pdfPage.getResources() : xObjectresources, context, pdfPage);
                ((PDFXObjectForm)xObject).setContents(newContents);
            }
        }
    }

    private static void sanitizePatterns(PDFResources resources, SanitizationContext context, Set<Integer> sanitizedResources, PDFPage pdfPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        PDFPatternMap patternsMap = resources.getPatternMap();
        if (patternsMap != null) {
            Collection patterns = patternsMap.values();
            Iterator patternsItr = patterns.iterator();
            PDFPattern pattern = null;
            while (patternsItr.hasNext()) {
                pattern = (PDFPattern)patternsItr.next();
                if (pattern == null || ResourceSanitizer.alreadyProcessed(pattern.getPDFCosObject(), sanitizedResources) || pattern.getPatternType() != 1) continue;
                PDFResources patternResources = ((PDFPatternTiling)pattern).getResources();
                ResourceSanitizer.sanitize(patternResources, context, sanitizedResources, pdfPage);
                PDFContents newContents = ContentStreamSanitizer.sanitize(((PDFPatternTiling)pattern).getContents(), null, patternResources, context, pdfPage);
                ((PDFPatternTiling)pattern).setContents(newContents);
            }
        }
    }

    private static void sanitizeFonts(PDFResources resources, SanitizationContext context, Set<Integer> sanitizedResources, PDFPage pdfPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        PDFFontMap fontsMap = resources.getFontMap();
        if (fontsMap != null) {
            Collection fonts = fontsMap.values();
            Iterator fontsItr = fonts.iterator();
            PDFFont font = null;
            while (fontsItr.hasNext()) {
                font = (PDFFont)fontsItr.next();
                if (ResourceSanitizer.alreadyProcessed(font, sanitizedResources) || !(font instanceof PDFFontType3)) continue;
                PDFResources fontResources = ((PDFFontType3)font).getResources();
                ResourceSanitizer.sanitize(fontResources, context, sanitizedResources, pdfPage);
                PDFResources pDFResources = fontResources = fontResources == null ? pdfPage.getResources() : fontResources;
                PDFCharProcs charProcs = ((PDFFontType3)font).getCharProcs();
                if (charProcs == null) continue;
                Set glyphSet = charProcs.entrySet();
                Iterator itr = glyphSet.iterator();
                ASName key = null;
                PDFContents glyphContents = null;
                Map.Entry entry = null;
                while (itr.hasNext()) {
                    entry = (Map.Entry)itr.next();
                    key = (ASName)entry.getKey();
                    glyphContents = (PDFContents)entry.getValue();
                    PDFContents newContents = ContentStreamSanitizer.sanitize(glyphContents, null, fontResources, context, pdfPage);
                    charProcs.set(key, newContents);
                }
            }
        }
    }

    private static boolean alreadyProcessed(PDFCosObject resource, Set<Integer> sanitizedResources) {
        if (resource == null) {
            return true;
        }
        if (sanitizedResources.contains(resource.getCosObject().getObjNum())) {
            return true;
        }
        sanitizedResources.add(resource.getCosObject().getObjNum());
        return false;
    }
}

