/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.sanitization.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosContainerValuesIterator;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.traverser.GeneralDispatcher;
import com.adobe.internal.pdftoolkit.core.traverser.GeneralTraverser;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.PDFOptimizer;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.SanitizationContext;
import com.adobe.internal.util.ArrayListStack;

public class CosObjectsSanitizer {
    private CosObjectsSanitizer() {
    }

    public static void sanitize(PDFDocument pdfDoc, SanitizationContext context) throws PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException, PDFInvalidDocumentException {
        SanitizationDispatcher dispatcher = new SanitizationDispatcher();
        GeneralTraverser traverser = new GeneralTraverser(dispatcher);
        traverser.traverseCosGraph(pdfDoc.requireCatalog().getCosDictionary(), null);
    }

    private static class SanitizationDispatcher
    implements GeneralDispatcher {
        private SanitizationDispatcher() {
        }

        @Override
        public boolean isCandidate(CosContainerValuesIterator.Entry entry, ArrayListStack visitorStack, boolean wasSeen) {
            return !wasSeen;
        }

        @Override
        public boolean startDispatch(CosContainerValuesIterator.Entry entry, ArrayListStack visitorStack, boolean wasSeen) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFOptimizer.doCosLevelOptimization(entry.getValue());
            return true;
        }

        @Override
        public boolean finishDispatch(CosContainerValuesIterator.Entry entry, ArrayListStack visitorStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
            return true;
        }

        @Override
        public boolean continueTraversing(PDFInvalidDocumentException exceptionOccured) {
            throw new PDFRuntimeException("Exception occured while traversing cos objects.", exceptionOccured);
        }
    }
}

