/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.sanitization.impl;

import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import java.util.List;

class Bezier2D {
    private static final int maxIter = 100;
    private static final double DBL_MAX = Double.MAX_VALUE;
    private static final double round = Math.PI * 2;
    private ASCoordinate[] P = new ASCoordinate[4];
    private boolean needReval;
    private ASCoordinate A;
    private ASCoordinate B;
    private ASCoordinate C;
    private ASCoordinate D;
    private double maxTangErr;

    Bezier2D() {
    }

    private double paramPoints(int ks, int ke, double[] t, List<ASCoordinate> Q) {
        t[0] = 0.0;
        int dk = ke - ks;
        for (int i = 1; i <= dk; ++i) {
            t[i] = t[i - 1] + Q.get(i + ks).distanceTo(Q.get(i + ks - 1));
        }
        double S = t[dk] - t[0];
        int i = 1;
        while (i <= dk) {
            int n = i++;
            t[n] = t[n] / S;
        }
        return S;
    }

    double fit(int ks, int ke, List<ASCoordinate> Q, double fittingErr, double posErr) {
        this.P[0] = Q.get(ks);
        this.P[3] = Q.get(ke);
        int dk = ke - ks;
        double[] t = new double[dk + 1];
        this.paramPoints(ks, ke, t, Q);
        double maxErr = Double.MAX_VALUE;
        double oldErr = Double.MAX_VALUE;
        double errorRate = fittingErr / 100.0;
        double[][] A = new double[][]{{0.0}, {0.0}};
        double[][] B = new double[][]{{0.0}, {0.0}};
        double[][] M = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
        double[][] x = new double[][]{{0.0}, {0.0}};
        double[][] y = new double[][]{{0.0}, {0.0}};
        double[][] N = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
        for (int j = 0; j < 100; ++j) {
            A[0][0] = 0.0;
            A[1][0] = 0.0;
            B[0][0] = 0.0;
            B[1][0] = 0.0;
            M[0][0] = 0.0;
            M[1][0] = 0.0;
            M[0][1] = 0.0;
            M[1][1] = 0.0;
            for (int i = 0; i <= dk; ++i) {
                double s = 1.0 - t[i];
                double u = t[i];
                double s2 = s * s;
                double u2 = u * u;
                ASCoordinate X = new ASCoordinate(s2 * s * this.P[0].x() + u2 * u * this.P[3].x() - Q.get(ks + i).x(), s2 * s * this.P[0].y() + u2 * u * this.P[3].y() - Q.get(ks + i).y());
                double[] dArray = M[0];
                dArray[0] = dArray[0] + 3.0 * (s2 * s2) * u2;
                double[] dArray2 = M[0];
                dArray2[1] = dArray2[1] + 3.0 * (s * s2) * (u * u2);
                double[] dArray3 = M[1];
                dArray3[0] = dArray3[0] + 3.0 * (s * s2) * (u * u2);
                double[] dArray4 = M[1];
                dArray4[1] = dArray4[1] + 3.0 * s2 * (u2 * u2);
                double[] dArray5 = A[0];
                dArray5[0] = dArray5[0] + -s2 * u * X.x();
                double[] dArray6 = A[1];
                dArray6[0] = dArray6[0] + -s * u2 * X.x();
                double[] dArray7 = B[0];
                dArray7[0] = dArray7[0] + -s2 * u * X.y();
                double[] dArray8 = B[1];
                dArray8[0] = dArray8[0] + -s * u2 * X.y();
            }
            double det = M[0][0] * M[1][1] - M[1][0] * M[0][1];
            if (det == 0.0) {
                maxErr = Double.MAX_VALUE;
                break;
            }
            x[0][0] = 0.0;
            x[1][0] = 0.0;
            y[0][0] = 0.0;
            y[1][0] = 0.0;
            N[0][0] = 0.0;
            N[1][0] = 0.0;
            N[0][1] = 0.0;
            N[1][1] = 0.0;
            N[0][0] = M[1][1] / det;
            N[0][1] = -M[1][0] / det;
            N[1][0] = -M[0][1] / det;
            N[1][1] = M[0][0] / det;
            x[0][0] = N[0][0] * A[0][0] + N[0][1] * A[1][0];
            x[1][0] = N[1][0] * A[0][0] + N[1][1] * A[1][0];
            y[0][0] = N[0][0] * B[0][0] + N[0][1] * B[1][0];
            y[1][0] = N[1][0] * B[0][0] + N[1][1] * B[1][0];
            this.P[1] = new ASCoordinate(x[0][0], y[0][0]);
            this.P[2] = new ASCoordinate(x[1][0], y[1][0]);
            this.needReval = true;
            maxErr = this.maxDeviation(ks, ke, Q, t);
            if (maxErr > oldErr || maxErr > fittingErr && oldErr - maxErr <= errorRate) break;
            oldErr = maxErr;
            if (!this.reParam(ks, ke, Q, t)) break;
        }
        if ((maxErr = (double)((long)(maxErr * 100.0)) / 100.0) <= fittingErr) {
            this.estimateAngularError(ks, ke, Q, t);
        }
        return maxErr;
    }

    private double maxDeviation(int ks, int ke, List<ASCoordinate> Q, double[] t) {
        double d = -1.7976931348623157E308;
        int dk = ke - ks;
        double averageTLen2 = 2.0 / (double)(dk + 1);
        for (int i = 0; i <= dk; ++i) {
            ASCoordinate p = this.getPointAt(t[i]);
            double d1 = p.distanceToSquare(Q.get(ks + i));
            d = Math.max(d, d1);
            if (i >= dk || !(t[i + 1] > t[i] + averageTLen2)) continue;
            p = this.getPointAt((t[i] + t[i + 1]) / 2.0);
            double d12 = Bezier2D.LineToPointSquaredDistance(Q.get(ks + i), Q.get(ks + i + 1), p);
            d = Math.max(d, d12);
        }
        return Math.sqrt(d);
    }

    private boolean reParam(int ks, int ke, List<ASCoordinate> Q, double[] t) {
        this.reval();
        double[] p = new double[6];
        p[5] = -Bezier2D.dotProduct(this.D, this.D);
        p[4] = 5.0 * Bezier2D.dotProduct(this.C, this.D) / 3.0;
        p[3] = -4.0 * Bezier2D.dotProduct(this.B, this.D) / 3.0 - 6.0 * Bezier2D.dotProduct(this.C, this.C) / 9.0;
        for (int i = 1; i < t.length - 1; ++i) {
            ASCoordinate E = new ASCoordinate(this.A.x() - Q.get(i + ks).x(), this.A.y() - Q.get(i + ks).y());
            p[2] = Bezier2D.dotProduct(this.B, this.C) + Bezier2D.dotProduct(this.D, E);
            p[1] = -2.0 * Bezier2D.dotProduct(this.C, E) / 3.0 - Bezier2D.dotProduct(this.B, this.B) / 3.0;
            p[0] = Bezier2D.dotProduct(this.B, E) / 3.0;
            double U = t[i];
            for (int j = 0; j < 20; ++j) {
                double e = p[0];
                double s = 0.0;
                double t1 = 1.0;
                for (int k = 1; k < 6; ++k) {
                    double a = p[k] * (t1 *= U);
                    e += a;
                    s += (double)k * a;
                }
                double d = e * U / s;
                U -= d;
                if (d >= -1.0E-7 && d <= 1.0E-7) break;
            }
            t[i] = U;
            if (!(t[i] < 0.0) && !(t[i] > 1.0)) continue;
            return false;
        }
        return true;
    }

    private void reval() {
        if (this.needReval) {
            this.A = this.P[0];
            this.B = new ASCoordinate(3.0 * (this.P[0].x() - this.P[1].x()), 3.0 * (this.P[0].y() - this.P[1].y()));
            this.C = new ASCoordinate(3.0 * (this.P[0].x() - this.P[1].x() - (this.P[1].x() - this.P[2].x())), 3.0 * (this.P[0].y() - this.P[1].y() - (this.P[1].y() - this.P[2].y())));
            this.D = new ASCoordinate(this.P[0].x() - this.P[1].x() - 2.0 * (this.P[1].x() - this.P[2].x()) + (this.P[2].x() - this.P[3].x()), this.P[0].y() - this.P[1].y() - 2.0 * (this.P[1].y() - this.P[2].y()) + (this.P[2].y() - this.P[3].y()));
            this.needReval = false;
        }
    }

    private double estimateAngularError(int ks, int ke, List<ASCoordinate> Q, double[] t) {
        this.maxTangErr = 0.0;
        double theta2 = Math.atan2(Q.get(ks + 1).y() - Q.get(ks).y(), Q.get(ks + 1).x() - Q.get(ks).x());
        this.normalizeAngle(theta2);
        double theta1 = this.slopeAngle(t[0]);
        this.normalizeAngle(theta1);
        double dt = Math.acos(Math.cos(theta2 - theta1));
        this.maxTangErr = Math.max(this.maxTangErr, dt);
        for (int i = ks + 1; i < ke; ++i) {
            theta2 = Math.atan2(Q.get(i + 1).y() - Q.get(i - 1).y(), Q.get(i + 1).x() - Q.get(i - 1).x());
            this.normalizeAngle(theta2);
            theta1 = this.slopeAngle(t[i - ks]);
            this.normalizeAngle(theta1);
            dt = Math.acos(Math.cos(theta2 - theta1));
            this.maxTangErr = Math.max(this.maxTangErr, dt);
        }
        theta2 = Math.atan2(Q.get(ke).y() - Q.get(ke - 1).y(), Q.get(ke).x() - Q.get(ke - 1).x());
        this.normalizeAngle(theta2);
        theta1 = this.slopeAngle(t[ke - ks]);
        this.normalizeAngle(theta1);
        dt = Math.acos(Math.cos(theta2 - theta1));
        this.maxTangErr = Math.max(this.maxTangErr, dt);
        return this.maxTangErr;
    }

    private double slopeAngle(double t) {
        this.reval();
        double x = -this.B.x() + 2.0 * t * this.C.x() - 3.0 * t * t * this.D.x();
        double y = -this.B.y() + 2.0 * t * this.C.y() - 3.0 * t * t * this.D.y();
        return Math.atan2(y, x);
    }

    private double normalizeAngle(double theta) {
        while (theta < 0.0) {
            theta += Math.PI * 2;
        }
        while (theta > Math.PI * 2) {
            theta -= Math.PI * 2;
        }
        return theta;
    }

    private ASCoordinate getPointAt(double t) {
        this.reval();
        return new ASCoordinate(this.A.x() - t * this.B.x() + t * t * this.C.x() - t * t * t * this.D.x(), this.A.y() - t * this.B.y() + t * t * this.C.y() - t * t * t * this.D.y());
    }

    private static double LineToPointSquaredDistance(ASCoordinate startLinePoint, ASCoordinate endLinePoint, ASCoordinate p) {
        double h1 = startLinePoint.distanceTo(p);
        double h2 = endLinePoint.distanceTo(p);
        double b = startLinePoint.distanceTo(endLinePoint);
        double s = (h1 + h2 + b) / 2.0;
        double A2 = s * (s - h1) * (s - h2) * (s - b);
        return 4.0 * A2 / (b * b);
    }

    private static double dotProduct(ASCoordinate p1, ASCoordinate p2) {
        return p1.x() * p2.x() + p1.y() * p2.y();
    }

    double angularError() {
        return this.maxTangErr;
    }

    ASCoordinate getControlPoint(int index) {
        return this.P[index];
    }
}

