/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.redaction;

import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveFullOptions;
import com.adobe.internal.pdftoolkit.services.redaction.RedactionOptions;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionProcessor;

public class RedactionService {
    public static void applyRedaction(PDFDocument pdfDoc, RedactionOptions redactionOptions, ByteWriter writer) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFFontException {
        if (pdfDoc == null) {
            throw new PDFInvalidParameterException("PDF Document must be specified");
        }
        if (writer == null) {
            throw new PDFInvalidParameterException("A writer must be specified for saving the redacted document");
        }
        if (redactionOptions == null) {
            redactionOptions = new RedactionOptions(null);
        }
        RedactionProcessor redactionImpl = new RedactionProcessor(pdfDoc, redactionOptions);
        redactionImpl.redactDocument();
        pdfDoc.save(writer, PDFSaveFullOptions.newInstance());
    }
}

