/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rcg;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.services.rcg.RCGAlignment;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOverflowMode;
import com.adobe.internal.pdftoolkit.services.rcg.RCGTargetRegion;
import com.adobe.internal.pdftoolkit.services.rcg.RCGWrapOption;

public class RCGOptions {
    private RCGTargetRegion targetRegion;
    private String defaultStyle;

    public RCGOptions(double width, double height) {
        this.targetRegion = new RCGTargetRegion(width, height);
        this.defaultStyle = "";
    }

    public void setWrap(RCGWrapOption wrap) {
        this.targetRegion.setWrap(wrap);
    }

    public void setOverflow(RCGOverflowMode overflow) {
        this.targetRegion.setOverflow(overflow);
    }

    public void setVerticalAlignment(RCGAlignment alignment) {
        this.targetRegion.setVerticalAlignment(alignment);
    }

    public void setPaddingAll(double padding) throws PDFInvalidParameterException {
        this.targetRegion.setPaddingAll(padding);
    }

    public void setPaddingLeft(double padding) throws PDFInvalidParameterException {
        this.targetRegion.setPaddingLeft(padding);
    }

    public void setPaddingRight(double padding) throws PDFInvalidParameterException {
        this.targetRegion.setPaddingRight(padding);
    }

    public void setPaddingTop(double padding) throws PDFInvalidParameterException {
        this.targetRegion.setPaddingTop(padding);
    }

    public void setPaddingBottom(double padding) throws PDFInvalidParameterException {
        this.targetRegion.setPaddingBottom(padding);
    }

    public void setAdjustmentBelowBaselineFactor(double scale) throws PDFInvalidParameterException {
        this.targetRegion.setAdjustmentBelowBaselineFactor(scale);
    }

    public double getAdjustmentBelowBaselineFactor() {
        return this.targetRegion.getAdjustmentBelowBaselineFactor();
    }

    public void setDefaultStyle(String defaultStyle) {
        if (defaultStyle == null) {
            defaultStyle = "";
        }
        this.defaultStyle = defaultStyle;
    }

    public RCGTargetRegion getTargetRegion() {
        return this.targetRegion;
    }

    public String getDefaultStyle() {
        return this.defaultStyle;
    }

    public double getWidth() {
        return this.targetRegion.getWidth();
    }

    public double getHeight() {
        return this.targetRegion.getHeight();
    }

    public double getPaddingTop() {
        return this.targetRegion.getPaddingTop();
    }

    public double getPaddingBottom() {
        return this.targetRegion.getPaddingBottom();
    }

    public double getPaddingLeft() {
        return this.targetRegion.getPaddingLeft();
    }

    public double getPaddingRight() {
        return this.targetRegion.getPaddingRight();
    }

    public RCGAlignment getVerticalAlignment() {
        return this.targetRegion.getVert_alignment();
    }

    public RCGOverflowMode getOverflowMode() {
        return this.targetRegion.getOverflow();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultStyle == null ? 0 : this.defaultStyle.hashCode());
        result = 31 * result + (this.targetRegion == null ? 0 : this.targetRegion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RCGOptions)) {
            return false;
        }
        RCGOptions other = (RCGOptions)obj;
        if (this.defaultStyle == null ? other.defaultStyle != null : !this.defaultStyle.equals(other.defaultStyle)) {
            return false;
        }
        return !(this.targetRegion == null ? other.targetRegion != null : !this.targetRegion.equals(other.targetRegion));
    }
}

