/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.permissions;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.ObjectOperations;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProvider;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.permissions.impl.PermissionsManagerImpl;
import java.util.List;

public class PermissionsManager {
    private PermissionsManagerImpl m_PermissionsManagerImpl;

    private PermissionsManager(PDFDocument doc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFInvalidXMLException, PDFInvalidParameterException {
        this.m_PermissionsManagerImpl = new PermissionsManagerImpl(doc);
        this.m_PermissionsManagerImpl.registerAll();
    }

    private PermissionsManager(PDFDocument doc, String[] providers) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFInvalidXMLException, PDFInvalidParameterException {
        this.m_PermissionsManagerImpl = new PermissionsManagerImpl(doc);
        for (int i = 0; i < providers.length; ++i) {
            this.m_PermissionsManagerImpl.enablePermissionProvider(providers[i]);
        }
    }

    public static PermissionsManager newInstance(PDFDocument doc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFInvalidXMLException, PDFInvalidParameterException {
        return new PermissionsManager(doc);
    }

    public static PermissionsManager newInstance(PDFDocument doc, String[] providers) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFInvalidXMLException, PDFInvalidParameterException {
        return new PermissionsManager(doc, providers);
    }

    public boolean isPermitted(ObjectOperations objOpr) throws PDFUnableToCompleteOperationException {
        return this.m_PermissionsManagerImpl.isPermitted(objOpr);
    }

    public List<PermissionProvider> getDenyingHandlers(ObjectOperations objOpr) throws PDFUnableToCompleteOperationException {
        return this.m_PermissionsManagerImpl.getDenyingHandlers(objOpr);
    }

    public PermissionProvider getPermissionProvider(String name) throws PDFInvalidParameterException {
        return this.m_PermissionsManagerImpl.getPermissionProvider(name);
    }

    public boolean enablePermissionProvider(String name) throws PDFInvalidParameterException {
        return this.m_PermissionsManagerImpl.enablePermissionProvider(name);
    }

    public boolean disablePermissionProvider(String name) throws PDFInvalidParameterException {
        return this.m_PermissionsManagerImpl.disablePermissionProvider(name);
    }
}

