/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfport.impl;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.agm.AGMGState;
import com.adobe.internal.agm.AGMGlyphDescription;
import com.adobe.internal.agm.AGMText;
import com.adobe.internal.pdftoolkit.core.cos.CosToken;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFType0FontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.services.fontresources.FontResources;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFCompositeFontBuilder;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFFontBuilder;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFFontListener;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFSimpleFontBuilder;
import com.adobe.internal.pdftoolkit.services.pdfport.impl.ContentGenerationParams;
import com.adobe.internal.pdftoolkit.services.pdfport.impl.PDFPortGState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PDFPortShowText {
    private Map<Font, Integer> font2Index;
    private Map<ASName, Font> fontKeyName2Font;
    private Map<Font, Subset> font2FontSubset;
    private Map<PDFFont, TreeMap<Integer, byte[]>> fontUnicodeMapping;
    private AFEtoPDFFontCache afeToPdfFontCache;
    private PDFPortGState portGState;
    private boolean documentHasPDFAMarker;
    private boolean doNotEmbedFonts = false;

    public PDFPortShowText(PDFPortGState pdfPortGState, Map<Font, PDFFont> afe2pdfmap, PDFDocument pdfDocument) {
        this.font2Index = new HashMap<Font, Integer>();
        this.fontKeyName2Font = new HashMap<ASName, Font>();
        this.font2FontSubset = new HashMap<Font, Subset>();
        this.afeToPdfFontCache = new AFEtoPDFFontCache();
        this.portGState = pdfPortGState;
        this.fontUnicodeMapping = new HashMap<PDFFont, TreeMap<Integer, byte[]>>();
        if (afe2pdfmap != null) {
            this.populateFontCache(afe2pdfmap);
        }
        if (pdfDocument != null) {
            this.doNotEmbedFonts = pdfDocument.getCosDocument().getOptions().getDoNotEmbedFonts();
            this.documentHasPDFAMarker = pdfDocument.documentHasPDFAMarker(pdfDocument);
        }
    }

    PDFPortShowText(PDFPortShowText portShowText) {
        this.font2Index = portShowText.font2Index;
        this.fontKeyName2Font = portShowText.fontKeyName2Font;
        this.font2FontSubset = portShowText.font2FontSubset;
        this.afeToPdfFontCache = portShowText.afeToPdfFontCache;
        this.portGState = portShowText.portGState;
        this.fontUnicodeMapping = portShowText.fontUnicodeMapping;
        this.documentHasPDFAMarker = portShowText.documentHasPDFAMarker;
        this.doNotEmbedFonts = portShowText.doNotEmbedFonts;
    }

    private void populateFontCache(Map<Font, PDFFont> afe2pdfmap) {
        if (afe2pdfmap != null) {
            for (Map.Entry<Font, PDFFont> entry : afe2pdfmap.entrySet()) {
                Font afeFont = entry.getKey();
                PDFFont pdfFont = entry.getValue();
                this.afeToPdfFontCache.add(afeFont, pdfFont);
            }
        }
    }

    public void finalizeFonts(PDFResources resources) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException {
        PDFFontListener fontListener = PDFFontListener.getFontListener(resources.getPDFDocument());
        PDFFontMap resourceFontMap = resources.getFontMap();
        if (resourceFontMap != null) {
            for (Map.Entry curEntry : resourceFontMap.entrySet()) {
                ASName fontKeyName = (ASName)curEntry.getKey();
                PDFFont pdfFont = (PDFFont)curEntry.getValue();
                try {
                    Font font;
                    if (pdfFont instanceof PDFFontType0) {
                        Subset fontSubset;
                        font = this.fontKeyName2Font.get(fontKeyName);
                        if (fontListener != null) {
                            fontListener.addToFontCache(font, this.fontUnicodeMapping.get(pdfFont));
                            continue;
                        }
                        if (font == null || (fontSubset = this.font2FontSubset.get(font)) == null) continue;
                        FontResources.embedFont((PDFFontType0)pdfFont, font, fontSubset, this.fontUnicodeMapping.get(pdfFont));
                        continue;
                    }
                    if (FontResources.isToUnicodeCmapRequired(pdfFont)) {
                        FontResources.createToUnicodeCMap(pdfFont, this.fontUnicodeMapping.get(pdfFont));
                    }
                    if ((font = this.fontKeyName2Font.get(fontKeyName)) == null || font.getPDFFontDescription().getBase14Name() == null) continue;
                    ((PDFFontSimple)pdfFont).removeWidths();
                    ((PDFFontSimple)pdfFont).removeFirstChar();
                    ((PDFFontSimple)pdfFont).removeLastChar();
                }
                catch (UnsupportedFontException e) {
                    throw new PDFUnsupportedFeatureException("Attempt to use unsupported font.", e);
                }
                catch (InvalidFontException e) {
                    throw new PDFFontException("Invalid Font in the Font Set.", e);
                }
                catch (FontLoadingException e) {
                    throw new PDFFontException("Font loading failed.", e);
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFIOException("PDFInvalidParameterException while finalizing fonts.", e);
                }
            }
        }
        this.font2Index.clear();
        this.fontKeyName2Font.clear();
        this.font2FontSubset.clear();
        this.fontUnicodeMapping.clear();
    }

    private static String getPaddedHexString(String hex) {
        int length = hex.length();
        if (length == 1) {
            return "000" + hex;
        }
        if (length == 2) {
            return "00" + hex;
        }
        if (length == 3) {
            return "0" + hex;
        }
        return hex;
    }

    private byte[] mergehexStringToByteArray(String hexStr, byte[] initArray) throws PDFParseException {
        byte[] strBytes = hexStr.getBytes();
        byte[] hexBytes = new byte[strBytes.length / 2 + (initArray == null ? 0 : initArray.length)];
        int index = 0;
        if (initArray != null) {
            index = initArray.length;
            System.arraycopy(initArray, 0, hexBytes, 0, initArray.length);
        }
        for (int i = 0; i < strBytes.length; i += 2) {
            byte l;
            byte h;
            try {
                h = CosToken.toHexDigit(strBytes[i]);
                l = CosToken.toHexDigit(strBytes[i + 1]);
            }
            catch (PDFCosParseException e) {
                throw new PDFParseException(e);
            }
            hexBytes[index++] = (byte)(h * 16 + l);
        }
        return hexBytes;
    }

    private void updateFontNameCache(ASName fontKeyName, Font afeFont) {
        Font existingFontObj = this.fontKeyName2Font.get(fontKeyName);
        if (existingFontObj != null && !existingFontObj.equals(afeFont)) {
            throw new RuntimeException("Expected Font was not available.");
        }
        this.fontKeyName2Font.put(fontKeyName, afeFont);
    }

    private ASName createAndCacheFontName(Font afeFont, int whichOfMultipleSimpleFonts) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        Integer fontIndex = this.font2Index.get(afeFont);
        ASName pdfFontName = whichOfMultipleSimpleFonts != -1 ? ASName.create("F" + fontIndex + "_" + whichOfMultipleSimpleFonts) : ASName.create("F" + fontIndex);
        this.updateFontNameCache(pdfFontName, afeFont);
        return pdfFontName;
    }

    private void createFontIndex(Font afeFont, PDFFontMap resourceFontMap) throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException {
        if (!this.font2Index.containsKey(afeFont)) {
            boolean uniquePrefix;
            int index = this.font2Index.size() - 1;
            Set<ASName> existingKeys = resourceFontMap.keySet();
            block0: do {
                uniquePrefix = true;
                String keyNamePrefix = "F" + ++index;
                for (ASName key : existingKeys) {
                    if (!key.asString().startsWith(keyNamePrefix)) continue;
                    uniquePrefix = false;
                    continue block0;
                }
            } while (!uniquePrefix);
            this.font2Index.put(afeFont, index);
        }
    }

    private double calculateXAdvance(String wm, double x1, double annotStart, double pageEnd, double patternWidth) {
        double XAdvance = 0.0;
        if (wm.equalsIgnoreCase("LR-TB")) {
            double dividend = x1 + annotStart;
            double divisor = patternWidth;
            int quotient = (int)(dividend / divisor);
            double remainder = dividend - divisor * (double)quotient;
            double temp = 0.0;
            if (remainder > 0.0) {
                temp = divisor * (double)(quotient + 1);
                XAdvance = temp - dividend;
            }
        } else {
            double start = x1 + annotStart;
            double end = pageEnd;
            double dividend = end - start;
            double divisor = patternWidth;
            int quotient = (int)(dividend / divisor);
            double remainder = dividend - divisor * (double)quotient;
            double temp = 0.0;
            if (remainder > 0.0) {
                temp = divisor * (double)(quotient + 1);
                XAdvance = temp - dividend;
            }
        }
        return XAdvance;
    }

    public void show_tab(AGMText text, ContentWriter portContentWriter, String style, double x1, double y1, double x2, double y2, double width, String alignment, double pattern_width, double page_width, double annot_start, String writing_mode) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFParseException, PDFInvalidParameterException, FontLoadingException, InvalidFontException, UnsupportedFontException, PDFUnableToCompleteOperationException {
        Instruction d;
        double[] dash;
        AGMGState agmGState = text.getAGMGState();
        this.portGState.setGState(portContentWriter, agmGState);
        Instruction w = InstructionFactory.newLineWidth(width);
        portContentWriter.write(w);
        double on = 0.0;
        double off = 0.0;
        if (style.equalsIgnoreCase("DASHED")) {
            double tab_width;
            if (0.0 == pattern_width) {
                if (alignment.equalsIgnoreCase("PAGE")) {
                    x1 += this.calculateXAdvance(writing_mode, x1, annot_start, page_width, 6.0 * width);
                }
                tab_width = x2 - x1;
                tab_width %= 6.0 * width;
                on = 4.0 * width;
                off = 2.0 * width;
            } else {
                if (alignment.equalsIgnoreCase("PAGE")) {
                    x1 += this.calculateXAdvance(writing_mode, x1, annot_start, page_width, pattern_width);
                }
                tab_width = x2 - x1;
                tab_width %= pattern_width;
                on = pattern_width * 2.0 / 3.0;
                off = pattern_width - on;
            }
            dash = new double[]{on, off};
            d = InstructionFactory.newLineDashPattern(dash, 0);
            portContentWriter.write(d);
            if (tab_width < on) {
                x2 -= tab_width;
            }
        } else if (style.equalsIgnoreCase("DOTTED")) {
            double tab_width;
            if (0.0 == pattern_width) {
                if (alignment.equalsIgnoreCase("PAGE")) {
                    x1 += this.calculateXAdvance(writing_mode, x1, annot_start, page_width, 2.0 * width);
                }
                tab_width = x2 - x1;
                tab_width %= 2.0 * width;
                on = width;
                off = width;
            } else {
                if (alignment.equalsIgnoreCase("PAGE")) {
                    x1 += this.calculateXAdvance(writing_mode, x1, annot_start, page_width, pattern_width);
                }
                tab_width = x2 - x1;
                tab_width %= pattern_width;
                on = width;
                off = pattern_width - width;
            }
            dash = new double[]{on, off};
            d = InstructionFactory.newLineDashPattern(dash, 0);
            portContentWriter.write(d);
            if (tab_width < on) {
                x2 -= tab_width;
            }
        }
        Instruction m = InstructionFactory.newMoveTo(x1, y1);
        portContentWriter.write(m);
        Instruction l = InstructionFactory.newLineTo(x2, y2);
        portContentWriter.write(l);
        Instruction S = InstructionFactory.newStrokePath();
        portContentWriter.write(S);
    }

    public void showText(AGMText text, ContentWriter portContentWriter, PDFResources resources) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFParseException, PDFInvalidParameterException, FontLoadingException, InvalidFontException, UnsupportedFontException, PDFUnableToCompleteOperationException {
        AGMGState agmGState = text.getAGMGState();
        ASMatrix matrix = text.getCharMatrix();
        int[] unicodeValues = text.getUnicodeValues();
        Iterator glyphPointsIterator = text.getGlyphPointsIterator();
        Font afeFont = text.getFont();
        Subset fontSubset = null;
        PDFFontDescription afeFontDescription = afeFont.getPDFFontDescription();
        List<PDFFont> pdfFontList = this.afeToPdfFontCache.get(afeFont);
        boolean isEmbedded = false;
        boolean isNameKeyed = false;
        PDFDocument pdfDocument = resources.getPDFDocument();
        PDFFontMap resourceFontMap = resources.getFontMap();
        if (resourceFontMap == null) {
            resourceFontMap = PDFFontMap.newInstance(pdfDocument);
            resources.setFontMap(resourceFontMap);
        }
        this.createFontIndex(afeFont, resourceFontMap);
        ArrayList<PDFFont> list = new ArrayList<PDFFont>();
        if (FontResources.isAFEFontEmbeddable(afeFont) && (this.documentHasPDFAMarker || !this.doNotEmbedFonts)) {
            isEmbedded = true;
            fontSubset = this.addType0FontSubset(pdfDocument, afeFont, afeFontDescription, resourceFontMap, list);
        } else {
            PDFFontBuilder builder;
            if (FontResources.isNameKeyedFont(afeFontDescription)) {
                isNameKeyed = true;
                builder = new PDFSimpleFontBuilder(pdfDocument);
            } else {
                builder = new PDFCompositeFontBuilder(pdfDocument);
            }
            ((PDFFontBuilder)builder).buildFonts(text.getGlyphPointsIterator(), afeFont, pdfFontList);
            for (int i = 0; i < pdfFontList.size(); ++i) {
                PDFFont font = pdfFontList.get(i);
                resourceFontMap.set(this.createAndCacheFontName(afeFont, isNameKeyed ? i : -1), font);
            }
        }
        ContentGenerationParams content_gen_params = new ContentGenerationParams(afeFontDescription, fontSubset, isEmbedded, isNameKeyed);
        this.setContent(portContentWriter, agmGState, matrix, glyphPointsIterator, content_gen_params, afeFont, pdfFontList, unicodeValues, list.isEmpty() ? null : list.get(0));
    }

    private Subset addType0FontSubset(PDFDocument pdfDocument, Font afeFont, PDFFontDescription fontDescription, PDFFontMap resourceFontMap, ArrayList<PDFFont> list) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, InvalidFontException, UnsupportedFontException, FontLoadingException {
        Subset fontSubset = null;
        PDFFontType0 pdfFont = null;
        ASName fontKeyName = this.createAndCacheFontName(afeFont, -1);
        PDFFontListener fontListener = PDFFontListener.getFontListener(pdfDocument);
        if (fontListener != null && fontListener.hasMappingInFontCache(afeFont)) {
            fontSubset = fontListener.getSubsetObjFromFontCache(afeFont);
            pdfFont = fontListener.getPDFFontFromFontCache(afeFont);
            this.font2FontSubset.put(afeFont, fontSubset);
            resourceFontMap.set(fontKeyName, pdfFont);
        } else {
            fontSubset = this.font2FontSubset.get(afeFont);
            if (fontSubset == null) {
                fontSubset = afeFont.createSubset();
                this.font2FontSubset.put(afeFont, fontSubset);
            }
            if ((pdfFont = (PDFFontType0)resourceFontMap.get(fontKeyName)) == null) {
                try {
                    ASName basefontName = PDFFontUtils.generateSubsetFontName(fontSubset, fontDescription.getPostscriptName());
                    pdfFont = (PDFFontType0)PDFFontType0.newInstance(pdfDocument, basefontName);
                    pdfFont.setEncoding(PDFType0FontEncoding.newInstance(pdfDocument, ASName.k_Identity_H));
                }
                catch (UnsupportedFontException e) {
                    throw new PDFUnsupportedFeatureException("Attempt to use unsupported font.", e);
                }
                catch (InvalidFontException e) {
                    throw new PDFFontException("Invalid Font in the Font Set.", e);
                }
                resourceFontMap.set(fontKeyName, pdfFont);
            }
            if (fontListener != null) {
                fontListener.addToFontCache(afeFont, fontSubset, pdfFont);
            }
        }
        list.add(pdfFont);
        return fontSubset;
    }

    private void emitPositionAndGlyphs(double startXPosition, double startYPosition, int[] ccodes, int lastCCodeIndex, int numBytes, ContentWriter portContentWriter) throws PDFIOException, PDFParseException {
        Instruction Td = InstructionFactory.newTextPosition(startXPosition, startYPosition);
        portContentWriter.write(Td);
        Instruction Tj = this.generateTjInstruction(ccodes, lastCCodeIndex, numBytes);
        if (Tj != null) {
            portContentWriter.write(Tj);
        }
    }

    private int setupCCode(ContentGenerationParams content_gen_params, AGMGlyphDescription glyph, int[] ccodes, int currPos, PDFFont pdfFont) throws FontLoadingException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        int numBytes = 0;
        try {
            if (content_gen_params.isEmbeddedFont()) {
                ccodes[currPos] = content_gen_params.getFontSubset().getSubsetGid(glyph.getGlyphID());
                numBytes = 2;
            } else if (content_gen_params.isNameKeyedFont()) {
                int glyphID = 0;
                String glyphName = null;
                glyphID = glyph.getGlyphID();
                glyphName = content_gen_params.getFontDescription().getGlyphName(glyphID);
                ccodes[currPos] = ((PDFFontSimple)pdfFont).getEncoding().fromGlyphName(glyphName, pdfFont.getBaseFont());
                numBytes = 1;
            } else {
                ccodes[currPos] = content_gen_params.getFontDescription().getGlyphCid(glyph.getGlyphID());
                numBytes = 2;
            }
        }
        catch (UnsupportedFontException e) {
            throw new PDFUnsupportedFeatureException("Attempt to use unsupported font.", e);
        }
        catch (InvalidFontException e) {
            throw new PDFFontException("Invalid Font in the Font Set.", e);
        }
        return numBytes;
    }

    private void setContent(ContentWriter portContentWriter, AGMGState agmGState, ASMatrix matrix, Iterator glyphPointsIterator, ContentGenerationParams content_gen_params, Font afeFont, List<PDFFont> pdfFontList, int[] unicodeValues, PDFFont pdfFontkey) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFParseException, PDFFontException, FontLoadingException, InvalidFontException, UnsupportedFontException, PDFInvalidParameterException {
        PDFFont pdfFont = null;
        int MAXCODES = 20;
        int[] ccodes = new int[20];
        int currCCodeIndex = 0;
        int numBytes = 0;
        boolean firstIter = true;
        double startXPosition = 0.0;
        double startYPosition = 0.0;
        double lastWidthUserSpace = 1000.0;
        boolean multipleFonts = pdfFontList.size() > 1;
        double deltaX = 0.0;
        double deltaY = 0.0;
        double offsetFromMatrixX = 0.0;
        double offsetFromMatrixY = 0.0;
        Instruction q = InstructionFactory.newGSave();
        portContentWriter.write(q);
        try {
            this.portGState.setGState(portContentWriter, agmGState);
        }
        catch (PDFParseException e) {
            throw new PDFInvalidContentException(e);
        }
        Instruction BT = InstructionFactory.newBeginText();
        portContentWriter.write(BT);
        if (!multipleFonts) {
            boolean compositeFont = content_gen_params.isEmbeddedFont() ? true : !content_gen_params.isNameKeyedFont();
            Instruction Tf = InstructionFactory.newTextFont(this.createAndCacheFontName(afeFont, compositeFont ? -1 : 0), 1.0);
            portContentWriter.write(Tf);
        }
        Instruction Tm = InstructionFactory.newTextMatrix(matrix.geta(), matrix.getb(), matrix.getc(), matrix.getd(), matrix.getx(), matrix.gety());
        portContentWriter.write(Tm);
        PDFFont pDFFont = pdfFont = pdfFontList.size() == 1 ? pdfFontList.get(0) : null;
        if (pdfFont != null) {
            pdfFontkey = pdfFont;
        }
        double lastXPos = 0.0;
        double lastYPos = 0.0;
        while (glyphPointsIterator.hasNext()) {
            Iterator gylphToCharOccurIter;
            Integer ccode;
            AGMGlyphDescription glyph = (AGMGlyphDescription)glyphPointsIterator.next();
            int glyphID = glyph.getGlyphID();
            double thisXPos = glyph.getXPosition();
            double thisYPos = glyph.getYPosition();
            if (firstIter) {
                startXPosition = thisXPos + offsetFromMatrixX;
                startYPosition = thisYPos + offsetFromMatrixY;
            }
            if (!(firstIter || PDFPortShowText.positionAligns(thisXPos, thisYPos, lastWidthUserSpace, lastXPos, lastYPos) && !multipleFonts && currCCodeIndex + 1 < 20)) {
                this.emitPositionAndGlyphs(startXPosition, startYPosition, ccodes, currCCodeIndex - 1, numBytes, portContentWriter);
                currCCodeIndex = 0;
                startXPosition = thisXPos - deltaX + offsetFromMatrixX;
                startYPosition = thisYPos - deltaY + offsetFromMatrixY;
                deltaX = thisXPos;
                deltaY = thisYPos;
            } else if (firstIter) {
                if (thisXPos < 0.0) {
                    deltaX = thisXPos;
                    deltaY = thisYPos;
                } else {
                    deltaY = 0.0;
                    deltaX = 0.0;
                    deltaX = thisXPos + (lastXPos - thisXPos);
                }
            }
            lastXPos = thisXPos;
            lastYPos = thisYPos;
            if (multipleFonts) {
                int which = FontResources.getFontIndexForGlyph(glyphID, afeFont, pdfFontList);
                PDFFont fetchedFont = pdfFontList.get(which);
                if (pdfFont == null || !pdfFont.equals(fetchedFont)) {
                    pdfFontkey = pdfFont = fetchedFont;
                    Instruction Tf = InstructionFactory.newTextFont(this.createAndCacheFontName(afeFont, which), 1.0);
                    portContentWriter.write(Tf);
                }
            }
            numBytes = this.setupCCode(content_gen_params, glyph, ccodes, currCCodeIndex, pdfFont);
            TreeMap<Integer, byte[]> unicodeMap = null;
            if (this.fontUnicodeMapping.get(pdfFontkey) == null) {
                this.fontUnicodeMapping.put(pdfFontkey, new TreeMap());
            }
            if ((unicodeMap = this.fontUnicodeMapping.get(pdfFontkey)).get(ccode = Integer.valueOf(ccodes[currCCodeIndex])) == null && (gylphToCharOccurIter = glyph.getGlyphToCharacterOccurrences()) != null) {
                byte[] oldBytes = unicodeMap.get(ccode);
                while (gylphToCharOccurIter.hasNext()) {
                    Integer i = (Integer)gylphToCharOccurIter.next();
                    String hexStr = PDFPortShowText.getPaddedHexString(Integer.toHexString(unicodeValues[i]));
                    byte[] newBytes = this.mergehexStringToByteArray(hexStr, oldBytes);
                    oldBytes = newBytes;
                    unicodeMap.put(ccode, newBytes);
                }
            }
            lastWidthUserSpace = content_gen_params.getFontDescription().getAdvance(glyphID);
            ++currCCodeIndex;
            firstIter = false;
        }
        if (currCCodeIndex != 0) {
            this.emitPositionAndGlyphs(startXPosition, startYPosition, ccodes, currCCodeIndex - 1, numBytes, portContentWriter);
        }
        Instruction ET = InstructionFactory.newEndText();
        portContentWriter.write(ET);
        Instruction Q = InstructionFactory.newGRestore();
        portContentWriter.write(Q);
    }

    private static boolean positionAligns(double thisX, double thisY, double lastWidth, double lastXPos, double lastYPos) {
        double diffX = thisX * 1000.0 - (lastWidth + lastXPos * 1000.0);
        double diffY = thisY * 1000.0 - lastYPos * 1000.0;
        boolean retval = Math.round(diffX) == 0L && Math.round(diffY) == 0L;
        return retval;
    }

    private Instruction generateTjInstruction(int[] ccodes, int endIndex, int numBytes) throws PDFIOException, PDFParseException {
        Instruction Tj = null;
        Tj = numBytes == 2 ? InstructionFactory.newShow2ByteCCodes(ccodes, 0, endIndex) : InstructionFactory.newShow1ByteCCodes(ccodes, 0, endIndex);
        return Tj;
    }

    private static class AFEtoPDFFontCache {
        private Map<Font, List<PDFFont>> afeToPdfFontListMap = new HashMap<Font, List<PDFFont>>();

        private AFEtoPDFFontCache() {
        }

        void add(Font afefont, PDFFont pdffont) {
            List<PDFFont> pdffonts = this.get(afefont);
            pdffonts.add(pdffont);
        }

        List<PDFFont> get(Font afefont) {
            List<PDFFont> pdffonts = this.afeToPdfFontListMap.get(afefont);
            if (pdffonts == null) {
                pdffonts = new ArrayList<PDFFont>();
                this.afeToPdfFontListMap.put(afefont, pdffonts);
            }
            return pdffonts;
        }
    }
}

