/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfport;

import com.adobe.internal.agm.AGMException;
import com.adobe.internal.agm.AGMPath;
import com.adobe.internal.agm.AGMPort;
import com.adobe.internal.agm.AGMText;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.services.pdfport.impl.PDFPortFillPath;
import com.adobe.internal.pdftoolkit.services.pdfport.impl.PDFPortGState;
import com.adobe.internal.pdftoolkit.services.pdfport.impl.PDFPortShowText;
import com.adobe.internal.pdftoolkit.services.pdfport.impl.PDFPortStrokePath;
import com.adobe.internal.pdftoolkit.services.xfatext.RenderXFATextShow;
import java.util.Map;

public class PDFPort
implements AGMPort {
    private ContentWriter portContentWriter;
    private PDFResources portResources;
    private PDFPortShowText portShowText;
    private PDFPortFillPath portFillPath;
    private PDFPortStrokePath portStrokePath;
    private PDFPortGState portGState;
    private PDFRectangle annotRect = null;
    private PDFRectangle pageRect = null;

    public PDFRectangle getAnnotRect() {
        return this.annotRect;
    }

    public void setAnnotRect(PDFRectangle annotRect) {
        this.annotRect = annotRect;
    }

    public PDFRectangle getPageRect() {
        return this.pageRect;
    }

    public void setPageRect(PDFRectangle pageRect) {
        this.pageRect = pageRect;
    }

    public PDFPort(ContentWriter contentWriter, PDFResources resources) {
        this.portContentWriter = contentWriter;
        this.portResources = resources;
        this.portGState = new PDFPortGState();
        this.portShowText = new PDFPortShowText(this.portGState, null, this.portResources.getPDFDocument());
        this.portFillPath = new PDFPortFillPath(this.portGState);
        this.portStrokePath = new PDFPortStrokePath(this.portGState);
    }

    public PDFPort(ContentWriter contentWriter, PDFResources resources, Map afe2pdfmap) {
        this.portContentWriter = contentWriter;
        this.portResources = resources;
        this.portGState = new PDFPortGState();
        this.portShowText = new PDFPortShowText(this.portGState, afe2pdfmap, this.portResources.getPDFDocument());
        this.portFillPath = new PDFPortFillPath(this.portGState);
        this.portStrokePath = new PDFPortStrokePath(this.portGState);
    }

    @Override
    public void fill(AGMPath path) throws AGMException {
        try {
            this.portFillPath.pdfPortFillPath(path, this.portContentWriter);
        }
        catch (PDFException e) {
            throw new AGMException(e);
        }
    }

    @Override
    public void stroke(AGMPath path) throws AGMException {
        try {
            this.portStrokePath.pdfPortStrokePath(path, this.portContentWriter);
        }
        catch (PDFException e) {
            throw new AGMException(e);
        }
    }

    @Override
    public void show(AGMText text) throws AGMException {
        try {
            RenderXFATextShow render = null;
            if (text instanceof RenderXFATextShow) {
                render = (RenderXFATextShow)text;
            }
            if (null != render && render.isPvt_tab()) {
                this.portShowText.show_tab(text, this.portContentWriter, render.getPvt_style(), render.getPvt_tab_x1(), render.getPvt_tab_y1(), render.getPvt_tab_x2(), render.getPvt_tab_y2(), render.getPvt_width(), render.getPvt_alignment(), render.getPvt_pattern_width(), render.getPvt_page_width(), render.getPvt_annot_start(), render.getPvt_writing_mode());
            } else {
                this.portShowText.showText(text, this.portContentWriter, this.portResources);
            }
        }
        catch (Exception e) {
            throw new AGMException(e);
        }
    }

    public void closePDFPort() throws PDFIOException, PDFFontException, PDFInvalidDocumentException, PDFSecurityException {
        this.portShowText.finalizeFonts(this.portResources);
    }
}

