/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.xmp;

import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.MetadataUsageTreeNode;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPSimpleType;

class XMPText
extends XMPSimpleType {
    private static XMPText _xmpText = new XMPText();
    private static final String PDFAIDNS = "http://www.aiim.org/pdfa/ns/id/";
    private static final String DYNAMIC_MEDIA_NS = "http://ns.adobe.com/xmp/1.0/DynamicMedia/";

    private XMPText() {
    }

    public static XMPText getInstance() {
        return _xmpText;
    }

    @Override
    public boolean isValid(MetadataUsageTreeNode a) {
        if (!super.isValid(a)) {
            return false;
        }
        String value = a.getValue();
        if ("http://ns.adobe.com/photoshop/1.0/".equals(a.getNameSpaceURI()) && a.getName() != null && a.getName().equals("Category")) {
            char[] chars = value.toCharArray();
            if (chars.length > 3) {
                return false;
            }
            for (char ch : chars) {
                if (ch <= '\u007f' && ch >= '\u0000') continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValid(MetadataUsageTreeNode m, boolean closedChoice) {
        if (!closedChoice) {
            return this.isValid(m);
        }
        String value = m.getValue();
        if (PDFAIDNS.equals(m.getNameSpaceURI()) && m.getName() != null && m.getName().equals("conformance")) {
            return "A".equals(value) || "B".equals(value) || "U".equals(value);
        }
        if (m.getNameSpaceURI() != null && m.getNameSpaceURI().equals(DYNAMIC_MEDIA_NS)) {
            if (m.getName() != null) {
                if (m.getName().equals("videoPixelDepth")) {
                    return "8Int".equals(value) || "16Int".equals(value) || "32Int".equals(value) || "32Float".equals(value);
                }
                if (m.getName().equals("videoColorSpace")) {
                    return "sRGB".equals(value) || "CCIR-601".equals(value) || "CCIR-709".equals(value);
                }
                if (m.getName().equals("videoAlphaMode")) {
                    return "straight".equals(value) || "pre-multiplied".equals(value);
                }
                if (m.getName().equals("videoFieldOrder")) {
                    return "Upper".equals(value) || "Lower".equals(value) || "Progressive".equals(value);
                }
                if (m.getName().equals("pullDown")) {
                    return "WSSWW".equals(value) || "SSWWW".equals(value) || "SWWWS".equals(value) || "WWWSS".equals(value) || "WSSWW".equals(value) || "SSWWW".equals(value) || "WWSSW".equals(value) || "WSSWW_24p".equals(value) || "SSWWW_24p".equals(value) || "SWWWS_24p".equals(value) || "WWWSS_24p".equals(value) || "WWSSW_24p".equals(value);
                }
                if (m.getName().equals("audioSampleType")) {
                    return "8Int".equals(value) || "16Int".equals(value) || "32Int".equals(value) || "32Float".equals(value);
                }
                if (m.getName().equals("audioChannelType")) {
                    return "Mono".equals(value) || "5.1".equals(value) || "7.1".equals(value);
                }
                if (m.getName().equals("key")) {
                    return "C".equals(value) || "C#".equals(value) || "D".equals(value) || "D#".equals(value) || "E".equals(value) || "F".equals(value) || "F#".equals(value) || "G".equals(value) || "G#".equals(value) || "A".equals(value) || "A#".equals(value) || "B".equals(value);
                }
                if (m.getName().equals("stretchMode")) {
                    return "Fixed length".equals(value) || "Time-Scale".equals(value) || "Resample".equals(value) || "Beat Splice".equals(value) || "Hybrid".equals(value);
                }
                if (m.getName().equals("timeSignature")) {
                    return "2/4".equals(value) || "3/4".equals(value) || "4/4".equals(value) || "5/4".equals(value) || "7/4".equals(value) || "6/8".equals(value) || "9/8".equals(value) || "12/8".equals(value) || "other".equals(value);
                }
                if (m.getName().equals("scaleType")) {
                    return "Major".equals(value) || "Minor,".equals(value) || "Both".equals(value) || "Neither".equals(value);
                }
            }
        } else if ("http://ns.adobe.com/camera-rawsettings/1.0/".equals(m.getNameSpaceURI()) && m.getName() != null && m.getName().equals("WhiteBalance")) {
            return "As Shot".equals(value) || "Auto".equals(value) || "Daylight".equals(value) || "Cloudy".equals(value) || "Shade".equals(value) || "Tungsten".equals(value) || "Fluorescent".equals(value) || "Flash".equals(value) || "Custom".equals(value);
        }
        return true;
    }
}

