/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.xmp;

import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.MetadataUsageTreeNode;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPAgentName;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPDate;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPField;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPMultipleFieldType;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPOpenChoice;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPText;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPURI;
import java.util.EnumSet;
import java.util.HashMap;

class XMPResourceEvent
extends XMPMultipleFieldType {
    private static XMPResourceEvent _xmpResourceEvent = new XMPResourceEvent();
    private static final String FIELD_NAMESPACE_URI = "http://ns.adobe.com/xap/1.0/sType/ResourceEvent/";
    private static final HashMap<String, XMPField> fieldMap = new HashMap();

    private XMPResourceEvent() {
    }

    public static XMPResourceEvent getInstance() {
        return _xmpResourceEvent;
    }

    @Override
    HashMap<String, XMPField> getFieldsMap() {
        return fieldMap;
    }

    @Override
    protected String getNameSpaceURI() {
        return FIELD_NAMESPACE_URI;
    }

    @Override
    public boolean isValid(MetadataUsageTreeNode m) {
        boolean validateHistory = true;
        if (m.getParentNode().getName() != null && m.getParentNode().getName().equalsIgnoreCase("History")) {
            validateHistory = this.validateHistoryNode(m);
        }
        if (validateHistory) {
            return super.isValid(m);
        }
        return validateHistory;
    }

    private boolean validateHistoryNode(MetadataUsageTreeNode m) {
        EnumSet<Fields> mandatoryFields = EnumSet.of(Fields.action, Fields.parameters, Fields.when);
        EnumSet<Fields> presentField = EnumSet.noneOf(Fields.class);
        if (m.getNodes() == null) {
            return true;
        }
        if (m.getNodes().size() < 3 || m.getNodes().size() > 5) {
            return false;
        }
        HashMap<String, XMPField> fieldsMap = this.getFieldsMap();
        for (MetadataUsageTreeNode node : m.getNodes()) {
            XMPField field = fieldsMap.get(node.getName());
            if (field == null) {
                return false;
            }
            String fieldname = null;
            if (field.getFieldName() == null) {
                return false;
            }
            fieldname = new String(field.getFieldName());
            if (fieldname.equalsIgnoreCase("action")) {
                presentField.add(Fields.action);
                continue;
            }
            if (fieldname.equalsIgnoreCase("parameters")) {
                presentField.add(Fields.parameters);
                continue;
            }
            if (fieldname.equalsIgnoreCase("when")) {
                presentField.add(Fields.when);
                continue;
            }
            if (fieldname.equalsIgnoreCase("softwareagent")) {
                presentField.add(Fields.softwareAgent);
                continue;
            }
            if (!fieldname.equalsIgnoreCase("instanceID")) continue;
            presentField.add(Fields.instanceID);
        }
        mandatoryFields.removeAll(presentField);
        if (mandatoryFields.size() > 0) {
            return false;
        }
        return !presentField.contains((Object)Fields.instanceID) || presentField.contains((Object)Fields.softwareAgent);
    }

    static {
        fieldMap.put("action", new XMPField("action", XMPOpenChoice.getInstance()));
        fieldMap.put("instanceID", new XMPField("instanceID", XMPURI.getInstance()));
        fieldMap.put("parameters", new XMPField("parameters", XMPText.getInstance()));
        fieldMap.put("softwareAgent", new XMPField("softwareAgent", XMPAgentName.getInstance()));
        fieldMap.put("when", new XMPField("when", XMPDate.getInstance()));
    }

    private static enum Fields {
        action,
        parameters,
        when,
        softwareAgent,
        instanceID;

    }
}

