/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.xmp;

import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.MetadataUsageTreeNode;
import com.adobe.internal.pdftoolkit.services.pdfa2.xmp.XMPSimpleType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

class XMPLocale
extends XMPSimpleType {
    private static final List<String> SORTED_ISO_COUNTRIES = Arrays.asList(Locale.getISOCountries());
    private static final List<String> SORTED_ISO_LANGUAGES = Arrays.asList(Locale.getISOLanguages());
    private static XMPLocale _xmpLocale;

    private XMPLocale() {
    }

    public static XMPLocale getInstance() {
        return _xmpLocale;
    }

    @Override
    public boolean isValid(MetadataUsageTreeNode m) {
        String country;
        if (!super.isValid(m)) {
            return false;
        }
        String value = m.getValue();
        String[] arr = value.split("-");
        if (arr.length == 0 || arr.length > 2) {
            return false;
        }
        String language = arr[0];
        if (Collections.binarySearch(SORTED_ISO_LANGUAGES, language, String.CASE_INSENSITIVE_ORDER) < 0) {
            return false;
        }
        return arr.length != 2 || (country = arr[1]) == null || Collections.binarySearch(SORTED_ISO_COUNTRIES, country, String.CASE_INSENSITIVE_ORDER) >= 0;
    }

    static {
        Collections.sort(SORTED_ISO_COUNTRIES, String.CASE_INSENSITIVE_ORDER);
        Collections.sort(SORTED_ISO_LANGUAGES, String.CASE_INSENSITIVE_ORDER);
        _xmpLocale = new XMPLocale();
    }
}

