/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoleMap;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoot;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractCatalogErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2CatalogErrorElementDoesNotUseStandardType;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.StructureTypeNameCollector;
import java.util.HashSet;

class StructureProcessor {
    private static final HashSet<ASName> STANDARD_STRUCT_TYPES = new HashSet();

    StructureProcessor() {
    }

    static void processStructureRoot(PDFStructureRoot structureRoot, PDFA2ErrorSet<PDFA2AbstractCatalogErrorCode> errorCodes, PDFA2ConversionHandler conversionHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int objNum = structureRoot.getCosObject().getObjNum();
        int objGen = structureRoot.getCosObject().getObjGen();
        PDFStructureRoleMap roleMap = structureRoot.getRoleMap();
        StructureTypeNameCollector nameCollector = new StructureTypeNameCollector(structureRoot);
        HashSet<ASName> structTypes = nameCollector.getStuctureTypeNames();
        for (ASName name : structTypes) {
            ASName nameFromRoleMap;
            if (STANDARD_STRUCT_TYPES.contains(name)) continue;
            ASName aSName = nameFromRoleMap = roleMap == null ? null : roleMap.getRole(name);
            if (nameFromRoleMap != null && STANDARD_STRUCT_TYPES.contains(nameFromRoleMap) || conversionHandler != null) continue;
            errorCodes.addErrorCode(new PDFA2CatalogErrorElementDoesNotUseStandardType(name.asString(), objNum, objGen));
        }
    }

    static {
        STANDARD_STRUCT_TYPES.add(ASName.create("Document"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Part"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Art"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Sect"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Div"));
        STANDARD_STRUCT_TYPES.add(ASName.create("BlockQuote"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Caption"));
        STANDARD_STRUCT_TYPES.add(ASName.create("TOC"));
        STANDARD_STRUCT_TYPES.add(ASName.create("TOCI"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Index"));
        STANDARD_STRUCT_TYPES.add(ASName.create("NonStruct"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Private"));
        STANDARD_STRUCT_TYPES.add(ASName.create("P"));
        STANDARD_STRUCT_TYPES.add(ASName.create("H1"));
        STANDARD_STRUCT_TYPES.add(ASName.create("H2"));
        STANDARD_STRUCT_TYPES.add(ASName.create("H3"));
        STANDARD_STRUCT_TYPES.add(ASName.create("H4"));
        STANDARD_STRUCT_TYPES.add(ASName.create("H5"));
        STANDARD_STRUCT_TYPES.add(ASName.create("H6"));
        STANDARD_STRUCT_TYPES.add(ASName.create("L"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Lbl"));
        STANDARD_STRUCT_TYPES.add(ASName.create("LI"));
        STANDARD_STRUCT_TYPES.add(ASName.create("LBody"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Table"));
        STANDARD_STRUCT_TYPES.add(ASName.create("H"));
        STANDARD_STRUCT_TYPES.add(ASName.create("H1\u0096H6"));
        STANDARD_STRUCT_TYPES.add(ASName.create("TR"));
        STANDARD_STRUCT_TYPES.add(ASName.create("TH"));
        STANDARD_STRUCT_TYPES.add(ASName.create("TD"));
        STANDARD_STRUCT_TYPES.add(ASName.create("THead"));
        STANDARD_STRUCT_TYPES.add(ASName.create("TBody"));
        STANDARD_STRUCT_TYPES.add(ASName.create("TFoot"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Span"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Quote"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Note"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Reference"));
        STANDARD_STRUCT_TYPES.add(ASName.create("BibEntry"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Code"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Link"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Annot"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Ruby"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Warichu"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Ruby"));
        STANDARD_STRUCT_TYPES.add(ASName.create("RB"));
        STANDARD_STRUCT_TYPES.add(ASName.create("RT"));
        STANDARD_STRUCT_TYPES.add(ASName.create("RP"));
        STANDARD_STRUCT_TYPES.add(ASName.create("WT"));
        STANDARD_STRUCT_TYPES.add(ASName.create("WP"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Figure"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Formula"));
        STANDARD_STRUCT_TYPES.add(ASName.create("Form"));
    }
}

