/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGStateMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractColorSpaceErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractExtGStateErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractPatternErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractXObjectErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ColorSpaceErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ExtGStateErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2PatternErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.ColorSpaceProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.ExtGStateProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.PatternProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.ReferencedResources;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TransparencyState;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.XObjectProcessor;

class ResourceProcessor {
    ResourceProcessor() {
    }

    static boolean process(PDFResources resources, ReferencedResources referencedResources, DocumentProcessor docProcessor, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler, TransparencyState transparencyInfo) throws PDFIOException, PDFSecurityException {
        block22: {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            if (resources == null) {
                                return true;
                            }
                            try {
                                if (!ColorSpaceProcessor.process(resources, referencedResources.getColorSpaces(), docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) {
                                    return false;
                                }
                            }
                            catch (PDFInvalidDocumentException e) {
                                if (validationHandler.colorSpaceError(new PDFA2ErrorSet<PDFA2AbstractColorSpaceErrorCode>(new PDFA2ColorSpaceErrorPDFGeneralFailure(0, 0)))) break block18;
                                return false;
                            }
                        }
                        try {
                            PDFExtGStateMap extGStateMap = resources.getExtGStateMap();
                            if (!ExtGStateProcessor.process(extGStateMap, referencedResources.getExtGStateNames(), conversionOptions, conversionHandler, validationOptions, validationHandler)) {
                                return false;
                            }
                        }
                        catch (PDFInvalidDocumentException e) {
                            if (validationHandler.extGStateError(null, new PDFA2ErrorSet<PDFA2AbstractExtGStateErrorCode>(new PDFA2ExtGStateErrorPDFGeneralFailure(0, 0)))) break block19;
                            return false;
                        }
                    }
                    try {
                        PDFFontMap fontMap = resources.getFontMap();
                        try {
                            if (!FontProcessor.process(fontMap, referencedResources, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, transparencyInfo)) {
                                return false;
                            }
                        }
                        catch (PDFInvalidParameterException e) {
                            throw new PDFInvalidDocumentException(e);
                        }
                    }
                    catch (PDFInvalidDocumentException e) {
                        if (validationHandler.fontError(new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>(new PDFA2FontErrorPDFGeneralFailure(0, 0)))) break block20;
                        return false;
                    }
                }
                try {
                    PDFXObjectMap xObjectMap = resources.getXObjectMap();
                    if (!XObjectProcessor.process(xObjectMap, referencedResources.getXObjects(), docProcessor, resources, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, transparencyInfo)) {
                        return false;
                    }
                }
                catch (PDFInvalidDocumentException e) {
                    if (validationHandler.xObjectError(new PDFA2ErrorSet<PDFA2AbstractXObjectErrorCode>(new PDFA2XObjectErrorPDFGeneralFailure(0, 0)))) break block21;
                    return false;
                }
            }
            try {
                PDFPatternMap patternMap = resources.getPatternMap();
                if (!PatternProcessor.process(patternMap, referencedResources.getPatterns(), docProcessor, resources, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, transparencyInfo)) {
                    return false;
                }
            }
            catch (PDFInvalidDocumentException e) {
                if (validationHandler.patternError(new PDFA2ErrorSet<PDFA2AbstractPatternErrorCode>(new PDFA2PatternErrorPDFGeneralFailure(0, 0)))) break block22;
                return false;
            }
        }
        return true;
    }
}

