/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFileStructureErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.PDFA2EmbeddedFileProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.PDFA3EmbeddedFileProcessor;
import java.io.IOException;
import java.util.HashSet;

abstract class EmbeddedFileProcessor {
    EmbeddedFileProcessor() {
    }

    static EmbeddedFileProcessor getInstance(PDFA2ConformanceLevel level) {
        if (level.getVersion().equals("2")) {
            return PDFA2EmbeddedFileProcessor.getInstance();
        }
        if (level == PDFA2ConformanceLevel.Level_3b) {
            return PDFA3EmbeddedFileProcessor.getInstance();
        }
        throw new PDFUnsupportedFeatureException("Only PDF/A-2 a,b,u and PDF/A-3b conformance levels are supported.");
    }

    abstract void process(CosObject var1, PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode> var2, PDFA2ValidationHandler var3, PDFA2ConversionHandler var4, HashSet<CosObject> var5) throws PDFIOException, PDFSecurityException, IOException;

    abstract PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode> validateEmbeddedFile(CosDictionary var1, PDFA2ValidationHandler var2, PDFA2ConversionHandler var3, HashSet<CosObject> var4) throws PDFIOException, PDFSecurityException, IOException, PDFInvalidDocumentException;
}

