/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.font;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.pdf.interchange.metadata.PDFMetadata;
import com.adobe.internal.pdftoolkit.services.pdfa.common.BaseUnembeddedFontInfo;
import com.adobe.internal.pdftoolkit.services.pdfa.common.FontProcessorUtils;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2XMPErrorCollector;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorEmbeddingFailedFontNotInFontSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorFontDataCorrupt;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorFontNotEmbedded;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorMalformedFontDictionary;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorNameNotUTF8;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorNotDefGlyphUsed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorSymbolicTTProgramCmapTableDoesNotHaveOneEntryAndMS3_0_encoding;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorSymbolicTrueTypeEncodingNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTrueTypeEmbeddedFontCouldNotMapGlyph;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorType2CIDFontInvalidCIDToGIDMap;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorType2CIDFontMissingCIDToGIDMap;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.ReferencedFontInfoProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.TrueTypeFontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.Type0FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.Type1FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.Type3FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.UnembeddedFontInfo;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.WidthsProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.MetadataProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.ReferencedResources;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TransparencyState;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeSet;

public class FontProcessor {
    static final int FONT_DATA_TYPE0 = 0;
    static final int FONT_DATA_TYPE1 = 1;
    static final int FONT_DATA_TRUETYPE = 2;
    static final String NOTDEF = ".notdef";

    private static boolean willEmbed(PDFFont pdfFont, PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes, PDFA2ConversionHandler conversionHandler, PDFA2ConversionOptions conversionOptions) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (pdfFont instanceof PDFFontType3) {
            return false;
        }
        if (conversionHandler == null || conversionOptions == null) {
            return false;
        }
        if (!conversionOptions.getShouldEmbedFonts()) {
            return false;
        }
        if (errorCodes.errorCodeSet(PDFA2FontErrorFontNotEmbedded.class) || errorCodes.errorCodeSet(PDFA2FontErrorSymbolicTTProgramCmapTableDoesNotHaveOneEntryAndMS3_0_encoding.class) || errorCodes.errorCodeSet(PDFA2FontErrorType2CIDFontInvalidCIDToGIDMap.class) || errorCodes.errorCodeSet(PDFA2FontErrorType2CIDFontMissingCIDToGIDMap.class)) {
            return true;
        }
        return FontProcessor.willEmbedSimpleFontsAsType0(pdfFont, errorCodes);
    }

    static boolean willEmbedSimpleFontsAsType0(PDFFont font, PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (font instanceof PDFFontSimple && font.getSubtype() == ASName.k_TrueType) {
            if (PDFFontUtils.isFontEmbedded(font) && errorCodes.getErrorCodes().size() == 1 && errorCodes.errorCodeSet(PDFA2FontErrorTrueTypeEmbeddedFontCouldNotMapGlyph.class)) {
                return true;
            }
            if (PDFFontUtils.isFontEmbedded(font) && errorCodes.getErrorCodes().size() == 1 && errorCodes.errorCodeSet(PDFA2FontErrorSymbolicTrueTypeEncodingNotAllowed.class)) {
                return true;
            }
            if (PDFFontUtils.isFontEmbedded(font) && errorCodes.getErrorCodes().size() == 2 && errorCodes.errorCodeSet(PDFA2FontErrorSymbolicTrueTypeEncodingNotAllowed.class) && errorCodes.errorCodeSet(PDFA2FontErrorTrueTypeEmbeddedFontCouldNotMapGlyph.class)) {
                return true;
            }
        }
        if (font instanceof PDFFontSimple && font.getSubtype() == ASName.k_Type1 && !PDFFontUtils.isFontEmbedded(font)) {
            PDFFontSimple simpleFont = (PDFFontSimple)font;
            PDFSimpleFontEncoding encoding = simpleFont.getEncoding();
            if (encoding == null || encoding.getDifferences() == null) {
                return false;
            }
            try {
                FontData fontData;
                Font afeFont = font.getAFEFont();
                if (afeFont != null && PDFFontUtils.isFontDataTrueType(fontData = ((FontImpl)afeFont).getFontData())) {
                    return true;
                }
            }
            catch (FontLoadingException e) {
                return false;
            }
            catch (InvalidFontException e) {
                return false;
            }
            catch (UnsupportedFontException e) {
                return false;
            }
        }
        return false;
    }

    static void setTypeErrorCodes(CosDictionary obj, ASName type, PDFA2ConversionHandler conversionHandler, PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes, PDFA2AbstractFontErrorCode errorCodeWrongType, PDFA2AbstractFontErrorCode errorCodeAbsent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (conversionHandler != null) {
            obj.put(ASName.k_Type, type);
            return;
        }
        CosObject cosType = obj.get(ASName.k_Type);
        if (cosType instanceof CosName) {
            ASName thisType = ((CosName)cosType).nameValue();
            if (thisType != type) {
                errorCodes.addErrorCode(errorCodeWrongType);
            }
        } else {
            errorCodes.addErrorCode(errorCodeAbsent);
        }
    }

    private static boolean processFontMetadata(DocumentProcessor docProcessor, PDFFont font, TrackingConversionHandler conversionHandler, PDFA2ConversionOptions conversionOptions, TrackingValidationHandler validationHandler, PDFA2ValidationOptions validationOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (font == null) {
            return true;
        }
        ASName subType = font.getSubtype();
        if (subType != ASName.k_Type0 && subType != ASName.k_Type1 && subType != ASName.k_TrueType) {
            return true;
        }
        PDFFontDescriptor pdfFontDescriptor = font.getFontDescriptor();
        if (pdfFontDescriptor == null) {
            return true;
        }
        PDFFontFile fontFile = PDFFontUtils.getFontFileFromFontDescriptor(pdfFontDescriptor);
        if (fontFile == null) {
            return true;
        }
        PDFMetadata fontMetadata = fontFile.getMetadata();
        if (fontMetadata == null || fontMetadata.getType() != ASName.k_Metadata || fontMetadata.getSubtype() != ASName.k_XML) {
            return true;
        }
        PDFA2XMPErrorCollector errorCodes = new PDFA2XMPErrorCollector();
        if (!MetadataProcessor.processXMP(docProcessor, fontFile.getPDFDocument(), fontFile, null, conversionHandler, conversionOptions, validationHandler, validationOptions, errorCodes)) {
            return false;
        }
        return !errorCodes.hasErrors() || validationHandler.fontXMPError(errorCodes);
    }

    static boolean processBadFont(ASName name, PDFFontMap map, List showStringList, PDFA2ValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes;
        block10: {
            if (showStringList == null || showStringList.isEmpty()) {
                return true;
            }
            if (!validationHandler.beginFontScan(name, null)) {
                return false;
            }
            errorCodes = new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>();
            CosDictionary cosFonts = map.getCosDictionary();
            if (cosFonts == null) {
                errorCodes.addErrorCode(new PDFA2FontErrorPDFGeneralFailure(map.getCosObject().getObjNum(), map.getCosObject().getObjGen()));
            } else {
                try {
                    CosDictionary cosFont = cosFonts.getCosDictionary(name);
                    if (cosFont == null) {
                        errorCodes.addErrorCode(new PDFA2FontErrorPDFGeneralFailure(cosFonts.getObjNum(), cosFonts.getObjGen()));
                        break block10;
                    }
                    try {
                        PDFFontFactory.getInstance(cosFont);
                        throw new RuntimeException("FontProcessor.processBadFont() should not have reached here.");
                    }
                    catch (PDFInvalidDocumentException e) {
                        errorCodes.addErrorCode(new PDFA2FontErrorMalformedFontDictionary(cosFonts.getObjNum(), cosFonts.getObjGen()));
                    }
                }
                catch (PDFCosParseException e) {
                    errorCodes.addErrorCode(new PDFA2FontErrorPDFGeneralFailure(cosFonts.getObjNum(), cosFonts.getObjGen()));
                }
            }
        }
        if (!validationHandler.fontError(errorCodes)) {
            return false;
        }
        return validationHandler.endFontScan();
    }

    static boolean process(ASName name, PDFFont font, List showStringList, DocumentProcessor docProcessor, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler, TransparencyState transparencyInfo) throws PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFontMap drFonts = docProcessor.getFontContext().getDrFonts();
        if (showStringList == null || showStringList.isEmpty()) {
            return true;
        }
        if (!validationHandler.beginFontScan(name, font)) {
            return false;
        }
        PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes = new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>();
        int objectNumber = font != null ? font.getCosObject().getObjNum() : 0;
        int genNumber = font != null ? font.getCosDictionary().getObjGen() : 0;
        boolean willEmbed = false;
        try {
            if (font == null) {
                throw new PDFInvalidDocumentException("could not parse the font dictionary");
            }
            Map<CosObject, PDFA2ErrorSet<PDFA2AbstractFontErrorCode>> fontDictErrors = docProcessor.getFontContext().getFontDictErrors();
            Map<PDFFont, UnembeddedFontInfo> unembeddedFonts = docProcessor.getFontContext().getUnembeddedFonts();
            HashSet<Integer> referencedCharCodes = ReferencedFontInfoProcessor.getReferencedCharCodes(font, showStringList);
            TreeSet<Integer> tSet = new TreeSet<Integer>();
            tSet.addAll(referencedCharCodes);
            boolean detectedSkippedChars = false;
            try {
                if (font != null && showStringList != null) {
                    block6: for (ASString showString : showStringList) {
                        if (showString == null) continue;
                        List charCodes = font.getCharCodes(showString.getBytes(), false);
                        for (List charCodeInfo : charCodes) {
                            byte[] charCodeBytes = (byte[])charCodeInfo.get(0);
                            if (charCodeBytes != null) continue;
                            detectedSkippedChars = true;
                            continue block6;
                        }
                    }
                }
            }
            catch (PDFInvalidDocumentException e) {
                if (!(e.getCause() instanceof MissingResourceException)) {
                    throw e;
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            if (detectedSkippedChars) {
                docProcessor.setSkippedCharacters(true);
                if (conversionHandler == null) {
                    errorCodes.addErrorCode(new PDFA2FontErrorNotDefGlyphUsed(objectNumber, genNumber));
                }
            }
            if (fontDictErrors.containsKey(font.getCosObject()) && !(font instanceof PDFFontType3)) {
                PDFA2ErrorSet<PDFA2AbstractFontErrorCode> referencedGlyphErrorSet;
                errorCodes = fontDictErrors.get(font.getCosObject());
                if (PDFFontUtils.isFontEmbedded(font) && (referencedGlyphErrorSet = ReferencedFontInfoProcessor.getReferencedGlyphErrors(font, referencedCharCodes)) != null) {
                    referencedGlyphErrorSet.mergeErrorSet(errorCodes);
                    errorCodes = referencedGlyphErrorSet;
                }
                willEmbed = FontProcessor.willEmbed(font, errorCodes, conversionHandler, conversionOptions);
            } else {
                PDFA2ErrorSet<PDFA2AbstractFontErrorCode> error;
                if (conversionHandler != null && drFonts != null && drFonts.containsValue(font)) {
                    CosCloneMgr cosCloneMgr = new CosCloneMgr(font.getPDFDocument().getCosDocument());
                    PDFFont newFont = null;
                    if (font instanceof PDFFontSimple) {
                        ASName subType = font.getSubtype();
                        newFont = PDFFontSimple.getInstance(cosCloneMgr.clone(font.getCosObject()), subType);
                    } else if (font instanceof PDFFontType0) {
                        newFont = PDFFontType0.getInstance(cosCloneMgr.clone(font.getCosObject()));
                    } else {
                        throw new PDFInvalidDocumentException("unknown font type");
                    }
                    drFonts.set(name, newFont);
                }
                if (!FontProcessor.processFontMetadata(docProcessor, font, conversionHandler, conversionOptions, validationHandler, validationOptions)) {
                    return false;
                }
                ASName fontName = font.getBaseFont();
                if (fontName != null && !PDFText.isValidUTF8(fontName.getBytes())) {
                    errorCodes.addErrorCode(new PDFA2FontErrorNameNotUTF8(fontName.asString(), objectNumber, genNumber));
                }
                if ((error = Type0FontProcessor.processType0FontErrors(font, conversionHandler, docProcessor.getFontContext().getCMapsEmbedded(), referencedCharCodes, conformance)) == null) {
                    return false;
                }
                errorCodes.mergeErrorSet(error);
                error = Type1FontProcessor.processType1FontErrors(font, conversionHandler, referencedCharCodes, conformance);
                if (error == null) {
                    return false;
                }
                errorCodes.mergeErrorSet(error);
                error = TrueTypeFontProcessor.processTrueTypeFontErrors(font, conversionHandler, referencedCharCodes, conformance);
                if (error == null) {
                    return false;
                }
                errorCodes.mergeErrorSet(error);
                error = Type3FontProcessor.processType3FontErrors(font, referencedCharCodes, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, transparencyInfo, conformance);
                if (error == null) {
                    return false;
                }
                errorCodes.mergeErrorSet(error);
                if (!PDFFontUtils.isFontEmbedded(font)) {
                    errorCodes.addErrorCode(new PDFA2FontErrorFontNotEmbedded(objectNumber, genNumber));
                } else {
                    errorCodes.mergeErrorSet(ReferencedFontInfoProcessor.getReferencedGlyphErrors(font, referencedCharCodes));
                }
                willEmbed = FontProcessor.willEmbed(font, errorCodes, conversionHandler, conversionOptions);
                if (!willEmbed && (errorCodes = WidthsProcessor.processWidths(font, tSet, showStringList, conversionHandler, errorCodes, docProcessor.getFontContext())) == null) {
                    return false;
                }
                fontDictErrors.put(font.getCosObject(), errorCodes);
            }
            if (errorCodes.hasErrors() && willEmbed) {
                if (font instanceof PDFFontSimple) {
                    docProcessor.getFontContext().addCharcodesForsimpleFont((PDFFontSimple)font, referencedCharCodes);
                }
                if (font.getAFEFont() == null && FontProcessor.hasAtleastOneValidString(showStringList)) {
                    errorCodes.addErrorCode(new PDFA2FontErrorEmbeddingFailedFontNotInFontSet(objectNumber, genNumber));
                    willEmbed = false;
                } else {
                    HashSet<Integer> newCharCodes = ReferencedFontInfoProcessor.getReferencedCharCodes(font, showStringList);
                    if (newCharCodes != null) {
                        BaseUnembeddedFontInfo existingUFInfo = null;
                        if (unembeddedFonts.containsKey(font)) {
                            existingUFInfo = unembeddedFonts.get(font);
                        }
                        if (existingUFInfo != null) {
                            Set<Integer> existingCharCodes = existingUFInfo.getCharCodes();
                            if (existingCharCodes != null) {
                                newCharCodes.addAll(existingCharCodes);
                            }
                            existingUFInfo.setCharCodes(newCharCodes);
                        } else {
                            UnembeddedFontInfo uFInfo = new UnembeddedFontInfo(newCharCodes, errorCodes, name);
                            unembeddedFonts.put(font, uFInfo);
                        }
                        if (unembeddedFonts.get(font).getCharCodes().isEmpty()) {
                            docProcessor.getFontContext().getFontsWithoutTextShowString().add(font);
                        }
                    }
                }
            }
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(new PDFA2FontErrorPDFGeneralFailure(objectNumber, genNumber));
            willEmbed = false;
        }
        catch (FontEngineException e) {
            errorCodes.addErrorCode(new PDFA2FontErrorFontDataCorrupt(objectNumber, genNumber));
            willEmbed = false;
        }
        if (!willEmbed && errorCodes.hasErrors() && !validationHandler.fontError(errorCodes)) {
            return false;
        }
        return validationHandler.endFontScan();
    }

    private static boolean hasAtleastOneValidString(List<ASString> showStringList) {
        if (showStringList == null || showStringList.isEmpty()) {
            return false;
        }
        for (ASString showString : showStringList) {
            if (showString == null || showString.asString().length() == 0) continue;
            return true;
        }
        return false;
    }

    public static boolean process(PDFFontMap fontMap, ReferencedResources referencedResources, DocumentProcessor docProcessor, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler, TransparencyState transparencyInfo) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        HashMap referencedFonts;
        PDFFont font;
        if (fontMap == null || fontMap.isEmpty()) {
            return true;
        }
        HashMap invisibleFontsMap = referencedResources.getInvisibleFontMap();
        if (invisibleFontsMap != null && !invisibleFontsMap.isEmpty()) {
            for (Map.Entry entry : invisibleFontsMap.entrySet()) {
                ASName invisibleFName = (ASName)entry.getKey();
                List showStringList = (List)entry.getValue();
                font = fontMap.get(invisibleFName);
                if (font == null) continue;
                PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes = new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>();
                HashSet<Integer> referencedCharCodes = ReferencedFontInfoProcessor.getReferencedCharCodes(font, showStringList);
                FontProcessorUtils.processToUnicodeRequirement(conversionHandler, referencedCharCodes, errorCodes, font, conformance);
                if (!errorCodes.hasErrors()) continue;
                validationHandler.fontError(errorCodes);
            }
        }
        if ((referencedFonts = referencedResources.getFontMap()) == null || referencedFonts.isEmpty()) {
            return true;
        }
        Iterator keyIter = referencedFonts.keySet().iterator();
        while (keyIter.hasNext()) {
            List showStringList = null;
            ASName name = (ASName)keyIter.next();
            if (referencedFonts != null && referencedFonts.containsKey(name)) {
                showStringList = (List)referencedFonts.get(name);
            }
            if ((font = fontMap.get(name)) == null ? !FontProcessor.processBadFont(name, fontMap, showStringList, validationHandler) : !FontProcessor.process(name, font, showStringList, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, transparencyInfo)) {
                return false;
            }
            if (referencedFonts == null || !referencedFonts.containsKey(name)) continue;
            referencedFonts.put(name, null);
        }
        return true;
    }
}

