/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.error;

import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractErrorCode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PDFA2ErrorSet<T extends PDFA2AbstractErrorCode> {
    private Set<T> errorCodes;

    public PDFA2ErrorSet() {
        this.errorCodes = new HashSet<T>();
    }

    public PDFA2ErrorSet(int size) {
        this.errorCodes = new HashSet<T>(size);
    }

    public PDFA2ErrorSet(T errorCode) {
        this.errorCodes = new HashSet<T>(1);
        this.errorCodes.add(errorCode);
    }

    public PDFA2ErrorSet(PDFA2ErrorSet<T> set) {
        this.errorCodes = new HashSet<T>();
        this.mergeErrorSet(set);
    }

    public void mergeErrorSet(PDFA2ErrorSet<T> set) {
        if (set != null && set.getErrorCodes() != null) {
            if (PDFUtil.logDebugMessages() && set.hasErrors()) {
                PDFUtil.logDebug("Merge error code to this: " + System.identityHashCode(this) + ", this.errorCodes: " + System.identityHashCode(this.errorCodes) + ", set: " + set.toString());
            }
            this.errorCodes.addAll(set.getErrorCodes());
        }
    }

    public void addErrorCode(T errorCode) {
        if (PDFUtil.logDebugMessages()) {
            PDFUtil.logDebug("Added error code to this: " + System.identityHashCode(this) + ", this.errorCodes: " + System.identityHashCode(this.errorCodes) + ", errorCode: " + errorCode.toString());
        }
        this.errorCodes.add(errorCode);
    }

    public Set<T> getErrorCodes() {
        return this.errorCodes;
    }

    public void unSetErrorCode(Class classType) {
        Iterator<T> itr = this.errorCodes.iterator();
        while (itr.hasNext()) {
            if (((PDFA2AbstractErrorCode)itr.next()).getClass() != classType) continue;
            itr.remove();
        }
    }

    public boolean hasErrors() {
        return !this.errorCodes.isEmpty();
    }

    public boolean errorCodeSet(Class classType) {
        Iterator<T> itr = this.errorCodes.iterator();
        while (itr.hasNext()) {
            if (((PDFA2AbstractErrorCode)itr.next()).getClass() != classType) continue;
            return true;
        }
        return false;
    }

    public void removeAllErrorCodes() {
        if (PDFUtil.logDebugMessages()) {
            PDFUtil.logDebug("removeAllErrorCodes. this: " + System.identityHashCode(this) + ", errorCodes.hash: " + System.identityHashCode(this.errorCodes));
        }
        this.errorCodes.clear();
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        Iterator<T> itr = this.errorCodes.iterator();
        PDFA2AbstractErrorCode errorCode = null;
        String errorSource = null;
        String className = null;
        while (itr.hasNext()) {
            errorCode = (PDFA2AbstractErrorCode)itr.next();
            className = errorCode.getClass().getName();
            errorSource = className.substring(className.lastIndexOf(46) + 1);
            errorSource = errorSource.substring(0, errorSource.indexOf("Error") + 5);
            strBuilder.append(errorSource).append(": ").append(errorCode).append("\n");
        }
        return strBuilder.toString();
    }
}

