/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.xmp;

import com.adobe.internal.pdftoolkit.services.pdfa.xmp.MetadataUsageTreeNode;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPSimpleType;

class XMPText
extends XMPSimpleType {
    private static XMPText _xmpText = new XMPText();
    private static final String PDFAIDNS = "http://www.aiim.org/pdfa/ns/id/";

    private XMPText() {
    }

    public static XMPText getInstance() {
        return _xmpText;
    }

    @Override
    public boolean isValid(MetadataUsageTreeNode a) {
        if (!super.isValid(a)) {
            return false;
        }
        String value = a.getValue();
        if (a.getNameSpaceURI() != null && a.getNameSpaceURI().equalsIgnoreCase("http://ns.adobe.com/photoshop/1.0/") && a.getName() != null && a.getName().equals("Category")) {
            char[] chars = value.toCharArray();
            if (chars.length > 3) {
                return false;
            }
            for (char ch : chars) {
                if (ch <= '\u007f' && ch >= '\u0000') continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValid(MetadataUsageTreeNode m, boolean closedChoice) {
        if (!closedChoice) {
            return this.isValid(m);
        }
        String value = m.getValue();
        if (m.getNameSpaceURI() != null && m.getNameSpaceURI().equalsIgnoreCase(PDFAIDNS) && m.getName() != null && m.getName().equals("conformance")) {
            return "A".equals(value) || "B".equals(value);
        }
        return true;
    }
}

